/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.dialect;

import org.apache.calcite.config.NullCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlAlienSystemTypeNameSpec;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlSubstringFunction;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.util.RelToSqlConverterUtil;

public class HiveSqlDialect
extends SqlDialect {
    public static final SqlDialect.Context DEFAULT_CONTEXT = SqlDialect.EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.HIVE).withNullCollation(NullCollation.LOW);
    public static final SqlDialect DEFAULT = new HiveSqlDialect(DEFAULT_CONTEXT);
    private final boolean emulateNullDirection;

    public HiveSqlDialect(SqlDialect.Context context) {
        super(context);
        this.emulateNullDirection = context.databaseMajorVersion() < 2 || context.databaseMajorVersion() == 2 && context.databaseMinorVersion() < 1;
    }

    @Override
    protected boolean allowsAs() {
        return false;
    }

    @Override
    public boolean supportsAliasedValues() {
        return false;
    }

    @Override
    public void unparseOffsetFetch(SqlWriter writer, SqlNode offset, SqlNode fetch) {
        this.unparseFetchUsingLimit(writer, offset, fetch);
    }

    @Override
    public SqlNode emulateNullDirection(SqlNode node, boolean nullsFirst, boolean desc) {
        if (this.emulateNullDirection) {
            return this.emulateNullDirectionWithIsNull(node, nullsFirst, desc);
        }
        return null;
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        switch (call.getKind()) {
            case POSITION: {
                SqlWriter.Frame frame = writer.startFunCall("INSTR");
                writer.sep(",");
                ((SqlNode)call.operand(1)).unparse(writer, leftPrec, rightPrec);
                writer.sep(",");
                ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
                if (3 == call.operandCount()) {
                    throw new RuntimeException("3rd operand Not Supported for Function INSTR in Hive");
                }
                writer.endFunCall(frame);
                break;
            }
            case MOD: {
                SqlBinaryOperator op = SqlStdOperatorTable.PERCENT_REMAINDER;
                SqlSyntax.BINARY.unparse(writer, op, call, leftPrec, rightPrec);
                break;
            }
            case TRIM: {
                RelToSqlConverterUtil.unparseHiveTrim(writer, call, leftPrec, rightPrec);
                break;
            }
            case OTHER_FUNCTION: {
                if (call.getOperator() instanceof SqlSubstringFunction) {
                    SqlWriter.Frame funCallFrame = writer.startFunCall(call.getOperator().getName());
                    ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
                    writer.sep(",", true);
                    ((SqlNode)call.operand(1)).unparse(writer, leftPrec, rightPrec);
                    if (3 == call.operandCount()) {
                        writer.sep(",", true);
                        ((SqlNode)call.operand(2)).unparse(writer, leftPrec, rightPrec);
                    }
                    writer.endFunCall(funCallFrame);
                    break;
                }
                super.unparseCall(writer, call, leftPrec, rightPrec);
                break;
            }
            default: {
                super.unparseCall(writer, call, leftPrec, rightPrec);
            }
        }
    }

    @Override
    public boolean supportsCharSet() {
        return false;
    }

    @Override
    public boolean supportsGroupByWithRollup() {
        return true;
    }

    @Override
    public boolean supportsGroupByWithCube() {
        return true;
    }

    @Override
    public boolean supportsNestedAggregations() {
        return false;
    }

    @Override
    public SqlNode getCastSpec(RelDataType type) {
        if (type instanceof BasicSqlType) {
            switch (type.getSqlTypeName()) {
                case INTEGER: {
                    SqlAlienSystemTypeNameSpec typeNameSpec = new SqlAlienSystemTypeNameSpec("INT", type.getSqlTypeName(), SqlParserPos.ZERO);
                    return new SqlDataTypeSpec(typeNameSpec, SqlParserPos.ZERO);
                }
            }
        }
        return super.getCastSpec(type);
    }
}

