/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import java.util.Arrays;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;

class SqlItemOperator
extends SqlSpecialOperator {
    private static final SqlSingleOperandTypeChecker ARRAY_OR_MAP = OperandTypes.or(OperandTypes.family(SqlTypeFamily.ARRAY), OperandTypes.family(SqlTypeFamily.MAP), OperandTypes.family(SqlTypeFamily.ANY));

    SqlItemOperator() {
        super("ITEM", SqlKind.ITEM, 100, true, null, null, null);
    }

    @Override
    public SqlSpecialOperator.ReduceResult reduceExpr(int ordinal, SqlSpecialOperator.TokenSequence list) {
        SqlNode left = list.node(ordinal - 1);
        SqlNode right = list.node(ordinal + 1);
        return new SqlSpecialOperator.ReduceResult(this, ordinal - 1, ordinal + 2, this.createCall(SqlParserPos.sum(Arrays.asList(left.getParserPosition(), right.getParserPosition(), list.pos(ordinal))), left, right));
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, 0);
        SqlWriter.Frame frame = writer.startList("[", "]");
        ((SqlNode)call.operand(1)).unparse(writer, 0, 0);
        writer.endList(frame);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(2);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        SqlNode left = callBinding.operand(0);
        SqlNode right = callBinding.operand(1);
        if (!ARRAY_OR_MAP.checkSingleOperandType(callBinding, left, 0, throwOnFailure)) {
            return false;
        }
        SqlSingleOperandTypeChecker checker = this.getChecker(callBinding);
        return checker.checkSingleOperandType(callBinding, right, 0, throwOnFailure);
    }

    private SqlSingleOperandTypeChecker getChecker(SqlCallBinding callBinding) {
        RelDataType operandType = callBinding.getOperandType(0);
        switch (operandType.getSqlTypeName()) {
            case ARRAY: {
                return OperandTypes.family(SqlTypeFamily.INTEGER);
            }
            case MAP: {
                return OperandTypes.family(operandType.getKeyType().getSqlTypeName().getFamily());
            }
            case ROW: {
                return OperandTypes.and(OperandTypes.LITERAL, OperandTypes.CHARACTER);
            }
            case ANY: 
            case DYNAMIC_STAR: {
                return OperandTypes.or(OperandTypes.family(SqlTypeFamily.INTEGER), OperandTypes.family(SqlTypeFamily.CHARACTER));
            }
        }
        throw callBinding.newValidationSignatureError();
    }

    @Override
    public String getAllowedSignatures(String name) {
        return "<ARRAY>[<INTEGER>]\n<MAP>[<VALUE>]";
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType operandType = opBinding.getOperandType(0);
        switch (operandType.getSqlTypeName()) {
            case ARRAY: {
                return typeFactory.createTypeWithNullability(operandType.getComponentType(), true);
            }
            case MAP: {
                return typeFactory.createTypeWithNullability(operandType.getValueType(), true);
            }
            case ROW: {
                String fieldName = opBinding.getOperandLiteralValue(1, String.class);
                RelDataTypeField field = operandType.getField(fieldName, false, false);
                if (field == null) {
                    throw new AssertionError((Object)("Cannot infer type of field '" + fieldName + "' within ROW type: " + operandType));
                }
                RelDataType fieldType = field.getType();
                if (operandType.isNullable()) {
                    fieldType = typeFactory.createTypeWithNullability(fieldType, true);
                }
                return fieldType;
            }
            case ANY: 
            case DYNAMIC_STAR: {
                return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.ANY), true);
            }
        }
        throw new AssertionError();
    }
}

