/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.SortedSet;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableSortedMap;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableSortedSet;
import org.apache.flink.calcite.shaded.com.google.common.collect.TreeMultimap;

public class EquivalenceSet<E extends Comparable<E>> {
    private final Map<E, E> parents = new HashMap<E, E>();

    public E add(E e) {
        Comparable parent = (Comparable)this.parents.get(Objects.requireNonNull(e));
        if (parent == null) {
            this.parents.put(e, e);
            return e;
        }
        return (E)parent;
    }

    public E equiv(E e, E f) {
        E eParent = this.add(e);
        if (!eParent.equals(e)) {
            assert (((Comparable)this.parents.get(eParent)).equals(eParent));
            E root = this.equiv(eParent, f);
            this.parents.put(e, root);
            return root;
        }
        E fParent = this.add(f);
        if (!fParent.equals(f)) {
            assert (((Comparable)this.parents.get(fParent)).equals(fParent));
            E root = this.equiv(e, fParent);
            this.parents.put(f, root);
            return root;
        }
        int c = e.compareTo(f);
        if (c == 0) {
            return e;
        }
        if (c < 0) {
            this.parents.put(f, e);
            return e;
        }
        this.parents.put(e, f);
        return f;
    }

    public boolean areEquivalent(E e, E f) {
        Comparable eParent = (Comparable)this.parents.get(e);
        Comparable fParent = (Comparable)this.parents.get(f);
        return Objects.equals(eParent, fParent);
    }

    public SortedMap<E, SortedSet<E>> map() {
        TreeMultimap multimap = TreeMultimap.create();
        for (Map.Entry<E, E> entry : this.parents.entrySet()) {
            multimap.put(entry.getValue(), entry.getKey());
        }
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (Map.Entry entry : multimap.asMap().entrySet()) {
            builder.put(entry.getKey(), ImmutableSortedSet.copyOf((Collection)entry.getValue()));
        }
        return builder.build();
    }

    public void clear() {
        this.parents.clear();
    }

    public int size() {
        return this.parents.size();
    }

    public int classCount() {
        return new HashSet<E>(this.parents.values()).size();
    }
}

