/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.hive.ddl;

import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.flink.sql.parser.ddl.SqlAddReplaceColumns;
import org.apache.flink.sql.parser.hive.ddl.HiveDDLUtils;
import org.apache.flink.sql.parser.hive.ddl.SqlAlterHiveTable;
import org.apache.flink.sql.parser.hive.impl.ParseException;

public class SqlAlterHiveTableAddReplaceColumn
extends SqlAddReplaceColumns {
    private final SqlNodeList origColumns;
    private final boolean cascade;

    public SqlAlterHiveTableAddReplaceColumn(SqlParserPos pos, SqlIdentifier tableName, boolean cascade, SqlNodeList columns, boolean replace) throws ParseException {
        super(pos, tableName, columns, replace, new SqlNodeList(pos));
        this.origColumns = HiveDDLUtils.deepCopyColList(columns);
        HiveDDLUtils.convertDataTypes(columns);
        this.cascade = cascade;
        this.getProperties().add(HiveDDLUtils.toTableOption("alter.table.op", SqlAlterHiveTable.AlterTableOp.ALTER_COLUMNS.name(), pos));
        if (cascade) {
            this.getProperties().add(HiveDDLUtils.toTableOption("alter.column.cascade", "true", pos));
        }
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("ALTER TABLE");
        this.tableIdentifier.unparse(writer, leftPrec, rightPrec);
        SqlNodeList partitionSpec = this.getPartitionSpec();
        if (partitionSpec != null && partitionSpec.size() > 0) {
            writer.keyword("PARTITION");
            partitionSpec.unparse(writer, this.getOperator().getLeftPrec(), this.getOperator().getRightPrec());
        }
        if (this.isReplace()) {
            writer.keyword("REPLACE");
        } else {
            writer.keyword("ADD");
        }
        writer.keyword("COLUMNS");
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.create("sds"), "(", ")");
        for (SqlNode column : this.origColumns) {
            this.printIndent(writer);
            column.unparse(writer, leftPrec, rightPrec);
        }
        writer.newlineAndIndent();
        writer.endList(frame);
        if (this.cascade) {
            writer.keyword("CASCADE");
        } else {
            writer.keyword("RESTRICT");
        }
    }
}

