/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.inference;

import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.functions.inference.ArgumentCountRange;
import org.apache.flink.table.planner.functions.inference.CallBindingCallContext;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeInferenceUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;

@Internal
public final class TypeInferenceOperandChecker
implements SqlOperandTypeChecker {
    private final DataTypeFactory dataTypeFactory;
    private final FunctionDefinition definition;
    private final TypeInference typeInference;
    private final SqlOperandCountRange countRange;

    public TypeInferenceOperandChecker(DataTypeFactory dataTypeFactory, FunctionDefinition definition, TypeInference typeInference) {
        this.dataTypeFactory = dataTypeFactory;
        this.definition = definition;
        this.typeInference = typeInference;
        this.countRange = new ArgumentCountRange(typeInference.getInputTypeStrategy().getArgumentCount());
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        CallBindingCallContext callContext = new CallBindingCallContext(this.dataTypeFactory, this.definition, callBinding, null);
        try {
            return this.checkOperandTypesOrError(callBinding, callContext);
        }
        catch (ValidationException e) {
            if (throwOnFailure) {
                throw TypeInferenceUtil.createInvalidCallException((CallContext)callContext, (ValidationException)e);
            }
            return false;
        }
        catch (Throwable t) {
            throw TypeInferenceUtil.createUnexpectedException((CallContext)callContext, (Throwable)t);
        }
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return this.countRange;
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        return TypeInferenceUtil.generateSignature((TypeInference)this.typeInference, (String)opName, (FunctionDefinition)this.definition);
    }

    @Override
    public SqlOperandTypeChecker.Consistency getConsistency() {
        return SqlOperandTypeChecker.Consistency.NONE;
    }

    @Override
    public boolean isOptional(int i) {
        return false;
    }

    private boolean checkOperandTypesOrError(SqlCallBinding callBinding, CallContext callContext) {
        CallContext adaptedCallContext;
        try {
            adaptedCallContext = TypeInferenceUtil.adaptArguments((TypeInference)this.typeInference, (CallContext)callContext, null);
        }
        catch (ValidationException e) {
            throw TypeInferenceUtil.createInvalidInputException((TypeInference)this.typeInference, (CallContext)callContext, (ValidationException)e);
        }
        this.insertImplicitCasts(callBinding, adaptedCallContext.getArgumentDataTypes());
        return true;
    }

    private void insertImplicitCasts(SqlCallBinding callBinding, List<DataType> expectedDataTypes) {
        FlinkTypeFactory flinkTypeFactory = ShortcutUtils.unwrapTypeFactory(callBinding);
        List<SqlNode> operands = callBinding.operands();
        for (int i = 0; i < operands.size(); ++i) {
            LogicalType expectedType = expectedDataTypes.get(i).getLogicalType();
            LogicalType argumentType = FlinkTypeFactory.toLogicalType(callBinding.getOperandType(i));
            if (LogicalTypeCasts.supportsAvoidingCast((LogicalType)argumentType, (LogicalType)expectedType)) continue;
            RelDataType expectedRelDataType = flinkTypeFactory.createFieldTypeFromLogicalType(expectedType);
            SqlNode castedOperand = this.castTo(operands.get(i), expectedRelDataType);
            callBinding.getCall().setOperand(i, castedOperand);
            this.updateInferredType(callBinding.getValidator(), castedOperand, expectedRelDataType);
        }
    }

    private SqlNode castTo(SqlNode node, RelDataType type) {
        return SqlStdOperatorTable.CAST.createCall(SqlParserPos.ZERO, node, SqlTypeUtil.convertTypeToSpec(type).withNullable(type.isNullable()));
    }

    private void updateInferredType(SqlValidator validator, SqlNode node, RelDataType type) {
        validator.setValidatedNodeType(node, type);
        SqlValidatorNamespace namespace = validator.getNamespace(node);
        if (namespace != null) {
            namespace.setType(type);
        }
    }
}

