/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DatabindContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.LogicalTypeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.KeyValueDataType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

@Internal
final class DataTypeJsonDeserializer
extends StdDeserializer<DataType> {
    DataTypeJsonDeserializer() {
        super(DataType.class);
    }

    public DataType deserialize(JsonParser jsonParser, DeserializationContext ctx) throws IOException {
        JsonNode dataTypeNode = (JsonNode)jsonParser.readValueAsTree();
        SerdeContext serdeContext = SerdeContext.get((DatabindContext)ctx);
        return DataTypeJsonDeserializer.deserialize(dataTypeNode, serdeContext);
    }

    static DataType deserialize(JsonNode dataTypeNode, SerdeContext serdeContext) {
        if (dataTypeNode.isTextual()) {
            return DataTypeJsonDeserializer.deserializeWithCompactSerialization(dataTypeNode, serdeContext);
        }
        return DataTypeJsonDeserializer.deserializeWithExtendedSerialization(dataTypeNode, serdeContext);
    }

    private static DataType deserializeWithCompactSerialization(JsonNode logicalTypeNode, SerdeContext serdeContext) {
        LogicalType logicalType = LogicalTypeJsonDeserializer.deserialize(logicalTypeNode, serdeContext);
        return DataTypes.of((LogicalType)logicalType);
    }

    private static DataType deserializeWithExtendedSerialization(JsonNode dataTypeNode, SerdeContext serdeContext) {
        JsonNode logicalTypeNode = dataTypeNode.has("logicalType") ? dataTypeNode.get("logicalType") : dataTypeNode;
        LogicalType logicalType = LogicalTypeJsonDeserializer.deserialize(logicalTypeNode, serdeContext);
        return DataTypeJsonDeserializer.deserializeClass(logicalType, dataTypeNode, serdeContext);
    }

    private static DataType deserializeClass(LogicalType logicalType, @Nullable JsonNode parentNode, SerdeContext serdeContext) {
        DataType dataType;
        if (parentNode == null) {
            return DataTypes.of((LogicalType)logicalType);
        }
        switch (logicalType.getTypeRoot()) {
            case ARRAY: 
            case MULTISET: {
                DataType elementDataType = DataTypeJsonDeserializer.deserializeClass((LogicalType)logicalType.getChildren().get(0), parentNode.get("elementClass"), serdeContext);
                dataType = new CollectionDataType(logicalType, elementDataType);
                break;
            }
            case MAP: {
                MapType mapType = (MapType)logicalType;
                DataType keyDataType = DataTypeJsonDeserializer.deserializeClass(mapType.getKeyType(), parentNode.get("keyClass"), serdeContext);
                DataType valueDataType = DataTypeJsonDeserializer.deserializeClass(mapType.getValueType(), parentNode.get("valueClass"), serdeContext);
                dataType = new KeyValueDataType((LogicalType)mapType, keyDataType, valueDataType);
                break;
            }
            case ROW: 
            case STRUCTURED_TYPE: {
                List fieldNames = LogicalTypeChecks.getFieldNames((LogicalType)logicalType);
                List fieldTypes = LogicalTypeChecks.getFieldTypes((LogicalType)logicalType);
                ArrayNode fieldNodes = (ArrayNode)parentNode.get("fields");
                HashMap fieldNodesByName = new HashMap();
                if (fieldNodes != null) {
                    fieldNodes.forEach(fieldNode -> fieldNodesByName.put(fieldNode.get("name").asText(), fieldNode));
                }
                List fieldDataTypes = IntStream.range(0, fieldNames.size()).mapToObj(i -> {
                    String fieldName = (String)fieldNames.get(i);
                    LogicalType fieldType = (LogicalType)fieldTypes.get(i);
                    return DataTypeJsonDeserializer.deserializeClass(fieldType, (JsonNode)fieldNodesByName.get(fieldName), serdeContext);
                }).collect(Collectors.toList());
                dataType = new FieldsDataType(logicalType, fieldDataTypes);
                break;
            }
            case DISTINCT_TYPE: {
                DistinctType distinctType = (DistinctType)logicalType;
                dataType = DataTypeJsonDeserializer.deserializeClass(distinctType.getSourceType(), parentNode, serdeContext);
                break;
            }
            default: {
                dataType = DataTypes.of((LogicalType)logicalType);
            }
        }
        if (!parentNode.has("conversionClass")) {
            return dataType;
        }
        Class<?> conversionClass = JsonSerdeUtil.loadClass(parentNode.get("conversionClass").asText(), serdeContext, String.format("conversion class of data type '%s'", dataType));
        return (DataType)dataType.bridgedTo(conversionClass);
    }
}

