/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.rex.RexWindowBounds;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.table.api.TableException;

@Internal
final class RexWindowBoundJsonDeserializer
extends StdDeserializer<RexWindowBound> {
    RexWindowBoundJsonDeserializer() {
        super(RexWindowBound.class);
    }

    public RexWindowBound deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String kind;
        JsonNode jsonNode = (JsonNode)jsonParser.readValueAsTree();
        switch (kind = jsonNode.get("kind").asText().toUpperCase()) {
            case "CURRENT_ROW": {
                return RexWindowBounds.CURRENT_ROW;
            }
            case "UNBOUNDED_FOLLOWING": {
                return RexWindowBounds.UNBOUNDED_FOLLOWING;
            }
            case "UNBOUNDED_PRECEDING": {
                return RexWindowBounds.UNBOUNDED_PRECEDING;
            }
            case "BOUNDED_WINDOW": {
                RexNode offset = null;
                if (jsonNode.get("offset") != null) {
                    offset = (RexNode)deserializationContext.readValue(jsonNode.get("offset").traverse(jsonParser.getCodec()), RexNode.class);
                }
                if (offset != null && jsonNode.get("isFollowing") != null) {
                    return RexWindowBounds.following(offset);
                }
                if (offset != null && jsonNode.get("isPreceding") != null) {
                    return RexWindowBounds.preceding(offset);
                }
                throw new TableException("Unknown RexWindowBound: " + jsonNode.toString());
            }
        }
        throw new TableException("Unknown RexWindowBound: " + jsonNode.toString());
    }
}

