/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1Set;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.PKCS12CRLBag;
import oracle.security.crypto.cert.PKCS12CertBag;
import oracle.security.crypto.cert.PKCS12KeyBag;
import oracle.security.crypto.cert.PKCS12Safe;
import oracle.security.crypto.cert.PKCS12SafeContentsBag;
import oracle.security.crypto.cert.PKCS12SecretBag;
import oracle.security.crypto.cert.PKCS12ShroudedKeyBag;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public abstract class PKCS12Bag
implements ASN1Object,
Externalizable {
    String friendlyName;
    byte[] localKeyID;

    protected PKCS12Bag() {
    }

    public static PKCS12Bag inputBag(PKCS12Safe parent, InputStream is) throws IOException {
        return PKCS12Bag.inputBag(parent, new ASN1Sequence(is));
    }

    static PKCS12Bag inputBag(PKCS12Safe parent, ASN1Sequence s) throws IOException {
        try {
            ASN1ObjectID bt = (ASN1ObjectID)s.elementAt(0);
            PKCS12Bag bag = null;
            if (bt.equals((Object)new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 1))) {
                bag = new PKCS12KeyBag(parent, s);
            } else if (bt.equals((Object)new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 2))) {
                bag = new PKCS12ShroudedKeyBag(parent, s);
            } else if (bt.equals((Object)new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 3))) {
                bag = new PKCS12CertBag(parent, s);
            } else if (bt.equals((Object)new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 4))) {
                bag = new PKCS12CRLBag(parent, s);
            } else if (bt.equals((Object)new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 5))) {
                bag = new PKCS12SecretBag(parent, s);
            } else if (bt.equals((Object)new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 6))) {
                bag = new PKCS12SafeContentsBag(parent, s);
            } else {
                throw new IOException("Unknown PKCS#12 bag type: " + bt);
            }
            if (s.size() > 2) {
                ASN1Set ba = (ASN1Set)s.elementAt(2);
                ArrayList vec = ba.elementsAsList();
                int size = vec.size();
                for (int i = 0; i < size; ++i) {
                    ASN1Set v;
                    ASN1Sequence a = (ASN1Sequence)vec.get(i);
                    ASN1ObjectID at = (ASN1ObjectID)a.elementAt(0);
                    if (at.equals(ASN1Utils.pkcsID, 9, 20)) {
                        v = (ASN1Set)a.elementAt(1);
                        String fn = ((ASN1String)v.elementAt(0)).getValue();
                        bag.setFriendlyName(fn);
                        continue;
                    }
                    if (!at.equals(ASN1Utils.pkcsID, 9, 21)) continue;
                    v = (ASN1Set)a.elementAt(1);
                    byte[] id = ((ASN1OctetString)v.elementAt(0)).getValue();
                    bag.setLocalKeyID(id);
                }
            }
            return bag;
        }
        catch (ClassCastException ex) {
            throw new ASN1FormatException(ex.toString());
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ASN1FormatException(ex.toString());
        }
    }

    abstract void reset();

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        this.reset();
    }

    public byte[] getLocalKeyID() {
        return this.localKeyID;
    }

    public void setLocalKeyID(byte[] localKeyID) {
        this.localKeyID = localKeyID;
        this.reset();
    }

    public ASN1Set outputAttrsASN1() {
        ASN1Set as;
        ASN1Sequence a;
        ASN1Set ba = new ASN1Set();
        if (this.friendlyName != null) {
            a = new ASN1Sequence();
            a.addElement((ASN1Object)new ASN1ObjectID(ASN1Utils.pkcsID, 9, 20));
            as = new ASN1Set();
            as.addElement((ASN1Object)new ASN1String(this.friendlyName, 30));
            a.addElement((ASN1Object)as);
            ba.addElement((ASN1Object)a);
        }
        if (this.localKeyID != null) {
            a = new ASN1Sequence();
            a.addElement((ASN1Object)new ASN1ObjectID(ASN1Utils.pkcsID, 9, 21));
            as = new ASN1Set();
            as.addElement((ASN1Object)new ASN1OctetString(this.localKeyID));
            a.addElement((ASN1Object)as);
            ba.addElement((ASN1Object)a);
        }
        if (ba.elementsAsList().size() > 0) {
            return ba;
        }
        return null;
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes((Streamable)this));
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException((Exception)ex);
        }
        this.input((InputStream)new UnsyncByteArrayInputStream(data));
    }
}

