/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream;

import java.io.IOException;
import java.io.InputStream;
import java.lang.constant.Constable;
import org.infinispan.protostream.TagHandler;
import org.infinispan.protostream.TagReader;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.protostream.descriptors.WireType;
import org.infinispan.protostream.impl.TagReaderImpl;

public final class ProtobufParser {
    public static final ProtobufParser INSTANCE = new ProtobufParser();

    public void parse(TagHandler tagHandler, Descriptor messageDescriptor, InputStream input) throws IOException {
        if (messageDescriptor == null) {
            throw new IllegalArgumentException("messageDescriptor cannot be null");
        }
        TagReaderImpl in = TagReaderImpl.newInstance(null, input);
        this.parseInternal(tagHandler, messageDescriptor, in);
    }

    public void parse(TagHandler tagHandler, Descriptor messageDescriptor, byte[] buf, int off, int len) throws IOException {
        if (messageDescriptor == null) {
            throw new IllegalArgumentException("messageDescriptor cannot be null");
        }
        TagReaderImpl in = TagReaderImpl.newInstance(null, buf, off, len);
        this.parseInternal(tagHandler, messageDescriptor, in);
    }

    public void parse(TagHandler tagHandler, Descriptor messageDescriptor, byte[] buf) throws IOException {
        if (messageDescriptor == null) {
            throw new IllegalArgumentException("messageDescriptor cannot be null");
        }
        TagReaderImpl in = TagReaderImpl.newInstance(null, buf);
        this.parseInternal(tagHandler, messageDescriptor, in);
    }

    public void parse(TagHandler tagHandler, Descriptor messageDescriptor, TagReader in) throws IOException {
        if (messageDescriptor == null) {
            throw new IllegalArgumentException("messageDescriptor cannot be null");
        }
        this.parseInternal(tagHandler, messageDescriptor, in);
    }

    private void parseInternal(TagHandler tagHandler, Descriptor messageDescriptor, TagReader in) throws IOException {
        tagHandler.onStart(messageDescriptor);
        this.parseMessage(tagHandler, messageDescriptor, in);
        tagHandler.onEnd();
    }

    private void parseMessage(TagHandler tagHandler, Descriptor messageDescriptor, TagReader in) throws IOException {
        int tag;
        block21: while ((tag = in.readTag()) != 0) {
            int fieldNumber = WireType.getTagFieldNumber(tag);
            WireType wireType = WireType.fromTag(tag);
            FieldDescriptor fd = messageDescriptor != null ? messageDescriptor.findFieldByNumber(fieldNumber) : null;
            switch (wireType) {
                case LENGTH_DELIMITED: {
                    if (fd == null) {
                        byte[] value = in.readByteArray();
                        tagHandler.onTag(fieldNumber, null, value);
                        continue block21;
                    }
                    if (fd.getType() == Type.STRING) {
                        String value = in.readString();
                        tagHandler.onTag(fieldNumber, fd, value);
                        continue block21;
                    }
                    if (fd.getType() == Type.BYTES) {
                        byte[] value = in.readByteArray();
                        tagHandler.onTag(fieldNumber, fd, value);
                        continue block21;
                    }
                    if (fd.getType() != Type.MESSAGE) continue block21;
                    int length = in.readUInt32();
                    int oldLimit = in.pushLimit(length);
                    tagHandler.onStartNested(fieldNumber, fd);
                    this.parseMessage(tagHandler, fd.getMessageType(), in);
                    tagHandler.onEndNested(fieldNumber, fd);
                    in.checkLastTagWas(0);
                    in.popLimit(oldLimit);
                    continue block21;
                }
                case START_GROUP: {
                    if (fd != null) {
                        tagHandler.onStartNested(fieldNumber, null);
                        this.parseMessage(tagHandler, null, in);
                        in.checkLastTagWas(WireType.makeTag(fieldNumber, 4));
                        tagHandler.onEndNested(fieldNumber, null);
                        continue block21;
                    }
                    tagHandler.onStartNested(fieldNumber, fd);
                    this.parseMessage(tagHandler, fd.getMessageType(), in);
                    in.checkLastTagWas(WireType.makeTag(fieldNumber, 4));
                    tagHandler.onEndNested(fieldNumber, fd);
                    continue block21;
                }
                case FIXED32: 
                case FIXED64: 
                case VARINT: {
                    Constable value;
                    if (fd == null) {
                        if (wireType == WireType.FIXED32) {
                            tagHandler.onTag(fieldNumber, null, in.readFixed32());
                            continue block21;
                        }
                        if (wireType == WireType.FIXED64) {
                            tagHandler.onTag(fieldNumber, null, in.readFixed64());
                            continue block21;
                        }
                        tagHandler.onTag(fieldNumber, null, in.readUInt64());
                        continue block21;
                    }
                    switch (fd.getType()) {
                        case DOUBLE: {
                            value = in.readDouble();
                            break;
                        }
                        case FLOAT: {
                            value = Float.valueOf(in.readFloat());
                            break;
                        }
                        case BOOL: {
                            value = Boolean.valueOf(in.readBool());
                            break;
                        }
                        case INT32: {
                            value = in.readInt32();
                            break;
                        }
                        case SFIXED32: {
                            value = in.readSFixed32();
                            break;
                        }
                        case FIXED32: {
                            value = in.readFixed32();
                            break;
                        }
                        case UINT32: {
                            value = in.readUInt32();
                            break;
                        }
                        case SINT32: {
                            value = in.readSInt32();
                            break;
                        }
                        case INT64: {
                            value = in.readInt64();
                            break;
                        }
                        case UINT64: {
                            value = in.readUInt64();
                            break;
                        }
                        case FIXED64: {
                            value = in.readFixed64();
                            break;
                        }
                        case SFIXED64: {
                            value = in.readSFixed64();
                            break;
                        }
                        case SINT64: {
                            value = in.readSInt64();
                            break;
                        }
                        case ENUM: {
                            value = in.readEnum();
                            break;
                        }
                        default: {
                            throw new IOException("Unexpected field type " + (Object)((Object)fd.getType()) + " for field " + fieldNumber);
                        }
                    }
                    tagHandler.onTag(fieldNumber, fd, value);
                    continue block21;
                }
            }
            throw new IOException("Found tag with invalid wire type : tag=" + tag + ", wireType=" + (Object)((Object)wireType));
        }
    }
}

