/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap.internal;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.bootstrap.internal.InstrumentationConfig;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;

public final class DeprecatedConfigProperties {
    private static final PatchLogger logger = PatchLogger.getLogger(DeprecatedConfigProperties.class.getName());

    public static boolean getBoolean(InstrumentationConfig config, String deprecatedPropertyName, String newPropertyName, boolean defaultValue) {
        DeprecatedConfigProperties.warnIfUsed(config, deprecatedPropertyName, newPropertyName);
        boolean value = config.getBoolean(deprecatedPropertyName, defaultValue);
        return config.getBoolean(newPropertyName, value);
    }

    public static List<String> getList(InstrumentationConfig config, String deprecatedPropertyName, String newPropertyName) {
        DeprecatedConfigProperties.warnIfUsed(config, deprecatedPropertyName, newPropertyName);
        List<String> value = config.getList(deprecatedPropertyName, Collections.emptyList());
        return config.getList(newPropertyName, value);
    }

    private static void warnIfUsed(InstrumentationConfig config, String deprecatedPropertyName, String newPropertyName) {
        if (config.getString(deprecatedPropertyName) != null) {
            logger.log(Level.WARNING, "Deprecated property \"{0}\" was used; use the \"{1}\" property instead", new Object[]{deprecatedPropertyName, newPropertyName});
        }
    }

    private DeprecatedConfigProperties() {
    }
}

