/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.shaded.io.micrometer.core.instrument.binder.cache;

import java.util.function.Function;
import java.util.function.ToLongFunction;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.statistics.StatisticsGateway;
import org.apache.kudu.shaded.io.micrometer.core.instrument.FunctionCounter;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Gauge;
import org.apache.kudu.shaded.io.micrometer.core.instrument.MeterRegistry;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Tag;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Tags;
import org.apache.kudu.shaded.io.micrometer.core.instrument.binder.cache.CacheMeterBinder;
import org.apache.kudu.shaded.io.micrometer.core.lang.NonNullApi;
import org.apache.kudu.shaded.io.micrometer.core.lang.NonNullFields;
import org.apache.kudu.shaded.io.micrometer.core.lang.Nullable;

@NonNullApi
@NonNullFields
public class EhCache2Metrics
extends CacheMeterBinder<Ehcache> {
    public EhCache2Metrics(Ehcache cache, Iterable<Tag> tags) {
        super(cache, cache.getName(), tags);
    }

    public static Ehcache monitor(MeterRegistry registry, Ehcache cache, String ... tags) {
        return EhCache2Metrics.monitor(registry, cache, Tags.of(tags));
    }

    public static Ehcache monitor(MeterRegistry registry, Ehcache cache, Iterable<Tag> tags) {
        new EhCache2Metrics(cache, tags).bindTo(registry);
        return cache;
    }

    @Override
    protected Long size() {
        return this.getOrDefault(StatisticsGateway::getSize, null);
    }

    @Override
    protected long hitCount() {
        return this.getOrDefault(StatisticsGateway::cacheHitCount, 0L);
    }

    @Override
    protected Long missCount() {
        return this.getOrDefault(StatisticsGateway::cacheMissCount, null);
    }

    @Override
    protected Long evictionCount() {
        return this.getOrDefault(StatisticsGateway::cacheEvictedCount, null);
    }

    @Override
    protected long putCount() {
        return this.getOrDefault(StatisticsGateway::cachePutCount, 0L);
    }

    @Override
    protected void bindImplementationSpecificMetrics(MeterRegistry registry) {
        StatisticsGateway stats = this.getStats();
        Gauge.builder("cache.remoteSize", stats, StatisticsGateway::getRemoteSize).tags(this.getTagsWithCacheName()).description("The number of entries held remotely in this cache").register(registry);
        FunctionCounter.builder("cache.removals", stats, StatisticsGateway::cacheRemoveCount).tags(this.getTagsWithCacheName()).description("Cache removals").register(registry);
        FunctionCounter.builder("cache.puts.added", stats, StatisticsGateway::cachePutAddedCount).tags(this.getTagsWithCacheName()).tags("result", "added").description("Cache puts resulting in a new key/value pair").register(registry);
        FunctionCounter.builder("cache.puts.added", stats, StatisticsGateway::cachePutUpdatedCount).tags(this.getTagsWithCacheName()).tags("result", "updated").description("Cache puts resulting in an updated value").register(registry);
        this.missMetrics(registry);
        this.commitTransactionMetrics(registry);
        this.rollbackTransactionMetrics(registry);
        this.recoveryTransactionMetrics(registry);
        Gauge.builder("cache.local.offheap.size", stats, StatisticsGateway::getLocalOffHeapSizeInBytes).tags(this.getTagsWithCacheName()).description("Local off-heap size").baseUnit("bytes").register(registry);
        Gauge.builder("cache.local.heap.size", stats, StatisticsGateway::getLocalHeapSizeInBytes).tags(this.getTagsWithCacheName()).description("Local heap size").baseUnit("bytes").register(registry);
        Gauge.builder("cache.local.disk.size", stats, StatisticsGateway::getLocalDiskSizeInBytes).tags(this.getTagsWithCacheName()).description("Local disk size").baseUnit("bytes").register(registry);
    }

    @Nullable
    private StatisticsGateway getStats() {
        Ehcache cache = (Ehcache)this.getCache();
        return cache != null ? cache.getStatistics() : null;
    }

    private void missMetrics(MeterRegistry registry) {
        StatisticsGateway stats = this.getStats();
        FunctionCounter.builder("cache.misses", stats, StatisticsGateway::cacheMissExpiredCount).tags(this.getTagsWithCacheName()).tags("reason", "expired").description("The number of times cache lookup methods have not returned a value, due to expiry").register(registry);
        FunctionCounter.builder("cache.misses", stats, StatisticsGateway::cacheMissNotFoundCount).tags(this.getTagsWithCacheName()).tags("reason", "notFound").description("The number of times cache lookup methods have not returned a value, because the key was not found").register(registry);
    }

    private void commitTransactionMetrics(MeterRegistry registry) {
        StatisticsGateway stats = this.getStats();
        FunctionCounter.builder("cache.xa.commits", stats, StatisticsGateway::xaCommitReadOnlyCount).tags(this.getTagsWithCacheName()).tags("result", "readOnly").description("Transaction commits that had a read-only result").register(registry);
        FunctionCounter.builder("cache.xa.commits", stats, StatisticsGateway::xaCommitExceptionCount).tags(this.getTagsWithCacheName()).tags("result", "exception").description("Transaction commits that failed").register(registry);
        FunctionCounter.builder("cache.xa.commits", stats, StatisticsGateway::xaCommitCommittedCount).tags(this.getTagsWithCacheName()).tags("result", "committed").description("Transaction commits that failed").register(registry);
    }

    private void rollbackTransactionMetrics(MeterRegistry registry) {
        StatisticsGateway stats = this.getStats();
        FunctionCounter.builder("cache.xa.rollbacks", stats, StatisticsGateway::xaRollbackExceptionCount).tags(this.getTagsWithCacheName()).tags("result", "exception").description("Transaction rollbacks that failed").register(registry);
        FunctionCounter.builder("cache.xa.rollbacks", stats, StatisticsGateway::xaRollbackSuccessCount).tags(this.getTagsWithCacheName()).tags("result", "success").description("Transaction rollbacks that failed").register(registry);
    }

    private void recoveryTransactionMetrics(MeterRegistry registry) {
        StatisticsGateway stats = this.getStats();
        FunctionCounter.builder("cache.xa.recoveries", stats, StatisticsGateway::xaRecoveryNothingCount).tags(this.getTagsWithCacheName()).tags("result", "nothing").description("Recovery transactions that recovered nothing").register(registry);
        FunctionCounter.builder("cache.xa.recoveries", stats, StatisticsGateway::xaRecoveryRecoveredCount).tags(this.getTagsWithCacheName()).tags("result", "success").description("Successful recovery transaction").register(registry);
    }

    @Nullable
    private Long getOrDefault(Function<StatisticsGateway, Long> function, @Nullable Long defaultValue) {
        StatisticsGateway ref = this.getStats();
        if (ref != null) {
            return function.apply(ref);
        }
        return defaultValue;
    }

    private long getOrDefault(ToLongFunction<StatisticsGateway> function, long defaultValue) {
        StatisticsGateway ref = this.getStats();
        if (ref != null) {
            return function.applyAsLong(ref);
        }
        return defaultValue;
    }
}

