/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Comparator;
import org.mapdb.BTreeMap;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Fun;
import org.mapdb.Serializer;
import org.mapdb.SerializerBase;

public abstract class BTreeKeySerializer<K> {
    public static final BTreeKeySerializer BASIC = new BasicKeySerializer(Serializer.BASIC);
    public static final BTreeKeySerializer<Long> ZERO_OR_POSITIVE_LONG = new BTreeKeySerializer<Long>(){

        @Override
        public void serialize(DataOutput out, int start, int end, Object[] keys) throws IOException {
            if (start >= end) {
                return;
            }
            long prev = (Long)keys[start];
            DataOutput2.packLong(out, prev);
            for (int i = start + 1; i < end; ++i) {
                long curr = (Long)keys[i];
                DataOutput2.packLong(out, curr - prev);
                prev = curr;
            }
        }

        @Override
        public Object[] deserialize(DataInput in, int start, int end, int size) throws IOException {
            Object[] ret = new Long[size];
            long prev = 0L;
            for (int i = start; i < end; ++i) {
                ret[i] = prev += DataInput2.unpackLong(in);
            }
            return ret;
        }

        @Override
        public Comparator<Long> getComparator() {
            return BTreeMap.COMPARABLE_COMPARATOR;
        }
    };
    public static final BTreeKeySerializer<Integer> ZERO_OR_POSITIVE_INT = new BTreeKeySerializer<Integer>(){

        @Override
        public void serialize(DataOutput out, int start, int end, Object[] keys) throws IOException {
            if (start >= end) {
                return;
            }
            int prev = (Integer)keys[start];
            DataOutput2.packLong(out, prev);
            for (int i = start + 1; i < end; ++i) {
                int curr = (Integer)keys[i];
                DataOutput2.packInt(out, curr - prev);
                prev = curr;
            }
        }

        @Override
        public Object[] deserialize(DataInput in, int start, int end, int size) throws IOException {
            Object[] ret = new Integer[size];
            int prev = 0;
            for (int i = start; i < end; ++i) {
                ret[i] = prev += DataInput2.unpackInt(in);
            }
            return ret;
        }

        @Override
        public Comparator<Integer> getComparator() {
            return BTreeMap.COMPARABLE_COMPARATOR;
        }
    };
    public static final BTreeKeySerializer<String> STRING = new BTreeKeySerializer<String>(){
        private final Charset UTF8_CHARSET = Charset.forName("UTF8");

        @Override
        public void serialize(DataOutput out, int start, int end, Object[] keys) throws IOException {
            byte[] previous = null;
            for (int i = start; i < end; ++i) {
                byte[] b = ((String)keys[i]).getBytes(this.UTF8_CHARSET);
                3.leadingValuePackWrite(out, b, previous, 0);
                previous = b;
            }
        }

        @Override
        public Object[] deserialize(DataInput in, int start, int end, int size) throws IOException {
            Object[] ret = new Object[size];
            byte[] previous = null;
            for (int i = start; i < end; ++i) {
                byte[] b = 3.leadingValuePackRead(in, previous, 0);
                if (b == null) continue;
                ret[i] = new String(b, this.UTF8_CHARSET);
                previous = b;
            }
            return ret;
        }

        @Override
        public Comparator<String> getComparator() {
            return BTreeMap.COMPARABLE_COMPARATOR;
        }
    };
    public static final Tuple2KeySerializer TUPLE2 = new Tuple2KeySerializer(null, null, null);
    public static final Tuple3KeySerializer TUPLE3 = new Tuple3KeySerializer(null, null, null, null, null);
    public static final Tuple4KeySerializer TUPLE4 = new Tuple4KeySerializer(null, null, null, null, null, null, null);

    public abstract void serialize(DataOutput var1, int var2, int var3, Object[] var4) throws IOException;

    public abstract Object[] deserialize(DataInput var1, int var2, int var3, int var4) throws IOException;

    public abstract Comparator<K> getComparator();

    public static byte[] leadingValuePackRead(DataInput in, byte[] previous, int ignoreLeadingCount) throws IOException {
        int len = DataInput2.unpackInt(in) - 1;
        if (len == -1) {
            return null;
        }
        int actualCommon = DataInput2.unpackInt(in);
        byte[] buf = new byte[len];
        if (previous == null) {
            actualCommon = 0;
        }
        if (actualCommon > 0) {
            in.readFully(buf, 0, ignoreLeadingCount);
            System.arraycopy(previous, ignoreLeadingCount, buf, ignoreLeadingCount, actualCommon - ignoreLeadingCount);
        }
        in.readFully(buf, actualCommon, len - actualCommon);
        return buf;
    }

    public static void leadingValuePackWrite(DataOutput out, byte[] buf, byte[] previous, int ignoreLeadingCount) throws IOException {
        if (buf == null) {
            DataOutput2.packInt(out, 0);
            return;
        }
        int actualCommon = ignoreLeadingCount;
        if (previous != null) {
            int maxCommon;
            int n = maxCommon = buf.length > previous.length ? previous.length : buf.length;
            if (maxCommon > Short.MAX_VALUE) {
                maxCommon = Short.MAX_VALUE;
            }
            while (actualCommon < maxCommon && buf[actualCommon] == previous[actualCommon]) {
                ++actualCommon;
            }
        }
        DataOutput2.packInt(out, buf.length + 1);
        DataOutput2.packInt(out, actualCommon);
        out.write(buf, 0, ignoreLeadingCount);
        out.write(buf, actualCommon, buf.length - actualCommon);
    }

    public static class Tuple4KeySerializer<A, B, C, D>
    extends BTreeKeySerializer<Fun.Tuple4<A, B, C, D>>
    implements Serializable {
        protected final Comparator<A> aComparator;
        protected final Comparator<B> bComparator;
        protected final Comparator<C> cComparator;
        protected final Serializer<A> aSerializer;
        protected final Serializer<B> bSerializer;
        protected final Serializer<C> cSerializer;
        protected final Serializer<D> dSerializer;

        public Tuple4KeySerializer(Comparator<A> aComparator, Comparator<B> bComparator, Comparator<C> cComparator, Serializer aSerializer, Serializer bSerializer, Serializer cSerializer, Serializer dSerializer) {
            this.aComparator = aComparator;
            this.bComparator = bComparator;
            this.cComparator = cComparator;
            this.aSerializer = aSerializer;
            this.bSerializer = bSerializer;
            this.cSerializer = cSerializer;
            this.dSerializer = dSerializer;
        }

        Tuple4KeySerializer(SerializerBase serializerBase, DataInput is, SerializerBase.FastArrayList<Object> objectStack) throws IOException {
            objectStack.add(this);
            this.aComparator = (Comparator)serializerBase.deserialize(is, objectStack);
            this.bComparator = (Comparator)serializerBase.deserialize(is, objectStack);
            this.cComparator = (Comparator)serializerBase.deserialize(is, objectStack);
            this.aSerializer = (Serializer)serializerBase.deserialize(is, objectStack);
            this.bSerializer = (Serializer)serializerBase.deserialize(is, objectStack);
            this.cSerializer = (Serializer)serializerBase.deserialize(is, objectStack);
            this.dSerializer = (Serializer)serializerBase.deserialize(is, objectStack);
        }

        @Override
        public void serialize(DataOutput out, int start, int end, Object[] keys) throws IOException {
            int acount = 0;
            int bcount = 0;
            int ccount = 0;
            for (int i = start; i < end; ++i) {
                Fun.Tuple4 t = (Fun.Tuple4)keys[i];
                if (acount == 0) {
                    this.aSerializer.serialize(out, t.a);
                    acount = 1;
                    while (i + acount < end && this.aComparator.compare(t.a, ((Fun.Tuple4)keys[i + acount]).a) == 0) {
                        ++acount;
                    }
                    DataOutput2.packInt(out, acount);
                }
                if (bcount == 0) {
                    this.bSerializer.serialize(out, t.b);
                    bcount = 1;
                    while (i + bcount < end && this.bComparator.compare(t.b, ((Fun.Tuple4)keys[i + bcount]).b) == 0) {
                        ++bcount;
                    }
                    DataOutput2.packInt(out, bcount);
                }
                if (ccount == 0) {
                    this.cSerializer.serialize(out, t.c);
                    ccount = 1;
                    while (i + ccount < end && this.cComparator.compare(t.c, ((Fun.Tuple4)keys[i + ccount]).c) == 0) {
                        ++ccount;
                    }
                    DataOutput2.packInt(out, ccount);
                }
                this.dSerializer.serialize(out, t.d);
                --acount;
                --bcount;
                --ccount;
            }
        }

        @Override
        public Object[] deserialize(DataInput in, int start, int end, int size) throws IOException {
            Object[] ret = new Object[size];
            Object a = null;
            int acount = 0;
            Object b = null;
            int bcount = 0;
            Object c = null;
            int ccount = 0;
            for (int i = start; i < end; ++i) {
                if (acount == 0) {
                    a = this.aSerializer.deserialize(in, -1);
                    acount = DataInput2.unpackInt(in);
                }
                if (bcount == 0) {
                    b = this.bSerializer.deserialize(in, -1);
                    bcount = DataInput2.unpackInt(in);
                }
                if (ccount == 0) {
                    c = this.cSerializer.deserialize(in, -1);
                    ccount = DataInput2.unpackInt(in);
                }
                D d = this.dSerializer.deserialize(in, -1);
                ret[i] = Fun.t4(a, b, c, d);
                --acount;
                --bcount;
                --ccount;
            }
            assert (acount == 0);
            assert (bcount == 0);
            assert (ccount == 0);
            return ret;
        }

        @Override
        public Comparator<Fun.Tuple4<A, B, C, D>> getComparator() {
            return BTreeMap.COMPARABLE_COMPARATOR;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tuple4KeySerializer that = (Tuple4KeySerializer)o;
            if (this.aComparator != null ? !this.aComparator.equals(that.aComparator) : that.aComparator != null) {
                return false;
            }
            if (this.aSerializer != null ? !this.aSerializer.equals(that.aSerializer) : that.aSerializer != null) {
                return false;
            }
            if (this.bComparator != null ? !this.bComparator.equals(that.bComparator) : that.bComparator != null) {
                return false;
            }
            if (this.bSerializer != null ? !this.bSerializer.equals(that.bSerializer) : that.bSerializer != null) {
                return false;
            }
            if (this.cComparator != null ? !this.cComparator.equals(that.cComparator) : that.cComparator != null) {
                return false;
            }
            if (this.cSerializer != null ? !this.cSerializer.equals(that.cSerializer) : that.cSerializer != null) {
                return false;
            }
            return !(this.dSerializer != null ? !this.dSerializer.equals(that.dSerializer) : that.dSerializer != null);
        }

        public int hashCode() {
            int result = this.aComparator != null ? this.aComparator.hashCode() : 0;
            result = 31 * result + (this.bComparator != null ? this.bComparator.hashCode() : 0);
            result = 31 * result + (this.cComparator != null ? this.cComparator.hashCode() : 0);
            result = 31 * result + (this.aSerializer != null ? this.aSerializer.hashCode() : 0);
            result = 31 * result + (this.bSerializer != null ? this.bSerializer.hashCode() : 0);
            result = 31 * result + (this.cSerializer != null ? this.cSerializer.hashCode() : 0);
            result = 31 * result + (this.dSerializer != null ? this.dSerializer.hashCode() : 0);
            return result;
        }
    }

    public static class Tuple3KeySerializer<A, B, C>
    extends BTreeKeySerializer<Fun.Tuple3<A, B, C>>
    implements Serializable {
        protected final Comparator<A> aComparator;
        protected final Comparator<B> bComparator;
        protected final Serializer<A> aSerializer;
        protected final Serializer<B> bSerializer;
        protected final Serializer<C> cSerializer;

        public Tuple3KeySerializer(Comparator<A> aComparator, Comparator<B> bComparator, Serializer aSerializer, Serializer bSerializer, Serializer cSerializer) {
            this.aComparator = aComparator;
            this.bComparator = bComparator;
            this.aSerializer = aSerializer;
            this.bSerializer = bSerializer;
            this.cSerializer = cSerializer;
        }

        Tuple3KeySerializer(SerializerBase serializerBase, DataInput is, SerializerBase.FastArrayList<Object> objectStack) throws IOException {
            objectStack.add(this);
            this.aComparator = (Comparator)serializerBase.deserialize(is, objectStack);
            this.bComparator = (Comparator)serializerBase.deserialize(is, objectStack);
            this.aSerializer = (Serializer)serializerBase.deserialize(is, objectStack);
            this.bSerializer = (Serializer)serializerBase.deserialize(is, objectStack);
            this.cSerializer = (Serializer)serializerBase.deserialize(is, objectStack);
        }

        @Override
        public void serialize(DataOutput out, int start, int end, Object[] keys) throws IOException {
            int acount = 0;
            int bcount = 0;
            for (int i = start; i < end; ++i) {
                Fun.Tuple3 t = (Fun.Tuple3)keys[i];
                if (acount == 0) {
                    this.aSerializer.serialize(out, t.a);
                    acount = 1;
                    while (i + acount < end && this.aComparator.compare(t.a, ((Fun.Tuple3)keys[i + acount]).a) == 0) {
                        ++acount;
                    }
                    DataOutput2.packInt(out, acount);
                }
                if (bcount == 0) {
                    this.bSerializer.serialize(out, t.b);
                    bcount = 1;
                    while (i + bcount < end && this.bComparator.compare(t.b, ((Fun.Tuple3)keys[i + bcount]).b) == 0) {
                        ++bcount;
                    }
                    DataOutput2.packInt(out, bcount);
                }
                this.cSerializer.serialize(out, t.c);
                --acount;
                --bcount;
            }
        }

        @Override
        public Object[] deserialize(DataInput in, int start, int end, int size) throws IOException {
            Object[] ret = new Object[size];
            Object a = null;
            int acount = 0;
            Object b = null;
            int bcount = 0;
            for (int i = start; i < end; ++i) {
                if (acount == 0) {
                    a = this.aSerializer.deserialize(in, -1);
                    acount = DataInput2.unpackInt(in);
                }
                if (bcount == 0) {
                    b = this.bSerializer.deserialize(in, -1);
                    bcount = DataInput2.unpackInt(in);
                }
                C c = this.cSerializer.deserialize(in, -1);
                ret[i] = Fun.t3(a, b, c);
                --acount;
                --bcount;
            }
            assert (acount == 0);
            assert (bcount == 0);
            return ret;
        }

        @Override
        public Comparator<Fun.Tuple3<A, B, C>> getComparator() {
            return BTreeMap.COMPARABLE_COMPARATOR;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tuple3KeySerializer that = (Tuple3KeySerializer)o;
            if (this.aComparator != null ? !this.aComparator.equals(that.aComparator) : that.aComparator != null) {
                return false;
            }
            if (this.aSerializer != null ? !this.aSerializer.equals(that.aSerializer) : that.aSerializer != null) {
                return false;
            }
            if (this.bComparator != null ? !this.bComparator.equals(that.bComparator) : that.bComparator != null) {
                return false;
            }
            if (this.bSerializer != null ? !this.bSerializer.equals(that.bSerializer) : that.bSerializer != null) {
                return false;
            }
            return !(this.cSerializer != null ? !this.cSerializer.equals(that.cSerializer) : that.cSerializer != null);
        }

        public int hashCode() {
            int result = this.aComparator != null ? this.aComparator.hashCode() : 0;
            result = 31 * result + (this.bComparator != null ? this.bComparator.hashCode() : 0);
            result = 31 * result + (this.aSerializer != null ? this.aSerializer.hashCode() : 0);
            result = 31 * result + (this.bSerializer != null ? this.bSerializer.hashCode() : 0);
            result = 31 * result + (this.cSerializer != null ? this.cSerializer.hashCode() : 0);
            return result;
        }
    }

    public static final class Tuple2KeySerializer<A, B>
    extends BTreeKeySerializer<Fun.Tuple2<A, B>>
    implements Serializable {
        protected final Comparator<A> aComparator;
        protected final Serializer<A> aSerializer;
        protected final Serializer<B> bSerializer;

        public Tuple2KeySerializer(Comparator<A> aComparator, Serializer aSerializer, Serializer bSerializer) {
            this.aComparator = aComparator;
            this.aSerializer = aSerializer;
            this.bSerializer = bSerializer;
        }

        Tuple2KeySerializer(SerializerBase serializerBase, DataInput is, SerializerBase.FastArrayList<Object> objectStack, int extra) throws IOException {
            objectStack.add(this);
            this.aComparator = (Comparator)serializerBase.deserialize(is, objectStack);
            this.aSerializer = (Serializer)serializerBase.deserialize(is, objectStack);
            this.bSerializer = (Serializer)serializerBase.deserialize(is, objectStack);
        }

        @Override
        public void serialize(DataOutput out, int start, int end, Object[] keys) throws IOException {
            int acount = 0;
            for (int i = start; i < end; ++i) {
                Fun.Tuple2 t = (Fun.Tuple2)keys[i];
                if (acount == 0) {
                    this.aSerializer.serialize(out, t.a);
                    acount = 1;
                    while (i + acount < end && this.aComparator.compare(t.a, ((Fun.Tuple2)keys[i + acount]).a) == 0) {
                        ++acount;
                    }
                    DataOutput2.packInt(out, acount);
                }
                this.bSerializer.serialize(out, t.b);
                --acount;
            }
        }

        @Override
        public Object[] deserialize(DataInput in, int start, int end, int size) throws IOException {
            Object[] ret = new Object[size];
            Object a = null;
            int acount = 0;
            for (int i = start; i < end; ++i) {
                if (acount == 0) {
                    a = this.aSerializer.deserialize(in, -1);
                    acount = DataInput2.unpackInt(in);
                }
                B b = this.bSerializer.deserialize(in, -1);
                ret[i] = Fun.t2(a, b);
                --acount;
            }
            assert (acount == 0);
            return ret;
        }

        @Override
        public Comparator<Fun.Tuple2<A, B>> getComparator() {
            return BTreeMap.COMPARABLE_COMPARATOR;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tuple2KeySerializer that = (Tuple2KeySerializer)o;
            if (this.aComparator != null ? !this.aComparator.equals(that.aComparator) : that.aComparator != null) {
                return false;
            }
            if (this.aSerializer != null ? !this.aSerializer.equals(that.aSerializer) : that.aSerializer != null) {
                return false;
            }
            return !(this.bSerializer != null ? !this.bSerializer.equals(that.bSerializer) : that.bSerializer != null);
        }

        public int hashCode() {
            int result = this.aComparator != null ? this.aComparator.hashCode() : 0;
            result = 31 * result + (this.aSerializer != null ? this.aSerializer.hashCode() : 0);
            result = 31 * result + (this.bSerializer != null ? this.bSerializer.hashCode() : 0);
            return result;
        }
    }

    public static final class BasicKeySerializer
    extends BTreeKeySerializer<Object>
    implements Serializable {
        protected final Serializer defaultSerializer;

        public BasicKeySerializer(Serializer defaultSerializer) {
            this.defaultSerializer = defaultSerializer;
        }

        protected BasicKeySerializer(SerializerBase serializerBase, DataInput is, SerializerBase.FastArrayList<Object> objectStack) throws IOException {
            objectStack.add(this);
            this.defaultSerializer = (Serializer)serializerBase.deserialize(is, objectStack);
        }

        @Override
        public void serialize(DataOutput out, int start, int end, Object[] keys) throws IOException {
            for (int i = start; i < end; ++i) {
                this.defaultSerializer.serialize(out, keys[i]);
            }
        }

        @Override
        public Object[] deserialize(DataInput in, int start, int end, int size) throws IOException {
            Object[] ret = new Object[size];
            for (int i = start; i < end; ++i) {
                ret[i] = this.defaultSerializer.deserialize(in, -1);
            }
            return ret;
        }

        @Override
        public Comparator<Object> getComparator() {
            return null;
        }
    }
}

