/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ZKMetadata {
    private static final byte MAGIC = -1;
    private static final int MAGIC_SIZE = 1;
    private static final int ID_LENGTH_OFFSET = 1;
    private static final int ID_LENGTH_SIZE = 4;

    private ZKMetadata() {
    }

    public static byte[] appendMetaData(byte[] id, byte[] data) {
        if (data == null || data.length == 0) {
            return data;
        }
        byte[] salt = Bytes.toBytes((long)ThreadLocalRandom.current().nextLong());
        int idLength = id.length + salt.length;
        byte[] newData = new byte[5 + idLength + data.length];
        int pos = 0;
        pos = Bytes.putByte((byte[])newData, (int)pos, (byte)-1);
        pos = Bytes.putInt((byte[])newData, (int)pos, (int)idLength);
        pos = Bytes.putBytes((byte[])newData, (int)pos, (byte[])id, (int)0, (int)id.length);
        pos = Bytes.putBytes((byte[])newData, (int)pos, (byte[])salt, (int)0, (int)salt.length);
        pos = Bytes.putBytes((byte[])newData, (int)pos, (byte[])data, (int)0, (int)data.length);
        return newData;
    }

    public static byte[] removeMetaData(byte[] data) {
        if (data == null || data.length == 0) {
            return data;
        }
        byte magic = data[0];
        if (magic != -1) {
            return data;
        }
        int idLength = Bytes.toInt((byte[])data, (int)1);
        int dataLength = data.length - 1 - 4 - idLength;
        int dataOffset = 5 + idLength;
        byte[] newData = new byte[dataLength];
        System.arraycopy(data, dataOffset, newData, 0, dataLength);
        return newData;
    }
}

