/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.cluster;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.validation.UpdateValidation;
import org.hibernate.validator.constraints.Length;

@ApiModel(value="Cluster node request")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, visible=true, property="type", defaultImpl=ClusterNodeRequest.class)
public class ClusterNodeRequest {
    @ApiModelProperty(value="Primary key")
    @NotNull(groups={UpdateValidation.class}, message="id cannot be null")
    private @NotNull(groups={UpdateValidation.class}, message="id cannot be null") Integer id;
    @ApiModelProperty(value="ID of the parent cluster")
    @NotNull(message="parentId cannot be null")
    private @NotNull(message="parentId cannot be null") Integer parentId;
    @ApiModelProperty(value="Cluster type, including AGENT, DATAPROXY, etc.")
    @NotBlank(message="type cannot be blank")
    @Length(min=1, max=20, message="length must be between 1 and 20")
    private @NotBlank(message="type cannot be blank") @Length(min=1, max=20, message="length must be between 1 and 20") String type;
    @ApiModelProperty(value="Cluster IP")
    @NotBlank(message="ip cannot be blank")
    @Length(max=512, message="length must be less than or equal to 512")
    private @NotBlank(message="ip cannot be blank") @Length(max=512, message="length must be less than or equal to 512") String ip;
    @ApiModelProperty(value="Cluster port")
    private Integer port;
    @ApiModelProperty(value="Username")
    private String username;
    @ApiModelProperty(value="password")
    private String password;
    @ApiModelProperty(value="SSH port")
    private Integer sshPort;
    @ApiModelProperty(value="Cluster protocol type")
    @Length(min=1, max=20, message="length must be less than or equal to 20")
    private @Length(min=1, max=20, message="length must be less than or equal to 20") String protocolType;
    @ApiModelProperty(value="Current load value of the node")
    private Integer nodeLoad;
    @ApiModelProperty(value="Extended params")
    @Length(min=1, max=163840, message="length must be between 1 and 163840")
    private @Length(min=1, max=163840, message="length must be between 1 and 163840") String extParams;
    @ApiModelProperty(value="Operate log")
    private String operateLog;
    @ApiModelProperty(value="Description of the cluster node")
    @Length(max=256, message="length must be less than or equal to 256")
    private @Length(max=256, message="length must be less than or equal to 256") String description;
    @ApiModelProperty(value="Version number")
    @NotNull(groups={UpdateValidation.class}, message="version cannot be null")
    private @NotNull(groups={UpdateValidation.class}, message="version cannot be null") Integer version;
    @ApiModelProperty(value="Whether to proceed with installation")
    private Boolean isInstall = false;
    @ApiModelProperty(value="Current user", hidden=true)
    private String currentUser;

    public Integer getId() {
        return this.id;
    }

    public Integer getParentId() {
        return this.parentId;
    }

    public String getType() {
        return this.type;
    }

    public String getIp() {
        return this.ip;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Integer getSshPort() {
        return this.sshPort;
    }

    public String getProtocolType() {
        return this.protocolType;
    }

    public Integer getNodeLoad() {
        return this.nodeLoad;
    }

    public String getExtParams() {
        return this.extParams;
    }

    public String getOperateLog() {
        return this.operateLog;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Boolean getIsInstall() {
        return this.isInstall;
    }

    public String getCurrentUser() {
        return this.currentUser;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setParentId(Integer parentId) {
        this.parentId = parentId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSshPort(Integer sshPort) {
        this.sshPort = sshPort;
    }

    public void setProtocolType(String protocolType) {
        this.protocolType = protocolType;
    }

    public void setNodeLoad(Integer nodeLoad) {
        this.nodeLoad = nodeLoad;
    }

    public void setExtParams(String extParams) {
        this.extParams = extParams;
    }

    public void setOperateLog(String operateLog) {
        this.operateLog = operateLog;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setIsInstall(Boolean isInstall) {
        this.isInstall = isInstall;
    }

    public void setCurrentUser(String currentUser) {
        this.currentUser = currentUser;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterNodeRequest)) {
            return false;
        }
        ClusterNodeRequest other = (ClusterNodeRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$parentId = this.getParentId();
        Integer other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !((Object)this$parentId).equals(other$parentId)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Integer this$sshPort = this.getSshPort();
        Integer other$sshPort = other.getSshPort();
        if (this$sshPort == null ? other$sshPort != null : !((Object)this$sshPort).equals(other$sshPort)) {
            return false;
        }
        Integer this$nodeLoad = this.getNodeLoad();
        Integer other$nodeLoad = other.getNodeLoad();
        if (this$nodeLoad == null ? other$nodeLoad != null : !((Object)this$nodeLoad).equals(other$nodeLoad)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        Boolean this$isInstall = this.getIsInstall();
        Boolean other$isInstall = other.getIsInstall();
        if (this$isInstall == null ? other$isInstall != null : !((Object)this$isInstall).equals(other$isInstall)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$protocolType = this.getProtocolType();
        String other$protocolType = other.getProtocolType();
        if (this$protocolType == null ? other$protocolType != null : !this$protocolType.equals(other$protocolType)) {
            return false;
        }
        String this$extParams = this.getExtParams();
        String other$extParams = other.getExtParams();
        if (this$extParams == null ? other$extParams != null : !this$extParams.equals(other$extParams)) {
            return false;
        }
        String this$operateLog = this.getOperateLog();
        String other$operateLog = other.getOperateLog();
        if (this$operateLog == null ? other$operateLog != null : !this$operateLog.equals(other$operateLog)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$currentUser = this.getCurrentUser();
        String other$currentUser = other.getCurrentUser();
        return !(this$currentUser == null ? other$currentUser != null : !this$currentUser.equals(other$currentUser));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClusterNodeRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : ((Object)$parentId).hashCode());
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Integer $sshPort = this.getSshPort();
        result = result * 59 + ($sshPort == null ? 43 : ((Object)$sshPort).hashCode());
        Integer $nodeLoad = this.getNodeLoad();
        result = result * 59 + ($nodeLoad == null ? 43 : ((Object)$nodeLoad).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        Boolean $isInstall = this.getIsInstall();
        result = result * 59 + ($isInstall == null ? 43 : ((Object)$isInstall).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $protocolType = this.getProtocolType();
        result = result * 59 + ($protocolType == null ? 43 : $protocolType.hashCode());
        String $extParams = this.getExtParams();
        result = result * 59 + ($extParams == null ? 43 : $extParams.hashCode());
        String $operateLog = this.getOperateLog();
        result = result * 59 + ($operateLog == null ? 43 : $operateLog.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $currentUser = this.getCurrentUser();
        result = result * 59 + ($currentUser == null ? 43 : $currentUser.hashCode());
        return result;
    }

    public String toString() {
        return "ClusterNodeRequest(id=" + this.getId() + ", parentId=" + this.getParentId() + ", type=" + this.getType() + ", ip=" + this.getIp() + ", port=" + this.getPort() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", sshPort=" + this.getSshPort() + ", protocolType=" + this.getProtocolType() + ", nodeLoad=" + this.getNodeLoad() + ", extParams=" + this.getExtParams() + ", operateLog=" + this.getOperateLog() + ", description=" + this.getDescription() + ", version=" + this.getVersion() + ", isInstall=" + this.getIsInstall() + ", currentUser=" + this.getCurrentUser() + ")";
    }
}

