/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.group;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.sql.Timestamp;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.inlong.manager.common.validation.SaveValidation;
import org.apache.inlong.manager.common.validation.UpdateValidation;
import org.apache.inlong.manager.pojo.group.BaseInlongGroup;
import org.apache.inlong.manager.pojo.group.InlongGroupExtInfo;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

@ApiModel(value="Inlong group create request")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, visible=true, property="mqType")
public abstract class InlongGroupRequest
extends BaseInlongGroup {
    @ApiModelProperty(value="Inlong group id", required=true)
    @NotBlank(message="inlongGroupId cannot be blank")
    @Length(min=4, max=200, message="length must be between 4 and 200")
    @Pattern(regexp="^[a-zA-Z0-9_.-]{4,200}$", message="only supports letters, numbers, '.', '-', or '_'")
    private @NotBlank(message="inlongGroupId cannot be blank") @Length(min=4, max=200, message="length must be between 4 and 200") @Pattern(regexp="^[a-zA-Z0-9_.-]{4,200}$", message="only supports letters, numbers, '.', '-', or '_'") String inlongGroupId;
    @ApiModelProperty(value="Inlong group name", required=true)
    @Length(max=128, message="length must be less than or equal to 128")
    private @Length(max=128, message="length must be less than or equal to 128") String name;
    @ApiModelProperty(value="Inlong group description")
    @Length(max=256, message="length must be less than or equal to 256")
    private @Length(max=256, message="length must be less than or equal to 256") String description;
    @Deprecated
    @ApiModelProperty(value="MQ type, replaced by mqType")
    private String middlewareType;
    @ApiModelProperty(value="MQ type, high throughput: TUBEMQ, high consistency: PULSAR")
    @NotBlank(message="mqType cannot be blank")
    @Length(min=1, max=20, message="length must be between 1 and 20")
    private @NotBlank(message="mqType cannot be blank") @Length(min=1, max=20, message="length must be between 1 and 20") String mqType;
    @ApiModelProperty(value="MQ resource", notes="in inlong group, TubeMQ corresponds to Topic, Pulsar corresponds to Namespace")
    @Length(max=128, message="length must be less than or equal to 128")
    @Pattern(regexp="^[a-z0-9_-]{1,128}$", message="only supports lowercase letters, numbers, '-', or '_'")
    private @Length(max=128, message="length must be less than or equal to 128") @Pattern(regexp="^[a-z0-9_-]{1,128}$", message="only supports lowercase letters, numbers, '-', or '_'") String mqResource;
    @ApiModelProperty(value="TubeMQ master URL")
    private String tubeMaster;
    @ApiModelProperty(value="Whether to enable zookeeper? 0: disable, 1: enable", notes="In the case of standard mode, it is allowed to use zookeeper to store metadata")
    @Range(min=0L, max=1L, message="default is 0, only supports [0: disable, 1: enable]")
    private @Range(min=0L, max=1L, message="default is 0, only supports [0: disable, 1: enable]") Integer enableZookeeper;
    @ApiModelProperty(value="Whether to enable create resource? 0: disable, 1: enable")
    @Range(min=0L, max=1L, message="default is 1, only supports [0: disable, 1: enable]")
    private @Range(min=0L, max=1L, message="default is 1, only supports [0: disable, 1: enable]") Integer enableCreateResource;
    @ApiModelProperty(value="Standard mode(include Data Ingestion and Synchronization): 0, DataSync mode(only Data Synchronization, real-time data sync in stream way): 1, DataSync mode(only Data Synchronization, offline data sync in batch way): 2")
    @Range(min=0L, max=2L, message="default is 0, only supports [0: Standard, 1: DataSync, 2: DataSyncOffline]")
    private @Range(min=0L, max=2L, message="default is 0, only supports [0: Standard, 1: DataSync, 2: DataSyncOffline]") Integer inlongGroupMode;
    @ApiModelProperty(value="Data report type, default is 0.\n 0: report to DataProxy and respond when the DataProxy received data.\n 1: report to DataProxy and respond after DataProxy sends data.\n 2: report to MQ and respond when the MQ received data.", notes="Current constraint is that all InLong Agents under one InlongGroup use the same type")
    @Range(min=0L, max=2L, message="default is 0, only supports [0, 1, 2]")
    private @Range(min=0L, max=2L, message="default is 0, only supports [0, 1, 2]") Integer dataReportType;
    @ApiModelProperty(value="Inlong cluster tag, which links to inlong_cluster table")
    @Length(max=128, message="Length must be less than or equal to 128")
    private @Length(max=128, message="Length must be less than or equal to 128") String inlongClusterTag;
    @ApiModelProperty(value="Number of access items per day, unit: 10,000 items per day")
    private Integer dailyRecords;
    @ApiModelProperty(value="Access size per day, unit: GB per day")
    private Integer dailyStorage;
    @ApiModelProperty(value="peak access per second, unit: bars per second")
    private Integer peakRecords;
    @ApiModelProperty(value="The maximum length of a single piece of data, unit: Byte")
    private Integer maxLength;
    @ApiModelProperty(value="Name of responsible person, separated by commas")
    @NotBlank(groups={SaveValidation.class}, message="inCharges cannot be blank")
    @Length(max=512, message="length must be less than or equal to 512")
    private @NotBlank(groups={SaveValidation.class}, message="inCharges cannot be blank") @Length(max=512, message="length must be less than or equal to 512") String inCharges;
    @ApiModelProperty(value="Name of followers, separated by commas")
    @Length(max=512, message="length must be less than or equal to 512")
    private @Length(max=512, message="length must be less than or equal to 512") String followers;
    @ApiModelProperty(value="Inlong group Extension properties")
    private List<InlongGroupExtInfo> extList;
    @ApiModelProperty(value="Version number")
    @NotNull(groups={UpdateValidation.class}, message="version cannot be null")
    private @NotNull(groups={UpdateValidation.class}, message="version cannot be null") Integer version;
    @ApiModelProperty(value="Schedule type")
    private Integer scheduleType;
    @ApiModelProperty(value="Schedule engine, support Quartz, Airflow and DolphinScheduler")
    @Length(min=1, max=20, message="length must be between 1 and 20")
    private @Length(min=1, max=20, message="length must be between 1 and 20") String scheduleEngine;
    @ApiModelProperty(value="TimeUnit for schedule interval")
    private String scheduleUnit;
    @ApiModelProperty(value="Schedule interval")
    private Integer scheduleInterval;
    @ApiModelProperty(value="Start time")
    private Timestamp startTime;
    @ApiModelProperty(value="End time")
    private Timestamp endTime;
    @ApiModelProperty(value="Delay time")
    private Integer delayTime;
    @ApiModelProperty(value="Self depend")
    private Integer selfDepend;
    @ApiModelProperty(value="Schedule task parallelism")
    private Integer taskParallelism;
    @ApiModelProperty(value="Cron expression")
    private String crontabExpression;

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    @Deprecated
    public String getMiddlewareType() {
        return this.middlewareType;
    }

    public String getMqType() {
        return this.mqType;
    }

    public String getMqResource() {
        return this.mqResource;
    }

    public String getTubeMaster() {
        return this.tubeMaster;
    }

    public Integer getEnableZookeeper() {
        return this.enableZookeeper;
    }

    public Integer getEnableCreateResource() {
        return this.enableCreateResource;
    }

    public Integer getInlongGroupMode() {
        return this.inlongGroupMode;
    }

    public Integer getDataReportType() {
        return this.dataReportType;
    }

    public String getInlongClusterTag() {
        return this.inlongClusterTag;
    }

    public Integer getDailyRecords() {
        return this.dailyRecords;
    }

    public Integer getDailyStorage() {
        return this.dailyStorage;
    }

    public Integer getPeakRecords() {
        return this.peakRecords;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public String getInCharges() {
        return this.inCharges;
    }

    public String getFollowers() {
        return this.followers;
    }

    public List<InlongGroupExtInfo> getExtList() {
        return this.extList;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Integer getScheduleType() {
        return this.scheduleType;
    }

    public String getScheduleEngine() {
        return this.scheduleEngine;
    }

    public String getScheduleUnit() {
        return this.scheduleUnit;
    }

    public Integer getScheduleInterval() {
        return this.scheduleInterval;
    }

    public Timestamp getStartTime() {
        return this.startTime;
    }

    public Timestamp getEndTime() {
        return this.endTime;
    }

    public Integer getDelayTime() {
        return this.delayTime;
    }

    public Integer getSelfDepend() {
        return this.selfDepend;
    }

    public Integer getTaskParallelism() {
        return this.taskParallelism;
    }

    public String getCrontabExpression() {
        return this.crontabExpression;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Deprecated
    public void setMiddlewareType(String middlewareType) {
        this.middlewareType = middlewareType;
    }

    public void setMqType(String mqType) {
        this.mqType = mqType;
    }

    public void setMqResource(String mqResource) {
        this.mqResource = mqResource;
    }

    public void setTubeMaster(String tubeMaster) {
        this.tubeMaster = tubeMaster;
    }

    public void setEnableZookeeper(Integer enableZookeeper) {
        this.enableZookeeper = enableZookeeper;
    }

    public void setEnableCreateResource(Integer enableCreateResource) {
        this.enableCreateResource = enableCreateResource;
    }

    public void setInlongGroupMode(Integer inlongGroupMode) {
        this.inlongGroupMode = inlongGroupMode;
    }

    public void setDataReportType(Integer dataReportType) {
        this.dataReportType = dataReportType;
    }

    public void setInlongClusterTag(String inlongClusterTag) {
        this.inlongClusterTag = inlongClusterTag;
    }

    public void setDailyRecords(Integer dailyRecords) {
        this.dailyRecords = dailyRecords;
    }

    public void setDailyStorage(Integer dailyStorage) {
        this.dailyStorage = dailyStorage;
    }

    public void setPeakRecords(Integer peakRecords) {
        this.peakRecords = peakRecords;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public void setInCharges(String inCharges) {
        this.inCharges = inCharges;
    }

    public void setFollowers(String followers) {
        this.followers = followers;
    }

    public void setExtList(List<InlongGroupExtInfo> extList) {
        this.extList = extList;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setScheduleType(Integer scheduleType) {
        this.scheduleType = scheduleType;
    }

    public void setScheduleEngine(String scheduleEngine) {
        this.scheduleEngine = scheduleEngine;
    }

    public void setScheduleUnit(String scheduleUnit) {
        this.scheduleUnit = scheduleUnit;
    }

    public void setScheduleInterval(Integer scheduleInterval) {
        this.scheduleInterval = scheduleInterval;
    }

    public void setStartTime(Timestamp startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Timestamp endTime) {
        this.endTime = endTime;
    }

    public void setDelayTime(Integer delayTime) {
        this.delayTime = delayTime;
    }

    public void setSelfDepend(Integer selfDepend) {
        this.selfDepend = selfDepend;
    }

    public void setTaskParallelism(Integer taskParallelism) {
        this.taskParallelism = taskParallelism;
    }

    public void setCrontabExpression(String crontabExpression) {
        this.crontabExpression = crontabExpression;
    }

    @Override
    public String toString() {
        return "InlongGroupRequest(inlongGroupId=" + this.getInlongGroupId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", middlewareType=" + this.getMiddlewareType() + ", mqType=" + this.getMqType() + ", mqResource=" + this.getMqResource() + ", tubeMaster=" + this.getTubeMaster() + ", enableZookeeper=" + this.getEnableZookeeper() + ", enableCreateResource=" + this.getEnableCreateResource() + ", inlongGroupMode=" + this.getInlongGroupMode() + ", dataReportType=" + this.getDataReportType() + ", inlongClusterTag=" + this.getInlongClusterTag() + ", dailyRecords=" + this.getDailyRecords() + ", dailyStorage=" + this.getDailyStorage() + ", peakRecords=" + this.getPeakRecords() + ", maxLength=" + this.getMaxLength() + ", inCharges=" + this.getInCharges() + ", followers=" + this.getFollowers() + ", extList=" + this.getExtList() + ", version=" + this.getVersion() + ", scheduleType=" + this.getScheduleType() + ", scheduleEngine=" + this.getScheduleEngine() + ", scheduleUnit=" + this.getScheduleUnit() + ", scheduleInterval=" + this.getScheduleInterval() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", delayTime=" + this.getDelayTime() + ", selfDepend=" + this.getSelfDepend() + ", taskParallelism=" + this.getTaskParallelism() + ", crontabExpression=" + this.getCrontabExpression() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlongGroupRequest)) {
            return false;
        }
        InlongGroupRequest other = (InlongGroupRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$enableZookeeper = this.getEnableZookeeper();
        Integer other$enableZookeeper = other.getEnableZookeeper();
        if (this$enableZookeeper == null ? other$enableZookeeper != null : !((Object)this$enableZookeeper).equals(other$enableZookeeper)) {
            return false;
        }
        Integer this$enableCreateResource = this.getEnableCreateResource();
        Integer other$enableCreateResource = other.getEnableCreateResource();
        if (this$enableCreateResource == null ? other$enableCreateResource != null : !((Object)this$enableCreateResource).equals(other$enableCreateResource)) {
            return false;
        }
        Integer this$inlongGroupMode = this.getInlongGroupMode();
        Integer other$inlongGroupMode = other.getInlongGroupMode();
        if (this$inlongGroupMode == null ? other$inlongGroupMode != null : !((Object)this$inlongGroupMode).equals(other$inlongGroupMode)) {
            return false;
        }
        Integer this$dataReportType = this.getDataReportType();
        Integer other$dataReportType = other.getDataReportType();
        if (this$dataReportType == null ? other$dataReportType != null : !((Object)this$dataReportType).equals(other$dataReportType)) {
            return false;
        }
        Integer this$dailyRecords = this.getDailyRecords();
        Integer other$dailyRecords = other.getDailyRecords();
        if (this$dailyRecords == null ? other$dailyRecords != null : !((Object)this$dailyRecords).equals(other$dailyRecords)) {
            return false;
        }
        Integer this$dailyStorage = this.getDailyStorage();
        Integer other$dailyStorage = other.getDailyStorage();
        if (this$dailyStorage == null ? other$dailyStorage != null : !((Object)this$dailyStorage).equals(other$dailyStorage)) {
            return false;
        }
        Integer this$peakRecords = this.getPeakRecords();
        Integer other$peakRecords = other.getPeakRecords();
        if (this$peakRecords == null ? other$peakRecords != null : !((Object)this$peakRecords).equals(other$peakRecords)) {
            return false;
        }
        Integer this$maxLength = this.getMaxLength();
        Integer other$maxLength = other.getMaxLength();
        if (this$maxLength == null ? other$maxLength != null : !((Object)this$maxLength).equals(other$maxLength)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        Integer this$scheduleType = this.getScheduleType();
        Integer other$scheduleType = other.getScheduleType();
        if (this$scheduleType == null ? other$scheduleType != null : !((Object)this$scheduleType).equals(other$scheduleType)) {
            return false;
        }
        Integer this$scheduleInterval = this.getScheduleInterval();
        Integer other$scheduleInterval = other.getScheduleInterval();
        if (this$scheduleInterval == null ? other$scheduleInterval != null : !((Object)this$scheduleInterval).equals(other$scheduleInterval)) {
            return false;
        }
        Integer this$delayTime = this.getDelayTime();
        Integer other$delayTime = other.getDelayTime();
        if (this$delayTime == null ? other$delayTime != null : !((Object)this$delayTime).equals(other$delayTime)) {
            return false;
        }
        Integer this$selfDepend = this.getSelfDepend();
        Integer other$selfDepend = other.getSelfDepend();
        if (this$selfDepend == null ? other$selfDepend != null : !((Object)this$selfDepend).equals(other$selfDepend)) {
            return false;
        }
        Integer this$taskParallelism = this.getTaskParallelism();
        Integer other$taskParallelism = other.getTaskParallelism();
        if (this$taskParallelism == null ? other$taskParallelism != null : !((Object)this$taskParallelism).equals(other$taskParallelism)) {
            return false;
        }
        String this$inlongGroupId = this.getInlongGroupId();
        String other$inlongGroupId = other.getInlongGroupId();
        if (this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$middlewareType = this.getMiddlewareType();
        String other$middlewareType = other.getMiddlewareType();
        if (this$middlewareType == null ? other$middlewareType != null : !this$middlewareType.equals(other$middlewareType)) {
            return false;
        }
        String this$mqType = this.getMqType();
        String other$mqType = other.getMqType();
        if (this$mqType == null ? other$mqType != null : !this$mqType.equals(other$mqType)) {
            return false;
        }
        String this$mqResource = this.getMqResource();
        String other$mqResource = other.getMqResource();
        if (this$mqResource == null ? other$mqResource != null : !this$mqResource.equals(other$mqResource)) {
            return false;
        }
        String this$tubeMaster = this.getTubeMaster();
        String other$tubeMaster = other.getTubeMaster();
        if (this$tubeMaster == null ? other$tubeMaster != null : !this$tubeMaster.equals(other$tubeMaster)) {
            return false;
        }
        String this$inlongClusterTag = this.getInlongClusterTag();
        String other$inlongClusterTag = other.getInlongClusterTag();
        if (this$inlongClusterTag == null ? other$inlongClusterTag != null : !this$inlongClusterTag.equals(other$inlongClusterTag)) {
            return false;
        }
        String this$inCharges = this.getInCharges();
        String other$inCharges = other.getInCharges();
        if (this$inCharges == null ? other$inCharges != null : !this$inCharges.equals(other$inCharges)) {
            return false;
        }
        String this$followers = this.getFollowers();
        String other$followers = other.getFollowers();
        if (this$followers == null ? other$followers != null : !this$followers.equals(other$followers)) {
            return false;
        }
        List<InlongGroupExtInfo> this$extList = this.getExtList();
        List<InlongGroupExtInfo> other$extList = other.getExtList();
        if (this$extList == null ? other$extList != null : !((Object)this$extList).equals(other$extList)) {
            return false;
        }
        String this$scheduleEngine = this.getScheduleEngine();
        String other$scheduleEngine = other.getScheduleEngine();
        if (this$scheduleEngine == null ? other$scheduleEngine != null : !this$scheduleEngine.equals(other$scheduleEngine)) {
            return false;
        }
        String this$scheduleUnit = this.getScheduleUnit();
        String other$scheduleUnit = other.getScheduleUnit();
        if (this$scheduleUnit == null ? other$scheduleUnit != null : !this$scheduleUnit.equals(other$scheduleUnit)) {
            return false;
        }
        Timestamp this$startTime = this.getStartTime();
        Timestamp other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Timestamp this$endTime = this.getEndTime();
        Timestamp other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        String this$crontabExpression = this.getCrontabExpression();
        String other$crontabExpression = other.getCrontabExpression();
        return !(this$crontabExpression == null ? other$crontabExpression != null : !this$crontabExpression.equals(other$crontabExpression));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InlongGroupRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $enableZookeeper = this.getEnableZookeeper();
        result = result * 59 + ($enableZookeeper == null ? 43 : ((Object)$enableZookeeper).hashCode());
        Integer $enableCreateResource = this.getEnableCreateResource();
        result = result * 59 + ($enableCreateResource == null ? 43 : ((Object)$enableCreateResource).hashCode());
        Integer $inlongGroupMode = this.getInlongGroupMode();
        result = result * 59 + ($inlongGroupMode == null ? 43 : ((Object)$inlongGroupMode).hashCode());
        Integer $dataReportType = this.getDataReportType();
        result = result * 59 + ($dataReportType == null ? 43 : ((Object)$dataReportType).hashCode());
        Integer $dailyRecords = this.getDailyRecords();
        result = result * 59 + ($dailyRecords == null ? 43 : ((Object)$dailyRecords).hashCode());
        Integer $dailyStorage = this.getDailyStorage();
        result = result * 59 + ($dailyStorage == null ? 43 : ((Object)$dailyStorage).hashCode());
        Integer $peakRecords = this.getPeakRecords();
        result = result * 59 + ($peakRecords == null ? 43 : ((Object)$peakRecords).hashCode());
        Integer $maxLength = this.getMaxLength();
        result = result * 59 + ($maxLength == null ? 43 : ((Object)$maxLength).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        Integer $scheduleType = this.getScheduleType();
        result = result * 59 + ($scheduleType == null ? 43 : ((Object)$scheduleType).hashCode());
        Integer $scheduleInterval = this.getScheduleInterval();
        result = result * 59 + ($scheduleInterval == null ? 43 : ((Object)$scheduleInterval).hashCode());
        Integer $delayTime = this.getDelayTime();
        result = result * 59 + ($delayTime == null ? 43 : ((Object)$delayTime).hashCode());
        Integer $selfDepend = this.getSelfDepend();
        result = result * 59 + ($selfDepend == null ? 43 : ((Object)$selfDepend).hashCode());
        Integer $taskParallelism = this.getTaskParallelism();
        result = result * 59 + ($taskParallelism == null ? 43 : ((Object)$taskParallelism).hashCode());
        String $inlongGroupId = this.getInlongGroupId();
        result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $middlewareType = this.getMiddlewareType();
        result = result * 59 + ($middlewareType == null ? 43 : $middlewareType.hashCode());
        String $mqType = this.getMqType();
        result = result * 59 + ($mqType == null ? 43 : $mqType.hashCode());
        String $mqResource = this.getMqResource();
        result = result * 59 + ($mqResource == null ? 43 : $mqResource.hashCode());
        String $tubeMaster = this.getTubeMaster();
        result = result * 59 + ($tubeMaster == null ? 43 : $tubeMaster.hashCode());
        String $inlongClusterTag = this.getInlongClusterTag();
        result = result * 59 + ($inlongClusterTag == null ? 43 : $inlongClusterTag.hashCode());
        String $inCharges = this.getInCharges();
        result = result * 59 + ($inCharges == null ? 43 : $inCharges.hashCode());
        String $followers = this.getFollowers();
        result = result * 59 + ($followers == null ? 43 : $followers.hashCode());
        List<InlongGroupExtInfo> $extList = this.getExtList();
        result = result * 59 + ($extList == null ? 43 : ((Object)$extList).hashCode());
        String $scheduleEngine = this.getScheduleEngine();
        result = result * 59 + ($scheduleEngine == null ? 43 : $scheduleEngine.hashCode());
        String $scheduleUnit = this.getScheduleUnit();
        result = result * 59 + ($scheduleUnit == null ? 43 : $scheduleUnit.hashCode());
        Timestamp $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Timestamp $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        String $crontabExpression = this.getCrontabExpression();
        result = result * 59 + ($crontabExpression == null ? 43 : $crontabExpression.hashCode());
        return result;
    }

    public InlongGroupRequest() {
    }

    public InlongGroupRequest(String inlongGroupId, String name, String description, String middlewareType, String mqType, String mqResource, String tubeMaster, Integer enableZookeeper, Integer enableCreateResource, Integer inlongGroupMode, Integer dataReportType, String inlongClusterTag, Integer dailyRecords, Integer dailyStorage, Integer peakRecords, Integer maxLength, String inCharges, String followers, List<InlongGroupExtInfo> extList, Integer version, Integer scheduleType, String scheduleEngine, String scheduleUnit, Integer scheduleInterval, Timestamp startTime, Timestamp endTime, Integer delayTime, Integer selfDepend, Integer taskParallelism, String crontabExpression) {
        this.inlongGroupId = inlongGroupId;
        this.name = name;
        this.description = description;
        this.middlewareType = middlewareType;
        this.mqType = mqType;
        this.mqResource = mqResource;
        this.tubeMaster = tubeMaster;
        this.enableZookeeper = enableZookeeper;
        this.enableCreateResource = enableCreateResource;
        this.inlongGroupMode = inlongGroupMode;
        this.dataReportType = dataReportType;
        this.inlongClusterTag = inlongClusterTag;
        this.dailyRecords = dailyRecords;
        this.dailyStorage = dailyStorage;
        this.peakRecords = peakRecords;
        this.maxLength = maxLength;
        this.inCharges = inCharges;
        this.followers = followers;
        this.extList = extList;
        this.version = version;
        this.scheduleType = scheduleType;
        this.scheduleEngine = scheduleEngine;
        this.scheduleUnit = scheduleUnit;
        this.scheduleInterval = scheduleInterval;
        this.startTime = startTime;
        this.endTime = endTime;
        this.delayTime = delayTime;
        this.selfDepend = selfDepend;
        this.taskParallelism = taskParallelism;
        this.crontabExpression = crontabExpression;
    }
}

