/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.module;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.module.ModuleRequest;
import org.apache.inlong.manager.pojo.module.PackageHistory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiModel(value="Module info")
public class ModuleDTO {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleDTO.class);
    @ApiModelProperty(value="Start command")
    private String startCommand;
    @ApiModelProperty(value="Stop command")
    private String stopCommand;
    @ApiModelProperty(value="Check command")
    private String checkCommand;
    @ApiModelProperty(value="Install command")
    private String installCommand;
    @ApiModelProperty(value="Uninstall command")
    private String uninstallCommand;
    @ApiModelProperty(value="History list of package")
    private List<PackageHistory> packageHistoryList;

    public static ModuleDTO getFromRequest(ModuleRequest request, String extParams, Integer packageId) {
        if (!StringUtils.isNotBlank((CharSequence)extParams)) {
            return (ModuleDTO)CommonBeanUtils.copyProperties((Object)request, ModuleDTO::new, (boolean)true);
        }
        ModuleDTO dto = ModuleDTO.getFromJson(extParams);
        if (!Objects.equals(request.getPackageId(), packageId)) {
            List<PackageHistory> packageHistoryList = dto.getPackageHistoryList();
            if (packageHistoryList.size() > 10) {
                packageHistoryList.remove(packageHistoryList.size() - 1);
            }
            PackageHistory packageHistory = PackageHistory.builder().packageId(packageId).modifier(request.getCurrentUser()).modifyTime(new Date()).build();
            packageHistoryList.add(0, packageHistory);
            dto.setPackageHistoryList(packageHistoryList);
        }
        return (ModuleDTO)CommonBeanUtils.copyProperties((Object)request, (Object)dto, (boolean)true);
    }

    public static ModuleDTO getFromJson(@NotNull String extParams) {
        try {
            return (ModuleDTO)JsonUtils.parseObject((String)extParams, ModuleDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_INFO_INCORRECT, ErrorCodeEnum.CLUSTER_INFO_INCORRECT.getMessage() + ": " + e.getMessage());
        }
    }

    private static List<PackageHistory> $default$packageHistoryList() {
        return new ArrayList<PackageHistory>();
    }

    public static ModuleDTOBuilder builder() {
        return new ModuleDTOBuilder();
    }

    public String getStartCommand() {
        return this.startCommand;
    }

    public String getStopCommand() {
        return this.stopCommand;
    }

    public String getCheckCommand() {
        return this.checkCommand;
    }

    public String getInstallCommand() {
        return this.installCommand;
    }

    public String getUninstallCommand() {
        return this.uninstallCommand;
    }

    public List<PackageHistory> getPackageHistoryList() {
        return this.packageHistoryList;
    }

    public void setStartCommand(String startCommand) {
        this.startCommand = startCommand;
    }

    public void setStopCommand(String stopCommand) {
        this.stopCommand = stopCommand;
    }

    public void setCheckCommand(String checkCommand) {
        this.checkCommand = checkCommand;
    }

    public void setInstallCommand(String installCommand) {
        this.installCommand = installCommand;
    }

    public void setUninstallCommand(String uninstallCommand) {
        this.uninstallCommand = uninstallCommand;
    }

    public void setPackageHistoryList(List<PackageHistory> packageHistoryList) {
        this.packageHistoryList = packageHistoryList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModuleDTO)) {
            return false;
        }
        ModuleDTO other = (ModuleDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$startCommand = this.getStartCommand();
        String other$startCommand = other.getStartCommand();
        if (this$startCommand == null ? other$startCommand != null : !this$startCommand.equals(other$startCommand)) {
            return false;
        }
        String this$stopCommand = this.getStopCommand();
        String other$stopCommand = other.getStopCommand();
        if (this$stopCommand == null ? other$stopCommand != null : !this$stopCommand.equals(other$stopCommand)) {
            return false;
        }
        String this$checkCommand = this.getCheckCommand();
        String other$checkCommand = other.getCheckCommand();
        if (this$checkCommand == null ? other$checkCommand != null : !this$checkCommand.equals(other$checkCommand)) {
            return false;
        }
        String this$installCommand = this.getInstallCommand();
        String other$installCommand = other.getInstallCommand();
        if (this$installCommand == null ? other$installCommand != null : !this$installCommand.equals(other$installCommand)) {
            return false;
        }
        String this$uninstallCommand = this.getUninstallCommand();
        String other$uninstallCommand = other.getUninstallCommand();
        if (this$uninstallCommand == null ? other$uninstallCommand != null : !this$uninstallCommand.equals(other$uninstallCommand)) {
            return false;
        }
        List<PackageHistory> this$packageHistoryList = this.getPackageHistoryList();
        List<PackageHistory> other$packageHistoryList = other.getPackageHistoryList();
        return !(this$packageHistoryList == null ? other$packageHistoryList != null : !((Object)this$packageHistoryList).equals(other$packageHistoryList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModuleDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $startCommand = this.getStartCommand();
        result = result * 59 + ($startCommand == null ? 43 : $startCommand.hashCode());
        String $stopCommand = this.getStopCommand();
        result = result * 59 + ($stopCommand == null ? 43 : $stopCommand.hashCode());
        String $checkCommand = this.getCheckCommand();
        result = result * 59 + ($checkCommand == null ? 43 : $checkCommand.hashCode());
        String $installCommand = this.getInstallCommand();
        result = result * 59 + ($installCommand == null ? 43 : $installCommand.hashCode());
        String $uninstallCommand = this.getUninstallCommand();
        result = result * 59 + ($uninstallCommand == null ? 43 : $uninstallCommand.hashCode());
        List<PackageHistory> $packageHistoryList = this.getPackageHistoryList();
        result = result * 59 + ($packageHistoryList == null ? 43 : ((Object)$packageHistoryList).hashCode());
        return result;
    }

    public String toString() {
        return "ModuleDTO(startCommand=" + this.getStartCommand() + ", stopCommand=" + this.getStopCommand() + ", checkCommand=" + this.getCheckCommand() + ", installCommand=" + this.getInstallCommand() + ", uninstallCommand=" + this.getUninstallCommand() + ", packageHistoryList=" + this.getPackageHistoryList() + ")";
    }

    public ModuleDTO() {
        this.packageHistoryList = ModuleDTO.$default$packageHistoryList();
    }

    public ModuleDTO(String startCommand, String stopCommand, String checkCommand, String installCommand, String uninstallCommand, List<PackageHistory> packageHistoryList) {
        this.startCommand = startCommand;
        this.stopCommand = stopCommand;
        this.checkCommand = checkCommand;
        this.installCommand = installCommand;
        this.uninstallCommand = uninstallCommand;
        this.packageHistoryList = packageHistoryList;
    }

    public static class ModuleDTOBuilder {
        private String startCommand;
        private String stopCommand;
        private String checkCommand;
        private String installCommand;
        private String uninstallCommand;
        private boolean packageHistoryList$set;
        private List<PackageHistory> packageHistoryList$value;

        ModuleDTOBuilder() {
        }

        public ModuleDTOBuilder startCommand(String startCommand) {
            this.startCommand = startCommand;
            return this;
        }

        public ModuleDTOBuilder stopCommand(String stopCommand) {
            this.stopCommand = stopCommand;
            return this;
        }

        public ModuleDTOBuilder checkCommand(String checkCommand) {
            this.checkCommand = checkCommand;
            return this;
        }

        public ModuleDTOBuilder installCommand(String installCommand) {
            this.installCommand = installCommand;
            return this;
        }

        public ModuleDTOBuilder uninstallCommand(String uninstallCommand) {
            this.uninstallCommand = uninstallCommand;
            return this;
        }

        public ModuleDTOBuilder packageHistoryList(List<PackageHistory> packageHistoryList) {
            this.packageHistoryList$value = packageHistoryList;
            this.packageHistoryList$set = true;
            return this;
        }

        public ModuleDTO build() {
            List packageHistoryList$value = this.packageHistoryList$value;
            if (!this.packageHistoryList$set) {
                packageHistoryList$value = ModuleDTO.$default$packageHistoryList();
            }
            return new ModuleDTO(this.startCommand, this.stopCommand, this.checkCommand, this.installCommand, this.uninstallCommand, packageHistoryList$value);
        }

        public String toString() {
            return "ModuleDTO.ModuleDTOBuilder(startCommand=" + this.startCommand + ", stopCommand=" + this.stopCommand + ", checkCommand=" + this.checkCommand + ", installCommand=" + this.installCommand + ", uninstallCommand=" + this.uninstallCommand + ", packageHistoryList$value=" + this.packageHistoryList$value + ")";
        }
    }
}

