/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.kudu;

public enum KuduType {
    BOOLEAN("boolean", "bool"),
    INT("int", "int32"),
    LONG("long", "int64"),
    FLOAT("float", "float"),
    DOUBLE("double", "double"),
    DATE("date", "date"),
    TIMESTAMP("timestamp", "unixtime_micros"),
    STRING("string", "string"),
    BINARY("binary", "binary"),
    FIXED("fixed", null),
    DECIMAL("decimal", "decimal");

    private final String type;
    private final String kuduType;

    private KuduType(String type, String kuduType) {
        this.type = type;
        this.kuduType = kuduType;
    }

    public static KuduType forType(String type) {
        for (KuduType ibType : KuduType.values()) {
            if (!ibType.getType().equalsIgnoreCase(type)) continue;
            return ibType;
        }
        throw new IllegalArgumentException(String.format("invalid type = %s", type));
    }

    public static final KuduType forKuduType(String kuduType) {
        for (KuduType type : KuduType.values()) {
            if (type.getKuduType() != kuduType) continue;
            return type;
        }
        throw new IllegalArgumentException(String.format("invalid kudu type = %s", kuduType));
    }

    public String kuduType() {
        return this.kuduType;
    }

    public String getType() {
        return this.type;
    }

    public String getKuduType() {
        return this.kuduType;
    }
}

