/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.node.provider;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.inlong.manager.common.fieldtype.strategy.FieldTypeMappingStrategy;
import org.apache.inlong.manager.common.fieldtype.strategy.FieldTypeStrategyFactory;
import org.apache.inlong.manager.pojo.sink.mysql.MySQLSink;
import org.apache.inlong.manager.pojo.sink.mysql.MySQLSinkDTO;
import org.apache.inlong.manager.pojo.sort.node.base.LoadNodeProvider;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.stream.StreamNode;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.node.load.MySqlLoadNode;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MySQLProvider
implements LoadNodeProvider {
    @Autowired
    private FieldTypeStrategyFactory fieldTypeStrategyFactory;

    @Override
    public Boolean accept(String sinkType) {
        return "MYSQL".equals(sinkType);
    }

    @Override
    public LoadNode createLoadNode(StreamNode nodeInfo, Map<String, StreamField> constantFieldMap) {
        MySQLSink mysqlSink = (MySQLSink)nodeInfo;
        Map<String, String> properties = this.parseProperties(mysqlSink.getProperties());
        FieldTypeMappingStrategy fieldTypeMappingStrategy = this.fieldTypeStrategyFactory.getInstance(mysqlSink.getSinkType());
        List<FieldInfo> fieldInfos = this.parseSinkFieldInfos(mysqlSink.getSinkFieldList(), mysqlSink.getSinkName(), fieldTypeMappingStrategy);
        List<FieldRelation> fieldRelations = this.parseSinkFields(mysqlSink.getSinkFieldList(), constantFieldMap);
        return new MySqlLoadNode(mysqlSink.getSinkName(), mysqlSink.getSinkName(), fieldInfos, fieldRelations, (List)Lists.newArrayList(), null, null, properties, MySQLSinkDTO.setDbNameToUrl(mysqlSink.getJdbcUrl(), mysqlSink.getDatabaseName()), mysqlSink.getUsername(), mysqlSink.getPassword(), mysqlSink.getTableName(), mysqlSink.getPrimaryKey());
    }
}

