/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.user;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.Set;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@ApiModel(value="User info")
public class UserInfo {
    @ApiModelProperty(value="Primary key")
    private Integer id;
    @ApiModelProperty(value="Username")
    private String name;
    @ApiModelProperty(value="Login Tenant")
    private String tenant;
    @ApiModelProperty(value="User password")
    private String password;
    @ApiModelProperty(value="Secret key")
    private String secretKey;
    @ApiModelProperty(value="Public key")
    private String publicKey;
    @ApiModelProperty(value="Private key")
    private String privateKey;
    @ApiModelProperty(value="Encryption key version")
    private Integer encryptVersion;
    @ApiModelProperty(value="Account type: 0 - manager, 1 - operator", required=true)
    private Integer accountType;
    @Min(value=1L)
    @NotNull(message="validDays cannot be null")
    @ApiModelProperty(value="Valid days", required=true)
    private @Min(value=1L) @NotNull(message="validDays cannot be null") Integer validDays;
    @ApiModelProperty(value="Name of creator")
    private String creator;
    @ApiModelProperty(value="Name of modifier")
    private String modifier;
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ", timezone="GMT+8")
    private Date createTime;
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ", timezone="GMT+8")
    private Date modifyTime;
    @ApiModelProperty(value="User status, valid or not")
    private String status;
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ", timezone="GMT+8")
    private Date dueDate;
    @ApiModelProperty(value="User roles")
    private Set<String> roles;
    @ApiModelProperty(value="Version number")
    private Integer version;
    @ApiModelProperty(value="Extension json info")
    private String extParams;

    public static UserInfoBuilder builder() {
        return new UserInfoBuilder();
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public Integer getEncryptVersion() {
        return this.encryptVersion;
    }

    public Integer getAccountType() {
        return this.accountType;
    }

    public Integer getValidDays() {
        return this.validDays;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public String getStatus() {
        return this.status;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public Integer getVersion() {
        return this.version;
    }

    public String getExtParams() {
        return this.extParams;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public void setEncryptVersion(Integer encryptVersion) {
        this.encryptVersion = encryptVersion;
    }

    public void setAccountType(Integer accountType) {
        this.accountType = accountType;
    }

    public void setValidDays(Integer validDays) {
        this.validDays = validDays;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ", timezone="GMT+8")
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ", timezone="GMT+8")
    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ", timezone="GMT+8")
    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setExtParams(String extParams) {
        this.extParams = extParams;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserInfo)) {
            return false;
        }
        UserInfo other = (UserInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$encryptVersion = this.getEncryptVersion();
        Integer other$encryptVersion = other.getEncryptVersion();
        if (this$encryptVersion == null ? other$encryptVersion != null : !((Object)this$encryptVersion).equals(other$encryptVersion)) {
            return false;
        }
        Integer this$accountType = this.getAccountType();
        Integer other$accountType = other.getAccountType();
        if (this$accountType == null ? other$accountType != null : !((Object)this$accountType).equals(other$accountType)) {
            return false;
        }
        Integer this$validDays = this.getValidDays();
        Integer other$validDays = other.getValidDays();
        if (this$validDays == null ? other$validDays != null : !((Object)this$validDays).equals(other$validDays)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$secretKey = this.getSecretKey();
        String other$secretKey = other.getSecretKey();
        if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
            return false;
        }
        String this$publicKey = this.getPublicKey();
        String other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        String this$privateKey = this.getPrivateKey();
        String other$privateKey = other.getPrivateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Date this$modifyTime = this.getModifyTime();
        Date other$modifyTime = other.getModifyTime();
        if (this$modifyTime == null ? other$modifyTime != null : !((Object)this$modifyTime).equals(other$modifyTime)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Date this$dueDate = this.getDueDate();
        Date other$dueDate = other.getDueDate();
        if (this$dueDate == null ? other$dueDate != null : !((Object)this$dueDate).equals(other$dueDate)) {
            return false;
        }
        Set<String> this$roles = this.getRoles();
        Set<String> other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        String this$extParams = this.getExtParams();
        String other$extParams = other.getExtParams();
        return !(this$extParams == null ? other$extParams != null : !this$extParams.equals(other$extParams));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $encryptVersion = this.getEncryptVersion();
        result = result * 59 + ($encryptVersion == null ? 43 : ((Object)$encryptVersion).hashCode());
        Integer $accountType = this.getAccountType();
        result = result * 59 + ($accountType == null ? 43 : ((Object)$accountType).hashCode());
        Integer $validDays = this.getValidDays();
        result = result * 59 + ($validDays == null ? 43 : ((Object)$validDays).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $secretKey = this.getSecretKey();
        result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
        String $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        String $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Date $modifyTime = this.getModifyTime();
        result = result * 59 + ($modifyTime == null ? 43 : ((Object)$modifyTime).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Date $dueDate = this.getDueDate();
        result = result * 59 + ($dueDate == null ? 43 : ((Object)$dueDate).hashCode());
        Set<String> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        String $extParams = this.getExtParams();
        result = result * 59 + ($extParams == null ? 43 : $extParams.hashCode());
        return result;
    }

    public String toString() {
        return "UserInfo(id=" + this.getId() + ", name=" + this.getName() + ", tenant=" + this.getTenant() + ", password=" + this.getPassword() + ", secretKey=" + this.getSecretKey() + ", publicKey=" + this.getPublicKey() + ", privateKey=" + this.getPrivateKey() + ", encryptVersion=" + this.getEncryptVersion() + ", accountType=" + this.getAccountType() + ", validDays=" + this.getValidDays() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", createTime=" + this.getCreateTime() + ", modifyTime=" + this.getModifyTime() + ", status=" + this.getStatus() + ", dueDate=" + this.getDueDate() + ", roles=" + this.getRoles() + ", version=" + this.getVersion() + ", extParams=" + this.getExtParams() + ")";
    }

    public UserInfo(Integer id, String name, String tenant, String password, String secretKey, String publicKey, String privateKey, Integer encryptVersion, Integer accountType, Integer validDays, String creator, String modifier, Date createTime, Date modifyTime, String status, Date dueDate, Set<String> roles, Integer version, String extParams) {
        this.id = id;
        this.name = name;
        this.tenant = tenant;
        this.password = password;
        this.secretKey = secretKey;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.encryptVersion = encryptVersion;
        this.accountType = accountType;
        this.validDays = validDays;
        this.creator = creator;
        this.modifier = modifier;
        this.createTime = createTime;
        this.modifyTime = modifyTime;
        this.status = status;
        this.dueDate = dueDate;
        this.roles = roles;
        this.version = version;
        this.extParams = extParams;
    }

    public UserInfo() {
    }

    public static class UserInfoBuilder {
        private Integer id;
        private String name;
        private String tenant;
        private String password;
        private String secretKey;
        private String publicKey;
        private String privateKey;
        private Integer encryptVersion;
        private Integer accountType;
        private Integer validDays;
        private String creator;
        private String modifier;
        private Date createTime;
        private Date modifyTime;
        private String status;
        private Date dueDate;
        private Set<String> roles;
        private Integer version;
        private String extParams;

        UserInfoBuilder() {
        }

        public UserInfoBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        public UserInfoBuilder name(String name) {
            this.name = name;
            return this;
        }

        public UserInfoBuilder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public UserInfoBuilder password(String password) {
            this.password = password;
            return this;
        }

        public UserInfoBuilder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public UserInfoBuilder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public UserInfoBuilder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public UserInfoBuilder encryptVersion(Integer encryptVersion) {
            this.encryptVersion = encryptVersion;
            return this;
        }

        public UserInfoBuilder accountType(Integer accountType) {
            this.accountType = accountType;
            return this;
        }

        public UserInfoBuilder validDays(Integer validDays) {
            this.validDays = validDays;
            return this;
        }

        public UserInfoBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public UserInfoBuilder modifier(String modifier) {
            this.modifier = modifier;
            return this;
        }

        @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ", timezone="GMT+8")
        public UserInfoBuilder createTime(Date createTime) {
            this.createTime = createTime;
            return this;
        }

        @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ", timezone="GMT+8")
        public UserInfoBuilder modifyTime(Date modifyTime) {
            this.modifyTime = modifyTime;
            return this;
        }

        public UserInfoBuilder status(String status) {
            this.status = status;
            return this;
        }

        @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ", timezone="GMT+8")
        public UserInfoBuilder dueDate(Date dueDate) {
            this.dueDate = dueDate;
            return this;
        }

        public UserInfoBuilder roles(Set<String> roles) {
            this.roles = roles;
            return this;
        }

        public UserInfoBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        public UserInfoBuilder extParams(String extParams) {
            this.extParams = extParams;
            return this;
        }

        public UserInfo build() {
            return new UserInfo(this.id, this.name, this.tenant, this.password, this.secretKey, this.publicKey, this.privateKey, this.encryptVersion, this.accountType, this.validDays, this.creator, this.modifier, this.createTime, this.modifyTime, this.status, this.dueDate, this.roles, this.version, this.extParams);
        }

        public String toString() {
            return "UserInfo.UserInfoBuilder(id=" + this.id + ", name=" + this.name + ", tenant=" + this.tenant + ", password=" + this.password + ", secretKey=" + this.secretKey + ", publicKey=" + this.publicKey + ", privateKey=" + this.privateKey + ", encryptVersion=" + this.encryptVersion + ", accountType=" + this.accountType + ", validDays=" + this.validDays + ", creator=" + this.creator + ", modifier=" + this.modifier + ", createTime=" + this.createTime + ", modifyTime=" + this.modifyTime + ", status=" + this.status + ", dueDate=" + this.dueDate + ", roles=" + this.roles + ", version=" + this.version + ", extParams=" + this.extParams + ")";
        }
    }
}

