/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.Builder;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.Tuple;
import redis.clients.util.JedisByteHashMap;
import redis.clients.util.SafeEncoder;

public final class BuilderFactory {
    public static final Builder<Double> DOUBLE = new Builder<Double>(){

        @Override
        public Double build(Object data) {
            String asString = STRING.build(data);
            return asString == null ? null : Double.valueOf(asString);
        }

        public String toString() {
            return "double";
        }
    };
    public static final Builder<Boolean> BOOLEAN = new Builder<Boolean>(){

        @Override
        public Boolean build(Object data) {
            return (Long)data == 1L;
        }

        public String toString() {
            return "boolean";
        }
    };
    public static final Builder<byte[]> BYTE_ARRAY = new Builder<byte[]>(){

        @Override
        public byte[] build(Object data) {
            return (byte[])data;
        }

        public String toString() {
            return "byte[]";
        }
    };
    public static final Builder<Long> LONG = new Builder<Long>(){

        @Override
        public Long build(Object data) {
            return (Long)data;
        }

        public String toString() {
            return "long";
        }
    };
    public static final Builder<String> STRING = new Builder<String>(){

        @Override
        public String build(Object data) {
            return data == null ? null : SafeEncoder.encode((byte[])data);
        }

        public String toString() {
            return "string";
        }
    };
    public static final Builder<List<String>> STRING_LIST = new Builder<List<String>>(){

        @Override
        public List<String> build(Object data) {
            if (null == data) {
                return Collections.emptyList();
            }
            List l = (List)data;
            ArrayList<String> result = new ArrayList<String>(l.size());
            for (byte[] barray : l) {
                if (barray == null) {
                    result.add(null);
                    continue;
                }
                result.add(SafeEncoder.encode(barray));
            }
            return result;
        }

        public String toString() {
            return "List<String>";
        }
    };
    public static final Builder<Map<String, String>> STRING_MAP = new Builder<Map<String, String>>(){

        @Override
        public Map<String, String> build(Object data) {
            List flatHash = (List)data;
            HashMap<String, String> hash = new HashMap<String, String>(flatHash.size() / 2, 1.0f);
            Iterator iterator = flatHash.iterator();
            while (iterator.hasNext()) {
                hash.put(SafeEncoder.encode((byte[])iterator.next()), SafeEncoder.encode((byte[])iterator.next()));
            }
            return hash;
        }

        public String toString() {
            return "Map<String, String>";
        }
    };
    public static final Builder<Map<String, String>> PUBSUB_NUMSUB_MAP = new Builder<Map<String, String>>(){

        @Override
        public Map<String, String> build(Object data) {
            List flatHash = (List)data;
            HashMap<String, String> hash = new HashMap<String, String>(flatHash.size() / 2, 1.0f);
            Iterator iterator = flatHash.iterator();
            while (iterator.hasNext()) {
                hash.put(SafeEncoder.encode((byte[])iterator.next()), String.valueOf((Long)iterator.next()));
            }
            return hash;
        }

        public String toString() {
            return "PUBSUB_NUMSUB_MAP<String, String>";
        }
    };
    public static final Builder<Set<String>> STRING_SET = new Builder<Set<String>>(){

        @Override
        public Set<String> build(Object data) {
            if (null == data) {
                return Collections.emptySet();
            }
            List l = (List)data;
            HashSet<String> result = new HashSet<String>(l.size());
            for (byte[] barray : l) {
                if (barray == null) {
                    result.add(null);
                    continue;
                }
                result.add(SafeEncoder.encode(barray));
            }
            return result;
        }

        public String toString() {
            return "Set<String>";
        }
    };
    public static final Builder<List<byte[]>> BYTE_ARRAY_LIST = new Builder<List<byte[]>>(){

        @Override
        public List<byte[]> build(Object data) {
            if (null == data) {
                return Collections.emptyList();
            }
            List l = (List)data;
            return l;
        }

        public String toString() {
            return "List<byte[]>";
        }
    };
    public static final Builder<Set<byte[]>> BYTE_ARRAY_ZSET = new Builder<Set<byte[]>>(){

        @Override
        public Set<byte[]> build(Object data) {
            if (null == data) {
                return Collections.emptySet();
            }
            List l = (List)data;
            LinkedHashSet<byte[]> result = new LinkedHashSet<byte[]>(l);
            for (byte[] barray : l) {
                if (barray == null) {
                    result.add(null);
                    continue;
                }
                result.add(barray);
            }
            return result;
        }

        public String toString() {
            return "ZSet<byte[]>";
        }
    };
    public static final Builder<Map<byte[], byte[]>> BYTE_ARRAY_MAP = new Builder<Map<byte[], byte[]>>(){

        @Override
        public Map<byte[], byte[]> build(Object data) {
            List flatHash = (List)data;
            JedisByteHashMap hash = new JedisByteHashMap();
            Iterator iterator = flatHash.iterator();
            while (iterator.hasNext()) {
                hash.put(iterator.next(), iterator.next());
            }
            return hash;
        }

        public String toString() {
            return "Map<byte[], byte[]>";
        }
    };
    public static final Builder<Set<String>> STRING_ZSET = new Builder<Set<String>>(){

        @Override
        public Set<String> build(Object data) {
            if (null == data) {
                return Collections.emptySet();
            }
            List l = (List)data;
            LinkedHashSet<String> result = new LinkedHashSet<String>(l.size());
            for (byte[] barray : l) {
                if (barray == null) {
                    result.add(null);
                    continue;
                }
                result.add(SafeEncoder.encode(barray));
            }
            return result;
        }

        public String toString() {
            return "ZSet<String>";
        }
    };
    public static final Builder<Set<Tuple>> TUPLE_ZSET = new Builder<Set<Tuple>>(){

        @Override
        public Set<Tuple> build(Object data) {
            if (null == data) {
                return Collections.emptySet();
            }
            List l = (List)data;
            LinkedHashSet<Tuple> result = new LinkedHashSet<Tuple>(l.size());
            Iterator iterator = l.iterator();
            while (iterator.hasNext()) {
                result.add(new Tuple(SafeEncoder.encode((byte[])iterator.next()), Double.valueOf(SafeEncoder.encode((byte[])iterator.next()))));
            }
            return result;
        }

        public String toString() {
            return "ZSet<Tuple>";
        }
    };
    public static final Builder<Set<Tuple>> TUPLE_ZSET_BINARY = new Builder<Set<Tuple>>(){

        @Override
        public Set<Tuple> build(Object data) {
            if (null == data) {
                return Collections.emptySet();
            }
            List l = (List)data;
            LinkedHashSet<Tuple> result = new LinkedHashSet<Tuple>(l.size());
            Iterator iterator = l.iterator();
            while (iterator.hasNext()) {
                result.add(new Tuple((byte[])iterator.next(), Double.valueOf(SafeEncoder.encode((byte[])iterator.next()))));
            }
            return result;
        }

        public String toString() {
            return "ZSet<Tuple>";
        }
    };
    public static final Builder<Object> EVAL_RESULT = new Builder<Object>(){

        @Override
        public Object build(Object data) {
            return this.evalResult(data);
        }

        public String toString() {
            return "Eval<Object>";
        }

        private Object evalResult(Object result) {
            if (result instanceof byte[]) {
                return SafeEncoder.encode((byte[])result);
            }
            if (result instanceof List) {
                List list = (List)result;
                ArrayList<Object> listResult = new ArrayList<Object>(list.size());
                for (Object bin : list) {
                    listResult.add(this.evalResult(bin));
                }
                return listResult;
            }
            return result;
        }
    };
    public static final Builder<Object> EVAL_BINARY_RESULT = new Builder<Object>(){

        @Override
        public Object build(Object data) {
            return this.evalResult(data);
        }

        public String toString() {
            return "Eval<Object>";
        }

        private Object evalResult(Object result) {
            if (result instanceof List) {
                List list = (List)result;
                ArrayList<Object> listResult = new ArrayList<Object>(list.size());
                for (Object bin : list) {
                    listResult.add(this.evalResult(bin));
                }
                return listResult;
            }
            return result;
        }
    };
    public static final Builder<List<GeoCoordinate>> GEO_COORDINATE_LIST = new Builder<List<GeoCoordinate>>(){

        @Override
        public List<GeoCoordinate> build(Object data) {
            if (null == data) {
                return Collections.emptyList();
            }
            return this.interpretGeoposResult((List)data);
        }

        public String toString() {
            return "List<GeoCoordinate>";
        }

        private List<GeoCoordinate> interpretGeoposResult(List<Object> responses) {
            ArrayList<GeoCoordinate> responseCoordinate = new ArrayList<GeoCoordinate>(responses.size());
            for (Object response : responses) {
                if (response == null) {
                    responseCoordinate.add(null);
                    continue;
                }
                List respList = (List)response;
                GeoCoordinate coord = new GeoCoordinate(Double.parseDouble(SafeEncoder.encode((byte[])respList.get(0))), Double.parseDouble(SafeEncoder.encode((byte[])respList.get(1))));
                responseCoordinate.add(coord);
            }
            return responseCoordinate;
        }
    };
    public static final Builder<List<GeoRadiusResponse>> GEORADIUS_WITH_PARAMS_RESULT = new Builder<List<GeoRadiusResponse>>(){

        @Override
        public List<GeoRadiusResponse> build(Object data) {
            if (data == null) {
                return Collections.emptyList();
            }
            List objectList = (List)data;
            if (objectList.isEmpty()) {
                return new ArrayList<GeoRadiusResponse>();
            }
            ArrayList<GeoRadiusResponse> responses = new ArrayList<GeoRadiusResponse>(objectList.size());
            if (objectList.get(0) instanceof List) {
                for (Object obj : objectList) {
                    List informations = (List)obj;
                    GeoRadiusResponse resp = new GeoRadiusResponse((byte[])informations.get(0));
                    int size = informations.size();
                    for (int idx = 1; idx < size; ++idx) {
                        Object info = informations.get(idx);
                        if (info instanceof List) {
                            List coord = (List)info;
                            resp.setCoordinate(new GeoCoordinate(this.convertByteArrayToDouble(coord.get(0)), this.convertByteArrayToDouble(coord.get(1))));
                            continue;
                        }
                        resp.setDistance(this.convertByteArrayToDouble(info));
                    }
                    responses.add(resp);
                }
            } else {
                for (Object obj : objectList) {
                    responses.add(new GeoRadiusResponse((byte[])obj));
                }
            }
            return responses;
        }

        private Double convertByteArrayToDouble(Object obj) {
            return Double.valueOf(SafeEncoder.encode((byte[])obj));
        }

        public String toString() {
            return "GeoRadiusWithParamsResult";
        }
    };
    public static final Builder<List<Long>> LONG_LIST = new Builder<List<Long>>(){

        @Override
        public List<Long> build(Object data) {
            if (null == data) {
                return null;
            }
            return (List)data;
        }

        public String toString() {
            return "List<Long>";
        }
    };

    private BuilderFactory() {
        throw new InstantiationError("Must not instantiate this class");
    }
}

