/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.legacy;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.LegacyV1AbstractSourceInfoStructMaker;
import io.debezium.connector.mysql.legacy.SourceInfo;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

public class LegacyV1MySqlSourceInfoStructMaker
extends LegacyV1AbstractSourceInfoStructMaker<SourceInfo> {
    private final Schema schema = this.commonSchemaBuilder().name("io.debezium.connector.mysql.Source").field("name", Schema.STRING_SCHEMA).field("server_id", Schema.INT64_SCHEMA).field("ts_sec", Schema.INT64_SCHEMA).field("gtid", Schema.OPTIONAL_STRING_SCHEMA).field("file", Schema.STRING_SCHEMA).field("pos", Schema.INT64_SCHEMA).field("row", Schema.INT32_SCHEMA).field("snapshot", SchemaBuilder.bool().optional().defaultValue((Object)false).build()).field("thread", Schema.OPTIONAL_INT64_SCHEMA).field("db", Schema.OPTIONAL_STRING_SCHEMA).field("table", Schema.OPTIONAL_STRING_SCHEMA).field("query", Schema.OPTIONAL_STRING_SCHEMA).build();

    public LegacyV1MySqlSourceInfoStructMaker(String connector, String version, CommonConnectorConfig connectorConfig) {
        super(connector, version, connectorConfig);
    }

    public Schema schema() {
        return this.schema;
    }

    public Struct struct(SourceInfo sourceInfo) {
        Struct result = this.commonStruct();
        result.put("name", (Object)this.serverName);
        result.put("server_id", (Object)sourceInfo.getServerId());
        if (sourceInfo.getCurrentGtid() != null) {
            result.put("gtid", (Object)sourceInfo.getCurrentGtid());
        }
        result.put("file", (Object)sourceInfo.getCurrentBinlogFilename());
        result.put("pos", (Object)sourceInfo.getCurrentBinlogPosition());
        result.put("row", (Object)sourceInfo.getCurrentRowNumber());
        result.put("ts_sec", (Object)sourceInfo.getBinlogTimestampSeconds());
        if (sourceInfo.isLastSnapshot()) {
            result.put("snapshot", (Object)true);
        }
        if (sourceInfo.getThreadId() >= 0L) {
            result.put("thread", (Object)sourceInfo.getThreadId());
        }
        if (sourceInfo.database() != null) {
            result.put("db", (Object)sourceInfo.database());
        }
        if (sourceInfo.table() != null) {
            result.put("table", (Object)sourceInfo.table());
        }
        if (sourceInfo.getQuery() != null) {
            result.put("query", (Object)sourceInfo.getQuery());
        }
        return result;
    }
}

