//*
// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.17.3
// source: BrokerService.proto

package protocol

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type TransferedMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MessageId   *int64 `protobuf:"varint,1,req,name=messageId" json:"messageId,omitempty"`
	CheckSum    *int32 `protobuf:"varint,2,req,name=checkSum" json:"checkSum,omitempty"`
	PayLoadData []byte `protobuf:"bytes,3,req,name=payLoadData" json:"payLoadData,omitempty"`
	Flag        *int32 `protobuf:"varint,4,req,name=flag" json:"flag,omitempty"`
}

func (x *TransferedMessage) Reset() {
	*x = TransferedMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_BrokerService_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferedMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferedMessage) ProtoMessage() {}

func (x *TransferedMessage) ProtoReflect() protoreflect.Message {
	mi := &file_BrokerService_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferedMessage.ProtoReflect.Descriptor instead.
func (*TransferedMessage) Descriptor() ([]byte, []int) {
	return file_BrokerService_proto_rawDescGZIP(), []int{0}
}

func (x *TransferedMessage) GetMessageId() int64 {
	if x != nil && x.MessageId != nil {
		return *x.MessageId
	}
	return 0
}

func (x *TransferedMessage) GetCheckSum() int32 {
	if x != nil && x.CheckSum != nil {
		return *x.CheckSum
	}
	return 0
}

func (x *TransferedMessage) GetPayLoadData() []byte {
	if x != nil {
		return x.PayLoadData
	}
	return nil
}

func (x *TransferedMessage) GetFlag() int32 {
	if x != nil && x.Flag != nil {
		return *x.Flag
	}
	return 0
}

type AuthorizedInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	VisitAuthorizedToken *int64  `protobuf:"varint,1,req,name=visitAuthorizedToken" json:"visitAuthorizedToken,omitempty"`
	AuthAuthorizedToken  *string `protobuf:"bytes,2,opt,name=authAuthorizedToken" json:"authAuthorizedToken,omitempty"`
}

func (x *AuthorizedInfo) Reset() {
	*x = AuthorizedInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_BrokerService_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthorizedInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthorizedInfo) ProtoMessage() {}

func (x *AuthorizedInfo) ProtoReflect() protoreflect.Message {
	mi := &file_BrokerService_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthorizedInfo.ProtoReflect.Descriptor instead.
func (*AuthorizedInfo) Descriptor() ([]byte, []int) {
	return file_BrokerService_proto_rawDescGZIP(), []int{1}
}

func (x *AuthorizedInfo) GetVisitAuthorizedToken() int64 {
	if x != nil && x.VisitAuthorizedToken != nil {
		return *x.VisitAuthorizedToken
	}
	return 0
}

func (x *AuthorizedInfo) GetAuthAuthorizedToken() string {
	if x != nil && x.AuthAuthorizedToken != nil {
		return *x.AuthAuthorizedToken
	}
	return ""
}

type SendMessageRequestP2B struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ClientId    *string         `protobuf:"bytes,1,req,name=clientId" json:"clientId,omitempty"`
	TopicName   *string         `protobuf:"bytes,2,req,name=topicName" json:"topicName,omitempty"`
	PartitionId *int32          `protobuf:"varint,3,req,name=partitionId" json:"partitionId,omitempty"`
	Data        []byte          `protobuf:"bytes,4,req,name=data" json:"data,omitempty"`
	Flag        *int32          `protobuf:"varint,5,req,name=flag" json:"flag,omitempty"`
	CheckSum    *int32          `protobuf:"varint,6,req,name=checkSum" json:"checkSum,omitempty"`
	SentAddr    *int32          `protobuf:"varint,7,req,name=sentAddr" json:"sentAddr,omitempty"`
	MsgType     *string         `protobuf:"bytes,8,opt,name=msgType" json:"msgType,omitempty"`
	MsgTime     *string         `protobuf:"bytes,9,opt,name=msgTime" json:"msgTime,omitempty"`
	AuthInfo    *AuthorizedInfo `protobuf:"bytes,10,opt,name=authInfo" json:"authInfo,omitempty"`
}

func (x *SendMessageRequestP2B) Reset() {
	*x = SendMessageRequestP2B{}
	if protoimpl.UnsafeEnabled {
		mi := &file_BrokerService_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SendMessageRequestP2B) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SendMessageRequestP2B) ProtoMessage() {}

func (x *SendMessageRequestP2B) ProtoReflect() protoreflect.Message {
	mi := &file_BrokerService_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SendMessageRequestP2B.ProtoReflect.Descriptor instead.
func (*SendMessageRequestP2B) Descriptor() ([]byte, []int) {
	return file_BrokerService_proto_rawDescGZIP(), []int{2}
}

func (x *SendMessageRequestP2B) GetClientId() string {
	if x != nil && x.ClientId != nil {
		return *x.ClientId
	}
	return ""
}

func (x *SendMessageRequestP2B) GetTopicName() string {
	if x != nil && x.TopicName != nil {
		return *x.TopicName
	}
	return ""
}

func (x *SendMessageRequestP2B) GetPartitionId() int32 {
	if x != nil && x.PartitionId != nil {
		return *x.PartitionId
	}
	return 0
}

func (x *SendMessageRequestP2B) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *SendMessageRequestP2B) GetFlag() int32 {
	if x != nil && x.Flag != nil {
		return *x.Flag
	}
	return 0
}

func (x *SendMessageRequestP2B) GetCheckSum() int32 {
	if x != nil && x.CheckSum != nil {
		return *x.CheckSum
	}
	return 0
}

func (x *SendMessageRequestP2B) GetSentAddr() int32 {
	if x != nil && x.SentAddr != nil {
		return *x.SentAddr
	}
	return 0
}

func (x *SendMessageRequestP2B) GetMsgType() string {
	if x != nil && x.MsgType != nil {
		return *x.MsgType
	}
	return ""
}

func (x *SendMessageRequestP2B) GetMsgTime() string {
	if x != nil && x.MsgTime != nil {
		return *x.MsgTime
	}
	return ""
}

func (x *SendMessageRequestP2B) GetAuthInfo() *AuthorizedInfo {
	if x != nil {
		return x.AuthInfo
	}
	return nil
}

type SendMessageResponseB2P struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Success      *bool   `protobuf:"varint,1,req,name=success" json:"success,omitempty"`
	ErrCode      *int32  `protobuf:"varint,2,req,name=errCode" json:"errCode,omitempty"`
	ErrMsg       *string `protobuf:"bytes,3,req,name=errMsg" json:"errMsg,omitempty"`
	RequireAuth  *bool   `protobuf:"varint,4,opt,name=requireAuth" json:"requireAuth,omitempty"`
	MessageId    *int64  `protobuf:"varint,5,opt,name=messageId" json:"messageId,omitempty"`
	AppendTime   *int64  `protobuf:"varint,6,opt,name=appendTime" json:"appendTime,omitempty"`
	AppendOffset *int64  `protobuf:"varint,7,opt,name=appendOffset" json:"appendOffset,omitempty"`
}

func (x *SendMessageResponseB2P) Reset() {
	*x = SendMessageResponseB2P{}
	if protoimpl.UnsafeEnabled {
		mi := &file_BrokerService_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SendMessageResponseB2P) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SendMessageResponseB2P) ProtoMessage() {}

func (x *SendMessageResponseB2P) ProtoReflect() protoreflect.Message {
	mi := &file_BrokerService_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SendMessageResponseB2P.ProtoReflect.Descriptor instead.
func (*SendMessageResponseB2P) Descriptor() ([]byte, []int) {
	return file_BrokerService_proto_rawDescGZIP(), []int{3}
}

func (x *SendMessageResponseB2P) GetSuccess() bool {
	if x != nil && x.Success != nil {
		return *x.Success
	}
	return false
}

func (x *SendMessageResponseB2P) GetErrCode() int32 {
	if x != nil && x.ErrCode != nil {
		return *x.ErrCode
	}
	return 0
}

func (x *SendMessageResponseB2P) GetErrMsg() string {
	if x != nil && x.ErrMsg != nil {
		return *x.ErrMsg
	}
	return ""
}

func (x *SendMessageResponseB2P) GetRequireAuth() bool {
	if x != nil && x.RequireAuth != nil {
		return *x.RequireAuth
	}
	return false
}

func (x *SendMessageResponseB2P) GetMessageId() int64 {
	if x != nil && x.MessageId != nil {
		return *x.MessageId
	}
	return 0
}

func (x *SendMessageResponseB2P) GetAppendTime() int64 {
	if x != nil && x.AppendTime != nil {
		return *x.AppendTime
	}
	return 0
}

func (x *SendMessageResponseB2P) GetAppendOffset() int64 {
	if x != nil && x.AppendOffset != nil {
		return *x.AppendOffset
	}
	return 0
}

type RegisterRequestC2B struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	OpType        *int32          `protobuf:"varint,1,req,name=opType" json:"opType,omitempty"`
	ClientId      *string         `protobuf:"bytes,2,req,name=clientId" json:"clientId,omitempty"`
	GroupName     *string         `protobuf:"bytes,3,req,name=groupName" json:"groupName,omitempty"`
	TopicName     *string         `protobuf:"bytes,4,req,name=topicName" json:"topicName,omitempty"`
	PartitionId   *int32          `protobuf:"varint,5,req,name=partitionId" json:"partitionId,omitempty"`
	ReadStatus    *int32          `protobuf:"varint,6,req,name=readStatus" json:"readStatus,omitempty"`
	FilterCondStr []string        `protobuf:"bytes,7,rep,name=filterCondStr" json:"filterCondStr,omitempty"`
	CurrOffset    *int64          `protobuf:"varint,8,opt,name=currOffset" json:"currOffset,omitempty"`
	SessionKey    *string         `protobuf:"bytes,9,opt,name=sessionKey" json:"sessionKey,omitempty"`
	SessionTime   *int64          `protobuf:"varint,10,opt,name=sessionTime" json:"sessionTime,omitempty"`
	SsdStoreId    *int64          `protobuf:"varint,11,opt,name=ssdStoreId" json:"ssdStoreId,omitempty"` // Deprecated
	QryPriorityId *int32          `protobuf:"varint,12,opt,name=qryPriorityId" json:"qryPriorityId,omitempty"`
	AuthInfo      *AuthorizedInfo `protobuf:"bytes,13,opt,name=authInfo" json:"authInfo,omitempty"`
}

func (x *RegisterRequestC2B) Reset() {
	*x = RegisterRequestC2B{}
	if protoimpl.UnsafeEnabled {
		mi := &file_BrokerService_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegisterRequestC2B) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterRequestC2B) ProtoMessage() {}

func (x *RegisterRequestC2B) ProtoReflect() protoreflect.Message {
	mi := &file_BrokerService_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterRequestC2B.ProtoReflect.Descriptor instead.
func (*RegisterRequestC2B) Descriptor() ([]byte, []int) {
	return file_BrokerService_proto_rawDescGZIP(), []int{4}
}

func (x *RegisterRequestC2B) GetOpType() int32 {
	if x != nil && x.OpType != nil {
		return *x.OpType
	}
	return 0
}

func (x *RegisterRequestC2B) GetClientId() string {
	if x != nil && x.ClientId != nil {
		return *x.ClientId
	}
	return ""
}

func (x *RegisterRequestC2B) GetGroupName() string {
	if x != nil && x.GroupName != nil {
		return *x.GroupName
	}
	return ""
}

func (x *RegisterRequestC2B) GetTopicName() string {
	if x != nil && x.TopicName != nil {
		return *x.TopicName
	}
	return ""
}

func (x *RegisterRequestC2B) GetPartitionId() int32 {
	if x != nil && x.PartitionId != nil {
		return *x.PartitionId
	}
	return 0
}

func (x *RegisterRequestC2B) GetReadStatus() int32 {
	if x != nil && x.ReadStatus != nil {
		return *x.ReadStatus
	}
	return 0
}

func (x *RegisterRequestC2B) GetFilterCondStr() []string {
	if x != nil {
		return x.FilterCondStr
	}
	return nil
}

func (x *RegisterRequestC2B) GetCurrOffset() int64 {
	if x != nil && x.CurrOffset != nil {
		return *x.CurrOffset
	}
	return 0
}

func (x *RegisterRequestC2B) GetSessionKey() string {
	if x != nil && x.SessionKey != nil {
		return *x.SessionKey
	}
	return ""
}

func (x *RegisterRequestC2B) GetSessionTime() int64 {
	if x != nil && x.SessionTime != nil {
		return *x.SessionTime
	}
	return 0
}

func (x *RegisterRequestC2B) GetSsdStoreId() int64 {
	if x != nil && x.SsdStoreId != nil {
		return *x.SsdStoreId
	}
	return 0
}

func (x *RegisterRequestC2B) GetQryPriorityId() int32 {
	if x != nil && x.QryPriorityId != nil {
		return *x.QryPriorityId
	}
	return 0
}

func (x *RegisterRequestC2B) GetAuthInfo() *AuthorizedInfo {
	if x != nil {
		return x.AuthInfo
	}
	return nil
}

type RegisterResponseB2C struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Success    *bool   `protobuf:"varint,1,req,name=success" json:"success,omitempty"`
	ErrCode    *int32  `protobuf:"varint,2,req,name=errCode" json:"errCode,omitempty"`
	ErrMsg     *string `protobuf:"bytes,3,req,name=errMsg" json:"errMsg,omitempty"`
	CurrOffset *int64  `protobuf:"varint,4,opt,name=currOffset" json:"currOffset,omitempty"`
	MaxOffset  *int64  `protobuf:"varint,5,opt,name=maxOffset" json:"maxOffset,omitempty"`
}

func (x *RegisterResponseB2C) Reset() {
	*x = RegisterResponseB2C{}
	if protoimpl.UnsafeEnabled {
		mi := &file_BrokerService_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegisterResponseB2C) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterResponseB2C) ProtoMessage() {}

func (x *RegisterResponseB2C) ProtoReflect() protoreflect.Message {
	mi := &file_BrokerService_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterResponseB2C.ProtoReflect.Descriptor instead.
func (*RegisterResponseB2C) Descriptor() ([]byte, []int) {
	return file_BrokerService_proto_rawDescGZIP(), []int{5}
}

func (x *RegisterResponseB2C) GetSuccess() bool {
	if x != nil && x.Success != nil {
		return *x.Success
	}
	return false
}

func (x *RegisterResponseB2C) GetErrCode() int32 {
	if x != nil && x.ErrCode != nil {
		return *x.ErrCode
	}
	return 0
}

func (x *RegisterResponseB2C) GetErrMsg() string {
	if x != nil && x.ErrMsg != nil {
		return *x.ErrMsg
	}
	return ""
}

func (x *RegisterResponseB2C) GetCurrOffset() int64 {
	if x != nil && x.CurrOffset != nil {
		return *x.CurrOffset
	}
	return 0
}

func (x *RegisterResponseB2C) GetMaxOffset() int64 {
	if x != nil && x.MaxOffset != nil {
		return *x.MaxOffset
	}
	return 0
}

type HeartBeatRequestC2B struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ClientId   *string `protobuf:"bytes,1,req,name=clientId" json:"clientId,omitempty"`
	GroupName  *string `protobuf:"bytes,2,req,name=groupName" json:"groupName,omitempty"`
	ReadStatus *int32  `protobuf:"varint,3,req,name=readStatus" json:"readStatus,omitempty"`
	// brokerId:host:port:topic:partitionId:delayTimeStamp
	PartitionInfo []string        `protobuf:"bytes,4,rep,name=partitionInfo" json:"partitionInfo,omitempty"`
	SsdStoreId    *int64          `protobuf:"varint,5,opt,name=ssdStoreId" json:"ssdStoreId,omitempty"` // Deprecated
	QryPriorityId *int32          `protobuf:"varint,6,opt,name=qryPriorityId" json:"qryPriorityId,omitempty"`
	AuthInfo      *AuthorizedInfo `protobuf:"bytes,7,opt,name=authInfo" json:"authInfo,omitempty"`
}

func (x *HeartBeatRequestC2B) Reset() {
	*x = HeartBeatRequestC2B{}
	if protoimpl.UnsafeEnabled {
		mi := &file_BrokerService_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HeartBeatRequestC2B) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HeartBeatRequestC2B) ProtoMessage() {}

func (x *HeartBeatRequestC2B) ProtoReflect() protoreflect.Message {
	mi := &file_BrokerService_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HeartBeatRequestC2B.ProtoReflect.Descriptor instead.
func (*HeartBeatRequestC2B) Descriptor() ([]byte, []int) {
	return file_BrokerService_proto_rawDescGZIP(), []int{6}
}

func (x *HeartBeatRequestC2B) GetClientId() string {
	if x != nil && x.ClientId != nil {
		return *x.ClientId
	}
	return ""
}

func (x *HeartBeatRequestC2B) GetGroupName() string {
	if x != nil && x.GroupName != nil {
		return *x.GroupName
	}
	return ""
}

func (x *HeartBeatRequestC2B) GetReadStatus() int32 {
	if x != nil && x.ReadStatus != nil {
		return *x.ReadStatus
	}
	return 0
}

func (x *HeartBeatRequestC2B) GetPartitionInfo() []string {
	if x != nil {
		return x.PartitionInfo
	}
	return nil
}

func (x *HeartBeatRequestC2B) GetSsdStoreId() int64 {
	if x != nil && x.SsdStoreId != nil {
		return *x.SsdStoreId
	}
	return 0
}

func (x *HeartBeatRequestC2B) GetQryPriorityId() int32 {
	if x != nil && x.QryPriorityId != nil {
		return *x.QryPriorityId
	}
	return 0
}

func (x *HeartBeatRequestC2B) GetAuthInfo() *AuthorizedInfo {
	if x != nil {
		return x.AuthInfo
	}
	return nil
}

type HeartBeatResponseB2C struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Success        *bool   `protobuf:"varint,1,req,name=success" json:"success,omitempty"`
	ErrCode        *int32  `protobuf:"varint,2,req,name=errCode" json:"errCode,omitempty"`
	ErrMsg         *string `protobuf:"bytes,3,req,name=errMsg" json:"errMsg,omitempty"`
	HasPartFailure *bool   `protobuf:"varint,4,opt,name=hasPartFailure" json:"hasPartFailure,omitempty"`
	// failCode:brokerId:host:port:topic:partitionId:delayTimeStamp
	FailureInfo []string `protobuf:"bytes,5,rep,name=failureInfo" json:"failureInfo,omitempty"`
	RequireAuth *bool    `protobuf:"varint,6,opt,name=requireAuth" json:"requireAuth,omitempty"`
}

func (x *HeartBeatResponseB2C) Reset() {
	*x = HeartBeatResponseB2C{}
	if protoimpl.UnsafeEnabled {
		mi := &file_BrokerService_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HeartBeatResponseB2C) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HeartBeatResponseB2C) ProtoMessage() {}

func (x *HeartBeatResponseB2C) ProtoReflect() protoreflect.Message {
	mi := &file_BrokerService_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HeartBeatResponseB2C.ProtoReflect.Descriptor instead.
func (*HeartBeatResponseB2C) Descriptor() ([]byte, []int) {
	return file_BrokerService_proto_rawDescGZIP(), []int{7}
}

func (x *HeartBeatResponseB2C) GetSuccess() bool {
	if x != nil && x.Success != nil {
		return *x.Success
	}
	return false
}

func (x *HeartBeatResponseB2C) GetErrCode() int32 {
	if x != nil && x.ErrCode != nil {
		return *x.ErrCode
	}
	return 0
}

func (x *HeartBeatResponseB2C) GetErrMsg() string {
	if x != nil && x.ErrMsg != nil {
		return *x.ErrMsg
	}
	return ""
}

func (x *HeartBeatResponseB2C) GetHasPartFailure() bool {
	if x != nil && x.HasPartFailure != nil {
		return *x.HasPartFailure
	}
	return false
}

func (x *HeartBeatResponseB2C) GetFailureInfo() []string {
	if x != nil {
		return x.FailureInfo
	}
	return nil
}

func (x *HeartBeatResponseB2C) GetRequireAuth() bool {
	if x != nil && x.RequireAuth != nil {
		return *x.RequireAuth
	}
	return false
}

type GetMessageRequestC2B struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ClientId           *string `protobuf:"bytes,1,req,name=clientId" json:"clientId,omitempty"`
	PartitionId        *int32  `protobuf:"varint,2,req,name=partitionId" json:"partitionId,omitempty"`
	GroupName          *string `protobuf:"bytes,3,req,name=groupName" json:"groupName,omitempty"`
	TopicName          *string `protobuf:"bytes,4,req,name=topicName" json:"topicName,omitempty"`
	LastPackConsumed   *bool   `protobuf:"varint,5,opt,name=lastPackConsumed" json:"lastPackConsumed,omitempty"`
	ManualCommitOffset *bool   `protobuf:"varint,6,opt,name=manualCommitOffset" json:"manualCommitOffset,omitempty"`
	EscFlowCtrl        *bool   `protobuf:"varint,7,opt,name=escFlowCtrl" json:"escFlowCtrl,omitempty"`
}

func (x *GetMessageRequestC2B) Reset() {
	*x = GetMessageRequestC2B{}
	if protoimpl.UnsafeEnabled {
		mi := &file_BrokerService_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetMessageRequestC2B) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMessageRequestC2B) ProtoMessage() {}

func (x *GetMessageRequestC2B) ProtoReflect() protoreflect.Message {
	mi := &file_BrokerService_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMessageRequestC2B.ProtoReflect.Descriptor instead.
func (*GetMessageRequestC2B) Descriptor() ([]byte, []int) {
	return file_BrokerService_proto_rawDescGZIP(), []int{8}
}

func (x *GetMessageRequestC2B) GetClientId() string {
	if x != nil && x.ClientId != nil {
		return *x.ClientId
	}
	return ""
}

func (x *GetMessageRequestC2B) GetPartitionId() int32 {
	if x != nil && x.PartitionId != nil {
		return *x.PartitionId
	}
	return 0
}

func (x *GetMessageRequestC2B) GetGroupName() string {
	if x != nil && x.GroupName != nil {
		return *x.GroupName
	}
	return ""
}

func (x *GetMessageRequestC2B) GetTopicName() string {
	if x != nil && x.TopicName != nil {
		return *x.TopicName
	}
	return ""
}

func (x *GetMessageRequestC2B) GetLastPackConsumed() bool {
	if x != nil && x.LastPackConsumed != nil {
		return *x.LastPackConsumed
	}
	return false
}

func (x *GetMessageRequestC2B) GetManualCommitOffset() bool {
	if x != nil && x.ManualCommitOffset != nil {
		return *x.ManualCommitOffset
	}
	return false
}

func (x *GetMessageRequestC2B) GetEscFlowCtrl() bool {
	if x != nil && x.EscFlowCtrl != nil {
		return *x.EscFlowCtrl
	}
	return false
}

type GetMessageResponseB2C struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Success      *bool                `protobuf:"varint,1,req,name=success" json:"success,omitempty"`
	ErrCode      *int32               `protobuf:"varint,2,req,name=errCode" json:"errCode,omitempty"`
	ErrMsg       *string              `protobuf:"bytes,3,opt,name=errMsg" json:"errMsg,omitempty"`
	Messages     []*TransferedMessage `protobuf:"bytes,4,rep,name=messages" json:"messages,omitempty"`
	CurrOffset   *int64               `protobuf:"varint,5,opt,name=currOffset" json:"currOffset,omitempty"`
	MinLimitTime *int32               `protobuf:"varint,6,opt,name=minLimitTime" json:"minLimitTime,omitempty"`
	EscFlowCtrl  *bool                `protobuf:"varint,7,opt,name=escFlowCtrl" json:"escFlowCtrl,omitempty"`
	CurrDataDlt  *int64               `protobuf:"varint,8,opt,name=currDataDlt" json:"currDataDlt,omitempty"`
	RequireSlow  *bool                `protobuf:"varint,9,opt,name=requireSlow" json:"requireSlow,omitempty"`
	MaxOffset    *int64               `protobuf:"varint,10,opt,name=maxOffset" json:"maxOffset,omitempty"`
}

func (x *GetMessageResponseB2C) Reset() {
	*x = GetMessageResponseB2C{}
	if protoimpl.UnsafeEnabled {
		mi := &file_BrokerService_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetMessageResponseB2C) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMessageResponseB2C) ProtoMessage() {}

func (x *GetMessageResponseB2C) ProtoReflect() protoreflect.Message {
	mi := &file_BrokerService_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMessageResponseB2C.ProtoReflect.Descriptor instead.
func (*GetMessageResponseB2C) Descriptor() ([]byte, []int) {
	return file_BrokerService_proto_rawDescGZIP(), []int{9}
}

func (x *GetMessageResponseB2C) GetSuccess() bool {
	if x != nil && x.Success != nil {
		return *x.Success
	}
	return false
}

func (x *GetMessageResponseB2C) GetErrCode() int32 {
	if x != nil && x.ErrCode != nil {
		return *x.ErrCode
	}
	return 0
}

func (x *GetMessageResponseB2C) GetErrMsg() string {
	if x != nil && x.ErrMsg != nil {
		return *x.ErrMsg
	}
	return ""
}

func (x *GetMessageResponseB2C) GetMessages() []*TransferedMessage {
	if x != nil {
		return x.Messages
	}
	return nil
}

func (x *GetMessageResponseB2C) GetCurrOffset() int64 {
	if x != nil && x.CurrOffset != nil {
		return *x.CurrOffset
	}
	return 0
}

func (x *GetMessageResponseB2C) GetMinLimitTime() int32 {
	if x != nil && x.MinLimitTime != nil {
		return *x.MinLimitTime
	}
	return 0
}

func (x *GetMessageResponseB2C) GetEscFlowCtrl() bool {
	if x != nil && x.EscFlowCtrl != nil {
		return *x.EscFlowCtrl
	}
	return false
}

func (x *GetMessageResponseB2C) GetCurrDataDlt() int64 {
	if x != nil && x.CurrDataDlt != nil {
		return *x.CurrDataDlt
	}
	return 0
}

func (x *GetMessageResponseB2C) GetRequireSlow() bool {
	if x != nil && x.RequireSlow != nil {
		return *x.RequireSlow
	}
	return false
}

func (x *GetMessageResponseB2C) GetMaxOffset() int64 {
	if x != nil && x.MaxOffset != nil {
		return *x.MaxOffset
	}
	return 0
}

type CommitOffsetRequestC2B struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ClientId         *string `protobuf:"bytes,1,req,name=clientId" json:"clientId,omitempty"`
	TopicName        *string `protobuf:"bytes,2,req,name=topicName" json:"topicName,omitempty"`
	PartitionId      *int32  `protobuf:"varint,3,req,name=partitionId" json:"partitionId,omitempty"`
	GroupName        *string `protobuf:"bytes,4,req,name=groupName" json:"groupName,omitempty"`
	LastPackConsumed *bool   `protobuf:"varint,5,opt,name=lastPackConsumed" json:"lastPackConsumed,omitempty"`
}

func (x *CommitOffsetRequestC2B) Reset() {
	*x = CommitOffsetRequestC2B{}
	if protoimpl.UnsafeEnabled {
		mi := &file_BrokerService_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitOffsetRequestC2B) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitOffsetRequestC2B) ProtoMessage() {}

func (x *CommitOffsetRequestC2B) ProtoReflect() protoreflect.Message {
	mi := &file_BrokerService_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitOffsetRequestC2B.ProtoReflect.Descriptor instead.
func (*CommitOffsetRequestC2B) Descriptor() ([]byte, []int) {
	return file_BrokerService_proto_rawDescGZIP(), []int{10}
}

func (x *CommitOffsetRequestC2B) GetClientId() string {
	if x != nil && x.ClientId != nil {
		return *x.ClientId
	}
	return ""
}

func (x *CommitOffsetRequestC2B) GetTopicName() string {
	if x != nil && x.TopicName != nil {
		return *x.TopicName
	}
	return ""
}

func (x *CommitOffsetRequestC2B) GetPartitionId() int32 {
	if x != nil && x.PartitionId != nil {
		return *x.PartitionId
	}
	return 0
}

func (x *CommitOffsetRequestC2B) GetGroupName() string {
	if x != nil && x.GroupName != nil {
		return *x.GroupName
	}
	return ""
}

func (x *CommitOffsetRequestC2B) GetLastPackConsumed() bool {
	if x != nil && x.LastPackConsumed != nil {
		return *x.LastPackConsumed
	}
	return false
}

type CommitOffsetResponseB2C struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Success    *bool   `protobuf:"varint,1,req,name=success" json:"success,omitempty"`
	ErrCode    *int32  `protobuf:"varint,2,req,name=errCode" json:"errCode,omitempty"`
	ErrMsg     *string `protobuf:"bytes,3,req,name=errMsg" json:"errMsg,omitempty"`
	CurrOffset *int64  `protobuf:"varint,4,opt,name=currOffset" json:"currOffset,omitempty"`
	MaxOffset  *int64  `protobuf:"varint,5,opt,name=maxOffset" json:"maxOffset,omitempty"`
}

func (x *CommitOffsetResponseB2C) Reset() {
	*x = CommitOffsetResponseB2C{}
	if protoimpl.UnsafeEnabled {
		mi := &file_BrokerService_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitOffsetResponseB2C) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitOffsetResponseB2C) ProtoMessage() {}

func (x *CommitOffsetResponseB2C) ProtoReflect() protoreflect.Message {
	mi := &file_BrokerService_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitOffsetResponseB2C.ProtoReflect.Descriptor instead.
func (*CommitOffsetResponseB2C) Descriptor() ([]byte, []int) {
	return file_BrokerService_proto_rawDescGZIP(), []int{11}
}

func (x *CommitOffsetResponseB2C) GetSuccess() bool {
	if x != nil && x.Success != nil {
		return *x.Success
	}
	return false
}

func (x *CommitOffsetResponseB2C) GetErrCode() int32 {
	if x != nil && x.ErrCode != nil {
		return *x.ErrCode
	}
	return 0
}

func (x *CommitOffsetResponseB2C) GetErrMsg() string {
	if x != nil && x.ErrMsg != nil {
		return *x.ErrMsg
	}
	return ""
}

func (x *CommitOffsetResponseB2C) GetCurrOffset() int64 {
	if x != nil && x.CurrOffset != nil {
		return *x.CurrOffset
	}
	return 0
}

func (x *CommitOffsetResponseB2C) GetMaxOffset() int64 {
	if x != nil && x.MaxOffset != nil {
		return *x.MaxOffset
	}
	return 0
}

var File_BrokerService_proto protoreflect.FileDescriptor

var file_BrokerService_proto_rawDesc = []byte{
	0x0a, 0x13, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x83, 0x01, 0x0a, 0x11, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x65, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x03, 0x52, 0x09,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x68, 0x65,
	0x63, 0x6b, 0x53, 0x75, 0x6d, 0x18, 0x02, 0x20, 0x02, 0x28, 0x05, 0x52, 0x08, 0x63, 0x68, 0x65,
	0x63, 0x6b, 0x53, 0x75, 0x6d, 0x12, 0x20, 0x0a, 0x0b, 0x70, 0x61, 0x79, 0x4c, 0x6f, 0x61, 0x64,
	0x44, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x02, 0x28, 0x0c, 0x52, 0x0b, 0x70, 0x61, 0x79, 0x4c,
	0x6f, 0x61, 0x64, 0x44, 0x61, 0x74, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x6c, 0x61, 0x67, 0x18,
	0x04, 0x20, 0x02, 0x28, 0x05, 0x52, 0x04, 0x66, 0x6c, 0x61, 0x67, 0x22, 0x76, 0x0a, 0x0e, 0x41,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x32, 0x0a,
	0x14, 0x76, 0x69, 0x73, 0x69, 0x74, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x02, 0x28, 0x03, 0x52, 0x14, 0x76, 0x69, 0x73,
	0x69, 0x74, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x30, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x68, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x65, 0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13,
	0x61, 0x75, 0x74, 0x68, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0xb4, 0x02, 0x0a, 0x15, 0x53, 0x65, 0x6e, 0x64, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x32, 0x42, 0x12, 0x1a, 0x0a,
	0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52,
	0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x6f, 0x70,
	0x69, 0x63, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x09, 0x74, 0x6f,
	0x70, 0x69, 0x63, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x18, 0x03, 0x20, 0x02, 0x28, 0x05, 0x52, 0x0b, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x04, 0x20, 0x02, 0x28, 0x0c, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x12, 0x12, 0x0a,
	0x04, 0x66, 0x6c, 0x61, 0x67, 0x18, 0x05, 0x20, 0x02, 0x28, 0x05, 0x52, 0x04, 0x66, 0x6c, 0x61,
	0x67, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x53, 0x75, 0x6d, 0x18, 0x06, 0x20,
	0x02, 0x28, 0x05, 0x52, 0x08, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x53, 0x75, 0x6d, 0x12, 0x1a, 0x0a,
	0x08, 0x73, 0x65, 0x6e, 0x74, 0x41, 0x64, 0x64, 0x72, 0x18, 0x07, 0x20, 0x02, 0x28, 0x05, 0x52,
	0x08, 0x73, 0x65, 0x6e, 0x74, 0x41, 0x64, 0x64, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x73, 0x67,
	0x54, 0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x73, 0x67, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x73, 0x67, 0x54, 0x69, 0x6d, 0x65, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x73, 0x67, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2b, 0x0a,
	0x08, 0x61, 0x75, 0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x0f, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f,
	0x52, 0x08, 0x61, 0x75, 0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0xe8, 0x01, 0x0a, 0x16, 0x53,
	0x65, 0x6e, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x42, 0x32, 0x50, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x18, 0x01, 0x20, 0x02, 0x28, 0x08, 0x52, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12,
	0x18, 0x0a, 0x07, 0x65, 0x72, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x05,
	0x52, 0x07, 0x65, 0x72, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x65, 0x72, 0x72,
	0x4d, 0x73, 0x67, 0x18, 0x03, 0x20, 0x02, 0x28, 0x09, 0x52, 0x06, 0x65, 0x72, 0x72, 0x4d, 0x73,
	0x67, 0x12, 0x20, 0x0a, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x41, 0x75, 0x74, 0x68,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x41,
	0x75, 0x74, 0x68, 0x12, 0x1c, 0x0a, 0x09, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49,
	0x64, 0x12, 0x1e, 0x0a, 0x0a, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x22, 0x0a, 0x0c, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x4f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x4f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x22, 0xc1, 0x03, 0x0a, 0x12, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x43, 0x32, 0x42, 0x12, 0x16, 0x0a, 0x06,
	0x6f, 0x70, 0x54, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x05, 0x52, 0x06, 0x6f, 0x70,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64,
	0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64,
	0x12, 0x1c, 0x0a, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x02, 0x28, 0x09, 0x52, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1c,
	0x0a, 0x09, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x02, 0x28,
	0x09, 0x52, 0x09, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x18, 0x05, 0x20, 0x02, 0x28,
	0x05, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1e,
	0x0a, 0x0a, 0x72, 0x65, 0x61, 0x64, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x06, 0x20, 0x02,
	0x28, 0x05, 0x52, 0x0a, 0x72, 0x65, 0x61, 0x64, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x24,
	0x0a, 0x0d, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x64, 0x53, 0x74, 0x72, 0x18,
	0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x64, 0x53, 0x74, 0x72, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x75, 0x72, 0x72, 0x4f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x63, 0x75, 0x72, 0x72, 0x4f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4b,
	0x65, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x4b, 0x65, 0x79, 0x12, 0x20, 0x0a, 0x0b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54,
	0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x73, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x73, 0x64, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x49, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x73, 0x73, 0x64, 0x53,
	0x74, 0x6f, 0x72, 0x65, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0d, 0x71, 0x72, 0x79, 0x50, 0x72, 0x69,
	0x6f, 0x72, 0x69, 0x74, 0x79, 0x49, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x71,
	0x72, 0x79, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x49, 0x64, 0x12, 0x2b, 0x0a, 0x08,
	0x61, 0x75, 0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f,
	0x2e, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x08, 0x61, 0x75, 0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0x9f, 0x01, 0x0a, 0x13, 0x52, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42, 0x32,
	0x43, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x02,
	0x28, 0x08, 0x52, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x65,
	0x72, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x05, 0x52, 0x07, 0x65, 0x72,
	0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x65, 0x72, 0x72, 0x4d, 0x73, 0x67, 0x18,
	0x03, 0x20, 0x02, 0x28, 0x09, 0x52, 0x06, 0x65, 0x72, 0x72, 0x4d, 0x73, 0x67, 0x12, 0x1e, 0x0a,
	0x0a, 0x63, 0x75, 0x72, 0x72, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x0a, 0x63, 0x75, 0x72, 0x72, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x1c, 0x0a,
	0x09, 0x6d, 0x61, 0x78, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x09, 0x6d, 0x61, 0x78, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x22, 0x88, 0x02, 0x0a, 0x13,
	0x48, 0x65, 0x61, 0x72, 0x74, 0x42, 0x65, 0x61, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x43, 0x32, 0x42, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x18,
	0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12,
	0x1c, 0x0a, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x02,
	0x28, 0x09, 0x52, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1e, 0x0a,
	0x0a, 0x72, 0x65, 0x61, 0x64, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x02, 0x28,
	0x05, 0x52, 0x0a, 0x72, 0x65, 0x61, 0x64, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x24, 0x0a,
	0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x73, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x49,
	0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x73, 0x73, 0x64, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0d, 0x71, 0x72, 0x79, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69,
	0x74, 0x79, 0x49, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x71, 0x72, 0x79, 0x50,
	0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x49, 0x64, 0x12, 0x2b, 0x0a, 0x08, 0x61, 0x75, 0x74,
	0x68, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x41, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08, 0x61, 0x75,
	0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0xce, 0x01, 0x0a, 0x14, 0x48, 0x65, 0x61, 0x72, 0x74,
	0x42, 0x65, 0x61, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42, 0x32, 0x43, 0x12,
	0x18, 0x0a, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x02, 0x28, 0x08,
	0x52, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x72, 0x72,
	0x43, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x05, 0x52, 0x07, 0x65, 0x72, 0x72, 0x43,
	0x6f, 0x64, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x65, 0x72, 0x72, 0x4d, 0x73, 0x67, 0x18, 0x03, 0x20,
	0x02, 0x28, 0x09, 0x52, 0x06, 0x65, 0x72, 0x72, 0x4d, 0x73, 0x67, 0x12, 0x26, 0x0a, 0x0e, 0x68,
	0x61, 0x73, 0x50, 0x61, 0x72, 0x74, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0e, 0x68, 0x61, 0x73, 0x50, 0x61, 0x72, 0x74, 0x46, 0x61, 0x69, 0x6c,
	0x75, 0x72, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x20, 0x0a, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65,
	0x41, 0x75, 0x74, 0x68, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x72, 0x65, 0x71, 0x75,
	0x69, 0x72, 0x65, 0x41, 0x75, 0x74, 0x68, 0x22, 0x8e, 0x02, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x43, 0x32, 0x42,
	0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x18, 0x01, 0x20, 0x02,
	0x28, 0x09, 0x52, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x20, 0x0a, 0x0b,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x18, 0x02, 0x20, 0x02, 0x28,
	0x05, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1c,
	0x0a, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x02, 0x28,
	0x09, 0x52, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09,
	0x74, 0x6f, 0x70, 0x69, 0x63, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x02, 0x28, 0x09, 0x52,
	0x09, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x10, 0x6c, 0x61,
	0x73, 0x74, 0x50, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x64, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x6c, 0x61, 0x73, 0x74, 0x50, 0x61, 0x63, 0x6b, 0x43, 0x6f,
	0x6e, 0x73, 0x75, 0x6d, 0x65, 0x64, 0x12, 0x2e, 0x0a, 0x12, 0x6d, 0x61, 0x6e, 0x75, 0x61, 0x6c,
	0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x12, 0x6d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x20, 0x0a, 0x0b, 0x65, 0x73, 0x63, 0x46, 0x6c, 0x6f,
	0x77, 0x43, 0x74, 0x72, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x65, 0x73, 0x63,
	0x46, 0x6c, 0x6f, 0x77, 0x43, 0x74, 0x72, 0x6c, 0x22, 0xdb, 0x02, 0x0a, 0x15, 0x47, 0x65, 0x74,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42,
	0x32, 0x43, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20,
	0x02, 0x28, 0x08, 0x52, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x18, 0x0a, 0x07,
	0x65, 0x72, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x05, 0x52, 0x07, 0x65,
	0x72, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x65, 0x72, 0x72, 0x4d, 0x73, 0x67,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x65, 0x72, 0x72, 0x4d, 0x73, 0x67, 0x12, 0x2e,
	0x0a, 0x08, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x65, 0x64, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x52, 0x08, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x12, 0x1e,
	0x0a, 0x0a, 0x63, 0x75, 0x72, 0x72, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0a, 0x63, 0x75, 0x72, 0x72, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x22,
	0x0a, 0x0c, 0x6d, 0x69, 0x6e, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x6d, 0x69, 0x6e, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x65, 0x73, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x43, 0x74, 0x72,
	0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x65, 0x73, 0x63, 0x46, 0x6c, 0x6f, 0x77,
	0x43, 0x74, 0x72, 0x6c, 0x12, 0x20, 0x0a, 0x0b, 0x63, 0x75, 0x72, 0x72, 0x44, 0x61, 0x74, 0x61,
	0x44, 0x6c, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x63, 0x75, 0x72, 0x72, 0x44,
	0x61, 0x74, 0x61, 0x44, 0x6c, 0x74, 0x12, 0x20, 0x0a, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72,
	0x65, 0x53, 0x6c, 0x6f, 0x77, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x72, 0x65, 0x71,
	0x75, 0x69, 0x72, 0x65, 0x53, 0x6c, 0x6f, 0x77, 0x12, 0x1c, 0x0a, 0x09, 0x6d, 0x61, 0x78, 0x4f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x6d, 0x61, 0x78,
	0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x22, 0xbe, 0x01, 0x0a, 0x16, 0x43, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x43, 0x32,
	0x42, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x18, 0x01, 0x20,
	0x02, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x1c, 0x0a,
	0x09, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x09,
	0x52, 0x09, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x18, 0x03, 0x20, 0x02, 0x28, 0x05,
	0x52, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1c, 0x0a,
	0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x02, 0x28, 0x09,
	0x52, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x10, 0x6c,
	0x61, 0x73, 0x74, 0x50, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x64, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x6c, 0x61, 0x73, 0x74, 0x50, 0x61, 0x63, 0x6b, 0x43,
	0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x64, 0x22, 0xa3, 0x01, 0x0a, 0x17, 0x43, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x42, 0x32, 0x43, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x01,
	0x20, 0x02, 0x28, 0x08, 0x52, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x18, 0x0a,
	0x07, 0x65, 0x72, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x05, 0x52, 0x07,
	0x65, 0x72, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x65, 0x72, 0x72, 0x4d, 0x73,
	0x67, 0x18, 0x03, 0x20, 0x02, 0x28, 0x09, 0x52, 0x06, 0x65, 0x72, 0x72, 0x4d, 0x73, 0x67, 0x12,
	0x1e, 0x0a, 0x0a, 0x63, 0x75, 0x72, 0x72, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0a, 0x63, 0x75, 0x72, 0x72, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12,
	0x1c, 0x0a, 0x09, 0x6d, 0x61, 0x78, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x09, 0x6d, 0x61, 0x78, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x42, 0x57, 0x0a,
	0x34, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x69, 0x6e, 0x6c, 0x6f,
	0x6e, 0x67, 0x2e, 0x74, 0x75, 0x62, 0x65, 0x6d, 0x71, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x62, 0x61,
	0x73, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x65, 0x64, 0x42, 0x0c, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x42, 0x72, 0x6f,
	0x6b, 0x65, 0x72, 0x48, 0x01, 0x5a, 0x09, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2f,
	0x88, 0x01, 0x01, 0xa0, 0x01, 0x01,
}

var (
	file_BrokerService_proto_rawDescOnce sync.Once
	file_BrokerService_proto_rawDescData = file_BrokerService_proto_rawDesc
)

func file_BrokerService_proto_rawDescGZIP() []byte {
	file_BrokerService_proto_rawDescOnce.Do(func() {
		file_BrokerService_proto_rawDescData = protoimpl.X.CompressGZIP(file_BrokerService_proto_rawDescData)
	})
	return file_BrokerService_proto_rawDescData
}

var file_BrokerService_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_BrokerService_proto_goTypes = []interface{}{
	(*TransferedMessage)(nil),       // 0: TransferedMessage
	(*AuthorizedInfo)(nil),          // 1: AuthorizedInfo
	(*SendMessageRequestP2B)(nil),   // 2: SendMessageRequestP2B
	(*SendMessageResponseB2P)(nil),  // 3: SendMessageResponseB2P
	(*RegisterRequestC2B)(nil),      // 4: RegisterRequestC2B
	(*RegisterResponseB2C)(nil),     // 5: RegisterResponseB2C
	(*HeartBeatRequestC2B)(nil),     // 6: HeartBeatRequestC2B
	(*HeartBeatResponseB2C)(nil),    // 7: HeartBeatResponseB2C
	(*GetMessageRequestC2B)(nil),    // 8: GetMessageRequestC2B
	(*GetMessageResponseB2C)(nil),   // 9: GetMessageResponseB2C
	(*CommitOffsetRequestC2B)(nil),  // 10: CommitOffsetRequestC2B
	(*CommitOffsetResponseB2C)(nil), // 11: CommitOffsetResponseB2C
}
var file_BrokerService_proto_depIdxs = []int32{
	1, // 0: SendMessageRequestP2B.authInfo:type_name -> AuthorizedInfo
	1, // 1: RegisterRequestC2B.authInfo:type_name -> AuthorizedInfo
	1, // 2: HeartBeatRequestC2B.authInfo:type_name -> AuthorizedInfo
	0, // 3: GetMessageResponseB2C.messages:type_name -> TransferedMessage
	4, // [4:4] is the sub-list for method output_type
	4, // [4:4] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_BrokerService_proto_init() }
func file_BrokerService_proto_init() {
	if File_BrokerService_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_BrokerService_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferedMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_BrokerService_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthorizedInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_BrokerService_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SendMessageRequestP2B); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_BrokerService_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SendMessageResponseB2P); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_BrokerService_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegisterRequestC2B); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_BrokerService_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegisterResponseB2C); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_BrokerService_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HeartBeatRequestC2B); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_BrokerService_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HeartBeatResponseB2C); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_BrokerService_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetMessageRequestC2B); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_BrokerService_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetMessageResponseB2C); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_BrokerService_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommitOffsetRequestC2B); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_BrokerService_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommitOffsetResponseB2C); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_BrokerService_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_BrokerService_proto_goTypes,
		DependencyIndexes: file_BrokerService_proto_depIdxs,
		MessageInfos:      file_BrokerService_proto_msgTypes,
	}.Build()
	File_BrokerService_proto = out.File
	file_BrokerService_proto_rawDesc = nil
	file_BrokerService_proto_goTypes = nil
	file_BrokerService_proto_depIdxs = nil
}
