/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp3;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.mp3.ID3Tags;
import org.apache.tika.parser.mp3.ID3v22Handler;
import org.apache.tika.parser.mp3.ID3v2Frame;
import org.xml.sax.SAXException;

public class ID3v23Handler
implements ID3Tags {
    private String title;
    private String artist;
    private String album;
    private String year;
    private String composer;
    private String genre;
    private String trackNumber;
    private String albumArtist;
    private String disc;
    private String compilation;
    private List<ID3Tags.ID3Comment> comments = new ArrayList<ID3Tags.ID3Comment>();

    public ID3v23Handler(ID3v2Frame frame) throws IOException, SAXException, TikaException {
        RawV23TagIterator tags = new RawV23TagIterator(frame);
        while (tags.hasNext()) {
            ID3v2Frame.RawTag tag = tags.next();
            switch (tag.name) {
                case "TIT2": {
                    this.title = this.getTagString(tag.data, 0, tag.data.length);
                    break;
                }
                case "TPE1": {
                    this.artist = this.getTagString(tag.data, 0, tag.data.length);
                    break;
                }
                case "TPE2": {
                    this.albumArtist = this.getTagString(tag.data, 0, tag.data.length);
                    break;
                }
                case "TALB": {
                    this.album = this.getTagString(tag.data, 0, tag.data.length);
                    break;
                }
                case "TYER": {
                    this.year = this.getTagString(tag.data, 0, tag.data.length);
                    break;
                }
                case "TCOM": {
                    this.composer = this.getTagString(tag.data, 0, tag.data.length);
                    break;
                }
                case "COMM": {
                    this.comments.add(this.getComment(tag.data, 0, tag.data.length));
                    break;
                }
                case "TRCK": {
                    this.trackNumber = this.getTagString(tag.data, 0, tag.data.length);
                    break;
                }
                case "TPOS": {
                    this.disc = this.getTagString(tag.data, 0, tag.data.length);
                    break;
                }
                case "TCMP": {
                    this.compilation = this.getTagString(tag.data, 0, tag.data.length);
                    break;
                }
                case "TCON": {
                    this.genre = ID3v22Handler.extractGenre(this.getTagString(tag.data, 0, tag.data.length));
                }
            }
        }
    }

    private String getTagString(byte[] data, int offset, int length) {
        return ID3v2Frame.getTagString(data, offset, length);
    }

    private ID3Tags.ID3Comment getComment(byte[] data, int offset, int length) {
        return ID3v2Frame.getComment(data, offset, length);
    }

    @Override
    public boolean getTagsPresent() {
        return true;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getArtist() {
        return this.artist;
    }

    @Override
    public String getAlbum() {
        return this.album;
    }

    @Override
    public String getYear() {
        return this.year;
    }

    @Override
    public String getComposer() {
        return this.composer;
    }

    @Override
    public List<ID3Tags.ID3Comment> getComments() {
        return this.comments;
    }

    @Override
    public String getGenre() {
        return this.genre;
    }

    @Override
    public String getTrackNumber() {
        return this.trackNumber;
    }

    @Override
    public String getAlbumArtist() {
        return this.albumArtist;
    }

    @Override
    public String getDisc() {
        return this.disc;
    }

    @Override
    public String getCompilation() {
        return this.compilation;
    }

    private class RawV23TagIterator
    extends ID3v2Frame.RawTagIterator {
        private RawV23TagIterator(ID3v2Frame frame) {
            ID3v2Frame iD3v2Frame = frame;
            iD3v2Frame.getClass();
            super(iD3v2Frame, 4, 4, 1, 2);
        }
    }
}

