/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.shex.ShexException;
import org.apache.jena.shex.ShexStatus;
import org.apache.jena.shex.sys.ShexLib;
import org.apache.jena.shex.sys.SysShex;

public class ShexRecord {
    public final Node node;
    public final Triple pattern;
    public final Node shapeExprLabel;
    public final ShexStatus status;
    public final String reason;
    public final Node focus;

    public ShexRecord(Node node, Node shapeExprLabel) {
        this(node, null, shapeExprLabel);
    }

    public ShexRecord(Triple pattern, Node shapeExprLabel) {
        this(null, pattern, shapeExprLabel);
        if (!this.isSubjectFocus() && !this.isObjectFocus()) {
            throw new ShexException("Triple pattern must have either subject or object as FOCUS");
        }
        if (this.isSubjectFocus() && this.isObjectFocus()) {
            throw new ShexException("Triple pattern must one one of subject or object as FOCUS");
        }
    }

    private ShexRecord(Node node, Triple pattern, Node shapeExprLabel) {
        this(node, pattern, shapeExprLabel, null, null, null);
    }

    public ShexRecord(ShexRecord assoc, Node focusNode, ShexStatus status, String reason) {
        this(assoc.node, assoc.pattern, assoc.shapeExprLabel, focusNode, status, reason);
    }

    private ShexRecord(Node node, Triple pattern, Node shapeExprLabel, Node focusNode, ShexStatus status, String reason) {
        this.node = node;
        this.pattern = pattern;
        this.shapeExprLabel = shapeExprLabel;
        this.status = status;
        this.focus = focusNode;
        this.reason = reason;
    }

    public boolean isSubjectFocus() {
        return this.pattern != null && SysShex.focusNode.equals((Object)this.pattern.getSubject());
    }

    public boolean isObjectFocus() {
        return this.pattern != null && SysShex.focusNode.equals((Object)this.pattern.getObject());
    }

    public Triple asMatcher() {
        if (this.pattern == null) {
            return null;
        }
        return Triple.create((Node)this.n(this.pattern.getSubject()), (Node)this.n(this.pattern.getPredicate()), (Node)this.n(this.pattern.getObject()));
    }

    private Node n(Node node) {
        return node == null || node.isExt() ? Node.ANY : node;
    }

    public String toString() {
        StringBuilder sBuff = new StringBuilder();
        Object str = this.strTarget();
        if (this.focus != null) {
            str = (String)str + " " + ShexLib.displayStr(this.focus);
        }
        if (this.status != null) {
            str = (String)str + " " + String.valueOf((Object)this.status);
        }
        if (this.reason != null) {
            str = (String)str + " :: " + this.reason;
        }
        return str;
    }

    public String strTarget() {
        if (this.pattern != null) {
            return String.format("{ %s %s %s } @ %s", ShexRecord.str(this.pattern.getSubject()), ShexRecord.str(this.pattern.getPredicate()), ShexRecord.str(this.pattern.getObject()), ShexRecord.str(this.shapeExprLabel));
        }
        if (this.node != null) {
            return String.format("%s @ %s", ShexRecord.str(this.node), ShexRecord.str(this.shapeExprLabel));
        }
        return "ShexShapeAssociation/null";
    }

    private static String str(Node x) {
        if (x == null || x.equals((Object)Node.ANY)) {
            return "_";
        }
        if (x == SysShex.focusNode) {
            return "FOCUS";
        }
        if (x == SysShex.startNode) {
            return "START";
        }
        return ShexLib.displayStr(x);
    }
}

