/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store.nodetable;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.nodetable.NodeTable;

public class NodeTableOps {
    public static List<NodeId> bulkNodeToNodeIdImpl(NodeTable nt, List<Node> nodes, boolean withAllocation) {
        ArrayList<NodeId> nodeIds = new ArrayList<NodeId>(nodes.size());
        for (Node node : nodes) {
            NodeId nid = withAllocation ? nt.getAllocateNodeId(node) : nt.getNodeIdForNode(node);
            nodeIds.add(nid);
        }
        return nodeIds;
    }

    public static List<Node> bulkNodeIdToNodeImpl(NodeTable nt, List<NodeId> nodeIds) {
        ArrayList<Node> nodes = new ArrayList<Node>(nodeIds.size());
        for (NodeId nodeId : nodeIds) {
            Node n = nt.getNodeForNodeId(nodeId);
            nodes.add(n);
        }
        return nodes;
    }
}

