/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.swagger;

import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.bean.swagger.Items;
import org.apache.juneau.bean.swagger.SchemaInfo;
import org.apache.juneau.bean.swagger.Swagger;
import org.apache.juneau.bean.swagger.SwaggerElement;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.marshaller.Json5;

public class ParameterInfo
extends SwaggerElement {
    private static final String[] VALID_IN = new String[]{"query", "header", "path", "formData", "body"};
    private static final String[] VALID_TYPES = new String[]{"string", "number", "integer", "boolean", "array", "file"};
    private static final String[] VALID_COLLECTION_FORMATS = new String[]{"csv", "ssv", "tsv", "pipes", "multi"};
    private String name;
    private String in;
    private String description;
    private String type;
    private String format;
    private String pattern;
    private String collectionFormat;
    private Number maximum;
    private Number minimum;
    private Number multipleOf;
    private Integer maxLength;
    private Integer minLength;
    private Integer maxItems;
    private Integer minItems;
    private Boolean required;
    private Boolean allowEmptyValue;
    private Boolean exclusiveMaximum;
    private Boolean exclusiveMinimum;
    private Boolean uniqueItems;
    private SchemaInfo schema;
    private Items items;
    private Object default_;
    private Set<Object> enum_ = new LinkedHashSet<Object>();
    private Object example;
    private Map<String, String> examples;

    public ParameterInfo() {
    }

    public ParameterInfo(ParameterInfo copyFrom) {
        super(copyFrom);
        this.allowEmptyValue = copyFrom.allowEmptyValue;
        this.collectionFormat = copyFrom.collectionFormat;
        this.default_ = copyFrom.default_;
        this.description = copyFrom.description;
        if (Utils.nn(copyFrom.enum_)) {
            this.enum_.addAll(CollectionUtils.copyOf(copyFrom.enum_));
        }
        this.example = copyFrom.example;
        this.exclusiveMaximum = copyFrom.exclusiveMaximum;
        this.exclusiveMinimum = copyFrom.exclusiveMinimum;
        this.format = copyFrom.format;
        this.in = copyFrom.in;
        this.items = copyFrom.items == null ? null : copyFrom.items.copy();
        this.maximum = copyFrom.maximum;
        this.maxItems = copyFrom.maxItems;
        this.maxLength = copyFrom.maxLength;
        this.minimum = copyFrom.minimum;
        this.minItems = copyFrom.minItems;
        this.minLength = copyFrom.minLength;
        this.multipleOf = copyFrom.multipleOf;
        this.name = copyFrom.name;
        this.pattern = copyFrom.pattern;
        this.required = copyFrom.required;
        this.schema = copyFrom.schema == null ? null : copyFrom.schema.copy();
        this.type = copyFrom.type;
        this.uniqueItems = copyFrom.uniqueItems;
        this.examples = CollectionUtils.copyOf(copyFrom.examples);
    }

    public ParameterInfo addEnum(Object ... value) {
        if (Utils.nn(value)) {
            for (Object v : value) {
                if (!Utils.nn(v)) continue;
                this.enum_.add(v);
            }
        }
        return this;
    }

    public ParameterInfo copy() {
        return new ParameterInfo(this);
    }

    public ParameterInfo copyFrom(ParameterInfo p) {
        if (Utils.nn(p)) {
            if (Utils.nn(p.name)) {
                this.name = p.name;
            }
            if (Utils.nn(p.in)) {
                this.in = p.in;
            }
            if (Utils.nn(p.description)) {
                this.description = p.description;
            }
            if (Utils.nn(p.type)) {
                this.type = p.type;
            }
            if (Utils.nn(p.format)) {
                this.format = p.format;
            }
            if (Utils.nn(p.pattern)) {
                this.pattern = p.pattern;
            }
            if (Utils.nn(p.collectionFormat)) {
                this.collectionFormat = p.collectionFormat;
            }
            if (Utils.nn(p.maximum)) {
                this.maximum = p.maximum;
            }
            if (Utils.nn(p.minimum)) {
                this.minimum = p.minimum;
            }
            if (Utils.nn(p.multipleOf)) {
                this.multipleOf = p.multipleOf;
            }
            if (Utils.nn(p.maxLength)) {
                this.maxLength = p.maxLength;
            }
            if (Utils.nn(p.minLength)) {
                this.minLength = p.minLength;
            }
            if (Utils.nn(p.maxItems)) {
                this.maxItems = p.maxItems;
            }
            if (Utils.nn(p.minItems)) {
                this.minItems = p.minItems;
            }
            if (Utils.nn(p.required)) {
                this.required = p.required;
            }
            if (Utils.nn(p.allowEmptyValue)) {
                this.allowEmptyValue = p.allowEmptyValue;
            }
            if (Utils.nn(p.exclusiveMaximum)) {
                this.exclusiveMaximum = p.exclusiveMaximum;
            }
            if (Utils.nn(p.exclusiveMinimum)) {
                this.exclusiveMinimum = p.exclusiveMinimum;
            }
            if (Utils.nn(p.uniqueItems)) {
                this.uniqueItems = p.uniqueItems;
            }
            if (Utils.nn(p.schema)) {
                this.schema = p.schema;
            }
            if (Utils.nn(p.items)) {
                this.items = p.items;
            }
            if (Utils.nn(p.default_)) {
                this.default_ = p.default_;
            }
            if (Utils.nn(p.enum_)) {
                this.enum_ = p.enum_;
            }
            if (Utils.nn(p.example)) {
                this.example = p.example;
            }
            if (Utils.nn(p.examples)) {
                this.examples = p.examples;
            }
        }
        return this;
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "allowEmptyValue" -> ConverterUtils.toType(this.getAllowEmptyValue(), type);
            case "collectionFormat" -> ConverterUtils.toType(this.getCollectionFormat(), type);
            case "default" -> ConverterUtils.toType(this.getDefault(), type);
            case "description" -> ConverterUtils.toType(this.getDescription(), type);
            case "enum" -> ConverterUtils.toType(this.getEnum(), type);
            case "example" -> ConverterUtils.toType(this.getExample(), type);
            case "examples" -> ConverterUtils.toType(this.getExamples(), type);
            case "exclusiveMaximum" -> ConverterUtils.toType(this.getExclusiveMaximum(), type);
            case "exclusiveMinimum" -> ConverterUtils.toType(this.getExclusiveMinimum(), type);
            case "format" -> ConverterUtils.toType(this.getFormat(), type);
            case "in" -> ConverterUtils.toType(this.getIn(), type);
            case "items" -> ConverterUtils.toType(this.getItems(), type);
            case "maximum" -> ConverterUtils.toType(this.getMaximum(), type);
            case "maxItems" -> ConverterUtils.toType(this.getMaxItems(), type);
            case "maxLength" -> ConverterUtils.toType(this.getMaxLength(), type);
            case "minimum" -> ConverterUtils.toType(this.getMinimum(), type);
            case "minItems" -> ConverterUtils.toType(this.getMinItems(), type);
            case "minLength" -> ConverterUtils.toType(this.getMinLength(), type);
            case "multipleOf" -> ConverterUtils.toType(this.getMultipleOf(), type);
            case "name" -> ConverterUtils.toType(this.getName(), type);
            case "pattern" -> ConverterUtils.toType(this.getPattern(), type);
            case "required" -> ConverterUtils.toType(this.getRequired(), type);
            case "schema" -> ConverterUtils.toType(this.getSchema(), type);
            case "type" -> ConverterUtils.toType(this.getType(), type);
            case "uniqueItems" -> ConverterUtils.toType(this.getUniqueItems(), type);
            default -> super.get(property, type);
        };
    }

    public Boolean getAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    public String getCollectionFormat() {
        return this.collectionFormat;
    }

    public Object getDefault() {
        return this.default_;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<Object> getEnum() {
        return Utils.nullIfEmpty(this.enum_);
    }

    public Object getExample() {
        return this.example;
    }

    public Map<String, String> getExamples() {
        return this.examples;
    }

    public Boolean getExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public Boolean getExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public String getFormat() {
        return this.format;
    }

    public String getIn() {
        return this.in;
    }

    public Items getItems() {
        return this.items;
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public Number getMultipleOf() {
        return this.multipleOf;
    }

    public String getName() {
        return this.name;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public SchemaInfo getSchema() {
        return this.schema;
    }

    public String getType() {
        return this.type;
    }

    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setb(String.class).addIf(Utils.nn(this.allowEmptyValue), "allowEmptyValue").addIf(Utils.nn(this.collectionFormat), "collectionFormat").addIf(Utils.nn(this.default_), "default").addIf(Utils.nn(this.description), "description").addIf(Utils.ne(this.enum_), "enum").addIf(Utils.nn(this.example), "example").addIf(Utils.nn(this.examples), "examples").addIf(Utils.nn(this.exclusiveMaximum), "exclusiveMaximum").addIf(Utils.nn(this.exclusiveMinimum), "exclusiveMinimum").addIf(Utils.nn(this.format), "format").addIf(Utils.nn(this.in), "in").addIf(Utils.nn(this.items), "items").addIf(Utils.nn(this.maxItems), "maxItems").addIf(Utils.nn(this.maxLength), "maxLength").addIf(Utils.nn(this.maximum), "maximum").addIf(Utils.nn(this.minItems), "minItems").addIf(Utils.nn(this.minLength), "minLength").addIf(Utils.nn(this.minimum), "minimum").addIf(Utils.nn(this.multipleOf), "multipleOf").addIf(Utils.nn(this.name), "name").addIf(Utils.nn(this.pattern), "pattern").addIf(Utils.nn(this.required), "required").addIf(Utils.nn(this.schema), "schema").addIf(Utils.nn(this.type), "type").addIf(Utils.nn(this.uniqueItems), "uniqueItems").build();
        return new MultiSet<String>(s, super.keySet());
    }

    public ParameterInfo resolveRefs(Swagger swagger, Deque<String> refStack, int maxDepth) {
        if (Utils.nn(this.schema)) {
            this.schema = this.schema.resolveRefs(swagger, refStack, maxDepth);
        }
        if (Utils.nn(this.items)) {
            this.items = this.items.resolveRefs(swagger, refStack, maxDepth);
        }
        return this;
    }

    @Override
    public ParameterInfo set(String property, Object value) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "allowEmptyValue" -> this.setAllowEmptyValue(ConverterUtils.toBoolean(value));
            case "collectionFormat" -> this.setCollectionFormat(Utils.s(value));
            case "default" -> this.setDefault(value);
            case "description" -> this.setDescription(Utils.s(value));
            case "enum" -> this.setEnum(value);
            case "example" -> this.setExample(value);
            case "examples" -> this.setExamples(ConverterUtils.toType(value, Map.class));
            case "exclusiveMaximum" -> this.setExclusiveMaximum(ConverterUtils.toBoolean(value));
            case "exclusiveMinimum" -> this.setExclusiveMinimum(ConverterUtils.toBoolean(value));
            case "format" -> this.setFormat(Utils.s(value));
            case "in" -> this.setIn(Utils.s(value));
            case "items" -> this.setItems(ConverterUtils.toType(value, Items.class));
            case "maximum" -> this.setMaximum(ConverterUtils.toNumber(value));
            case "maxItems" -> this.setMaxItems(ConverterUtils.toInteger(value));
            case "maxLength" -> this.setMaxLength(ConverterUtils.toInteger(value));
            case "minimum" -> this.setMinimum(ConverterUtils.toNumber(value));
            case "minItems" -> this.setMinItems(ConverterUtils.toInteger(value));
            case "minLength" -> this.setMinLength(ConverterUtils.toInteger(value));
            case "multipleOf" -> this.setMultipleOf(ConverterUtils.toNumber(value));
            case "name" -> this.setName(Utils.s(value));
            case "pattern" -> this.setPattern(Utils.s(value));
            case "required" -> this.setRequired(ConverterUtils.toBoolean(value));
            case "schema" -> this.setSchema(ConverterUtils.toType(value, SchemaInfo.class));
            case "type" -> this.setType(Utils.s(value));
            case "uniqueItems" -> this.setUniqueItems(ConverterUtils.toBoolean(value));
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public ParameterInfo setAllowEmptyValue(Boolean value) {
        this.allowEmptyValue = value;
        return this;
    }

    public ParameterInfo setCollectionFormat(String value) {
        if (this.isStrict() && !CollectionUtils.contains(value, VALID_COLLECTION_FORMATS)) {
            throw ThrowableUtils.rex("Invalid value passed in to setCollectionFormat(String).  Value=''{0}'', valid values={1}", value, Json5.of(VALID_COLLECTION_FORMATS));
        }
        this.collectionFormat = value;
        return this;
    }

    public ParameterInfo setDefault(Object value) {
        this.default_ = value;
        return this;
    }

    public ParameterInfo setDescription(String value) {
        this.description = value;
        return this;
    }

    public ParameterInfo setEnum(Collection<Object> value) {
        this.enum_.clear();
        if (Utils.nn(value)) {
            this.enum_.addAll(value);
        }
        return this;
    }

    public ParameterInfo setEnum(Object ... value) {
        this.setEnum(CollectionUtils.setb(Object.class).sparse().addAny(value).build());
        return this;
    }

    public ParameterInfo setExample(Object value) {
        this.example = value;
        return this;
    }

    public ParameterInfo setExamples(Map<String, String> value) {
        this.examples = value;
        return this;
    }

    public ParameterInfo setExclusiveMaximum(Boolean value) {
        this.exclusiveMaximum = value;
        return this;
    }

    public ParameterInfo setExclusiveMinimum(Boolean value) {
        this.exclusiveMinimum = value;
        return this;
    }

    public ParameterInfo setFormat(String value) {
        this.format = value;
        return this;
    }

    public ParameterInfo setIn(String value) {
        if (this.isStrict() && !CollectionUtils.contains(value, VALID_IN)) {
            throw ThrowableUtils.rex("Invalid value passed in to setIn(String).  Value=''{0}'', valid values={1}", value, Json5.of(VALID_IN));
        }
        this.in = value;
        if ("path".equals(value)) {
            this.required = true;
        }
        return this;
    }

    public ParameterInfo setItems(Items value) {
        this.items = value;
        return this;
    }

    public ParameterInfo setMaximum(Number value) {
        this.maximum = value;
        return this;
    }

    public ParameterInfo setMaxItems(Integer value) {
        this.maxItems = value;
        return this;
    }

    public ParameterInfo setMaxLength(Integer value) {
        this.maxLength = value;
        return this;
    }

    public ParameterInfo setMinimum(Number value) {
        this.minimum = value;
        return this;
    }

    public ParameterInfo setMinItems(Integer value) {
        this.minItems = value;
        return this;
    }

    public ParameterInfo setMinLength(Integer value) {
        this.minLength = value;
        return this;
    }

    public ParameterInfo setMultipleOf(Number value) {
        this.multipleOf = value;
        return this;
    }

    public ParameterInfo setName(String value) {
        if (!"body".equals(this.in)) {
            this.name = value;
        }
        return this;
    }

    public ParameterInfo setPattern(String value) {
        this.pattern = value;
        return this;
    }

    public ParameterInfo setRequired(Boolean value) {
        this.required = value;
        return this;
    }

    public ParameterInfo setSchema(SchemaInfo value) {
        this.schema = value;
        return this;
    }

    public ParameterInfo setType(String value) {
        if (this.isStrict() && !CollectionUtils.contains(value, VALID_TYPES)) {
            throw ThrowableUtils.rex("Invalid value passed in to setType(String).  Value=''{0}'', valid values={1}", value, Json5.of(VALID_TYPES));
        }
        this.type = value;
        return this;
    }

    public ParameterInfo setUniqueItems(Boolean value) {
        this.uniqueItems = value;
        return this;
    }

    @Override
    public ParameterInfo strict() {
        super.strict();
        return this;
    }

    @Override
    public ParameterInfo strict(Object value) {
        super.strict(value);
        return this;
    }
}

