/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.reflect;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.juneau.commons.collections.Cache;
import org.apache.juneau.commons.reflect.Annotatable;
import org.apache.juneau.commons.reflect.AnnotatableType;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.utils.AnnotationUtils;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;

public class PackageInfo
implements Annotatable {
    private static final Cache<Package, PackageInfo> CACHE = Cache.of(Package.class, PackageInfo.class).build();
    private final Package inner;
    private final Supplier<List<AnnotationInfo<Annotation>>> annotations;

    public static PackageInfo of(Class<?> childClass) {
        return PackageInfo.of(childClass.getPackage());
    }

    public static PackageInfo of(ClassInfo childClass) {
        return childClass.getPackage();
    }

    public static PackageInfo of(Package inner) {
        return CACHE.get(inner, () -> new PackageInfo(inner));
    }

    protected PackageInfo(Package inner) {
        AssertionUtils.assertArgNotNull("inner", inner);
        this.inner = inner;
        this.annotations = Utils.mem(() -> Utils.opt(inner).map(pkg -> CollectionUtils.stream(pkg.getAnnotations()).flatMap(a -> AnnotationUtils.streamRepeated(a)).map(a -> AnnotationInfo.of(this, a)).toList()).orElse(CollectionUtils.liste()));
    }

    public boolean equals(Object obj) {
        if (obj instanceof PackageInfo) {
            PackageInfo obj2 = (PackageInfo)obj;
            return this.inner.equals(obj2.inner);
        }
        return this.inner.equals(obj);
    }

    @Override
    public AnnotatableType getAnnotatableType() {
        return AnnotatableType.PACKAGE_TYPE;
    }

    public List<AnnotationInfo<Annotation>> getAnnotations() {
        return this.annotations.get();
    }

    public <A extends Annotation> Stream<AnnotationInfo<A>> getAnnotations(Class<A> type) {
        return this.getAnnotations().stream().filter(ai -> type.isInstance(ai.inner())).map(ai -> ai);
    }

    public String getImplementationTitle() {
        return this.inner.getImplementationTitle();
    }

    public String getImplementationVendor() {
        return this.inner.getImplementationVendor();
    }

    public String getImplementationVersion() {
        return this.inner.getImplementationVersion();
    }

    @Override
    public String getLabel() {
        return this.getName();
    }

    public String getName() {
        return this.inner.getName();
    }

    public String getSpecificationTitle() {
        return this.inner.getSpecificationTitle();
    }

    public String getSpecificationVendor() {
        return this.inner.getSpecificationVendor();
    }

    public String getSpecificationVersion() {
        return this.inner.getSpecificationVersion();
    }

    public int hashCode() {
        return this.inner.hashCode();
    }

    public Package inner() {
        return this.inner;
    }

    public boolean isCompatibleWith(String desired) throws NumberFormatException {
        return this.inner.isCompatibleWith(desired);
    }

    public boolean isSealed() {
        return this.inner.isSealed();
    }

    public boolean isSealed(URL url) {
        return this.inner.isSealed(url);
    }

    public String toString() {
        return this.inner.toString();
    }
}

