/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.junit.bct;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.junit.bct.BasicBeanConverter;
import org.apache.juneau.junit.bct.BctConfiguration;
import org.apache.juneau.junit.bct.BeanConverter;
import org.apache.juneau.junit.bct.Listifier;

public class Listifiers {
    public static Listifier<Collection> collectionListifier() {
        return (bc, collection) -> {
            if (collection instanceof Set && !(collection instanceof SortedSet) && !(collection instanceof LinkedHashSet) && BctConfiguration.get("Bct.sortCollections", false).booleanValue()) {
                TreeSet<Object> collection2 = new TreeSet<Object>(Listifiers.flexibleComparator(bc));
                collection2.addAll((Collection<Object>)collection);
                collection = collection2;
            }
            return CollectionUtils.toList(collection);
        };
    }

    public static Listifier<Enumeration> enumerationListifier() {
        return (bc, enumeration) -> Collections.list(enumeration);
    }

    public static Listifier<Iterable> iterableListifier() {
        return (bc, iterable) -> StreamSupport.stream(iterable.spliterator(), false).toList();
    }

    public static Listifier<Iterator> iteratorListifier() {
        return (bc, iterator) -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false).toList();
    }

    public static Listifier<Map> mapListifier() {
        return (bc, map) -> {
            if (!(map instanceof SortedMap) && !(map instanceof LinkedHashMap) && BctConfiguration.get("Bct.sortMaps", false).booleanValue()) {
                TreeMap map2 = new TreeMap(Listifiers.flexibleComparator(bc));
                map2.putAll(map);
                map = map2;
            }
            return CollectionUtils.toList(map.entrySet());
        };
    }

    public static Listifier<Stream> streamListifier() {
        return (bc, stream) -> stream.toList();
    }

    private static Comparator<Object> flexibleComparator(BeanConverter converter) {
        BeanConverter conv = converter != null ? converter : BasicBeanConverter.DEFAULT;
        return (o1, o2) -> {
            int result = Utils.cmp(o1, o2);
            if (result != 0) {
                return result;
            }
            String s1 = conv.stringify(o1);
            String s2 = conv.stringify(o2);
            return Utils.cmp(s1, s2);
        };
    }

    private Listifiers() {
    }
}

