/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import org.apache.juneau.commons.annotation.AppliedAnnotationObject;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.rest.annotation.RestInject;

public class RestInjectAnnotation {
    public static final RestInject DEFAULT = RestInjectAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static String name(RestInject a) {
        if (a == null) {
            return "";
        }
        if (!a.name().isEmpty()) {
            return a.name();
        }
        return a.value();
    }

    public static class Builder
    extends AppliedAnnotationObject.BuilderM {
        private String[] description = new String[0];
        private String name;
        private String value;
        private String[] methodScope;

        protected Builder() {
            super(RestInject.class);
        }

        public RestInject build() {
            return new Object(this);
        }

        public Builder description(String ... value) {
            this.description = value;
            return this;
        }

        public Builder methodScope(String ... value) {
            this.methodScope = value;
            return this;
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public Builder on(String ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(Method ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(MethodInfo ... value) {
            super.on(value);
            return this;
        }
    }

    private static class Object
    extends AppliedAnnotationObject
    implements RestInject {
        private final String[] description;
        private final String name;
        private final String value;
        private final String[] methodScope;

        Object(Builder b) {
            super(b);
            this.description = CollectionUtils.copyOf(b.description);
            this.name = b.name;
            this.value = b.value;
            this.methodScope = b.methodScope;
        }

        @Override
        public String[] methodScope() {
            return this.methodScope;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public String[] description() {
            return this.description;
        }
    }

    @Documented
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public RestInject[] value();
    }
}

