/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.message.BasicRequestLine;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.MediaType;
import org.apache.juneau.StringRange;
import org.apache.juneau.StringRanges;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.UriResolver;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.bean.swagger.Operation;
import org.apache.juneau.bean.swagger.Swagger;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.IoUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.config.Config;
import org.apache.juneau.cp.Messages;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializerSession;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.bean.RequestBeanMeta;
import org.apache.juneau.httppart.bean.RequestBeanPropertyMeta;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestOpContext;
import org.apache.juneau.rest.RestSession;
import org.apache.juneau.rest.assertions.FluentRequestContentAssertion;
import org.apache.juneau.rest.assertions.FluentRequestFormParamAssertion;
import org.apache.juneau.rest.assertions.FluentRequestHeaderAssertion;
import org.apache.juneau.rest.assertions.FluentRequestLineAssertion;
import org.apache.juneau.rest.assertions.FluentRequestQueryParamAssertion;
import org.apache.juneau.rest.httppart.RequestAttribute;
import org.apache.juneau.rest.httppart.RequestAttributes;
import org.apache.juneau.rest.httppart.RequestContent;
import org.apache.juneau.rest.httppart.RequestFormParam;
import org.apache.juneau.rest.httppart.RequestFormParams;
import org.apache.juneau.rest.httppart.RequestHeader;
import org.apache.juneau.rest.httppart.RequestHeaders;
import org.apache.juneau.rest.httppart.RequestPathParam;
import org.apache.juneau.rest.httppart.RequestPathParams;
import org.apache.juneau.rest.httppart.RequestQueryParam;
import org.apache.juneau.rest.httppart.RequestQueryParams;
import org.apache.juneau.rest.staticfile.StaticFiles;
import org.apache.juneau.rest.util.CachingHttpServletRequest;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.uon.UonParser;
import org.apache.juneau.uon.UonSerializer;

public class RestRequest
extends HttpServletRequestWrapper {
    private HttpServletRequest inner;
    private final RestContext context;
    private final RestOpContext opContext;
    private final RequestContent content;
    private final BeanSession beanSession;
    private final RequestQueryParams queryParams;
    private final RequestPathParams pathParams;
    private final RequestHeaders headers;
    private final RequestAttributes attrs;
    private final HttpPartParserSession partParserSession;
    private final RestSession session;
    private VarResolverSession varSession;
    private RequestFormParams formParams;
    private UriContext uriContext;
    private String authorityPath;
    private Config config;
    private Swagger swagger;
    private Charset charset;

    private static Locale toLocale(String lang) {
        String country = "";
        int i = lang.indexOf(45);
        if (i > -1) {
            country = lang.substring(i + 1).trim();
            lang = lang.substring(0, i).trim();
        }
        return new Locale(lang, country);
    }

    RestRequest(RestOpContext opContext, RestSession session) throws Exception {
        super(session.getRequest());
        String b;
        this.session = session;
        this.opContext = opContext;
        this.inner = session.getRequest();
        this.context = session.getContext();
        this.attrs = new RequestAttributes(this);
        this.queryParams = new RequestQueryParams(this, session.getQueryParams(), true);
        this.headers = new RequestHeaders(this, this.queryParams, false);
        this.content = new RequestContent(this);
        if (this.context.isAllowContentParam() && Utils.nn(b = (String)this.queryParams.get("content").asString().orElse(null))) {
            this.headers.set("Content-Type", UonSerializer.DEFAULT.getResponseContentType());
            this.content.mediaType(MediaType.UON).parser(UonParser.DEFAULT).content(b.getBytes(IoUtils.UTF8));
        }
        this.pathParams = new RequestPathParams(session, this, true);
        this.beanSession = opContext.getBeanContext().getSession();
        this.partParserSession = opContext.getPartParser().getPartSession();
        this.pathParams.parser(this.partParserSession);
        this.queryParams.addDefault(opContext.getDefaultRequestQueryData().getAll()).parser(this.partParserSession);
        this.headers.addDefault(opContext.getDefaultRequestHeaders().getAll()).addDefault(this.context.getDefaultRequestHeaders().getAll()).parser(this.partParserSession);
        this.content.encoders(opContext.getEncoders()).parsers(opContext.getParsers()).maxInput(opContext.getMaxInput());
        this.attrs.addDefault(opContext.getDefaultRequestAttributes()).addDefault(this.context.getDefaultRequestAttributes());
        if (this.isDebug()) {
            this.inner = CachingHttpServletRequest.wrap(this.inner);
        }
    }

    public FluentStringAssertion<RestRequest> assertCharset() {
        return new FluentStringAssertion<RestRequest>(this.getCharset().name(), this);
    }

    public FluentRequestContentAssertion<RestRequest> assertContent() {
        return new FluentRequestContentAssertion<RestRequest>(this.getContent(), this);
    }

    public FluentRequestFormParamAssertion<RestRequest> assertFormParam(String name) {
        return new FluentRequestFormParamAssertion<RestRequest>(this.getFormParam(name), this);
    }

    public FluentRequestHeaderAssertion<RestRequest> assertHeader(String name) {
        return new FluentRequestHeaderAssertion<RestRequest>(this.getHeaderParam(name), this);
    }

    public FluentRequestQueryParamAssertion<RestRequest> assertQueryParam(String name) {
        return new FluentRequestQueryParamAssertion<RestRequest>(this.getQueryParam(name), this);
    }

    public FluentRequestLineAssertion<RestRequest> assertRequestLine() {
        return new FluentRequestLineAssertion<RestRequest>(this.getRequestLine(), this);
    }

    public boolean containsFormParam(String name) {
        return this.getFormParams().contains(name);
    }

    public boolean containsHeader(String name) {
        return this.headers.contains(name);
    }

    public boolean containsQueryParam(String name) {
        return this.queryParams.contains(name);
    }

    public RequestAttribute getAttribute(String name) {
        return this.attrs.get(name);
    }

    public RequestAttributes getAttributes() {
        return this.attrs;
    }

    public String getAuthorityPath() {
        if (this.authorityPath == null) {
            this.authorityPath = this.context.getUriAuthority();
        }
        if (this.authorityPath == null) {
            String scheme = this.inner.getScheme();
            int port = this.inner.getServerPort();
            StringBuilder sb = new StringBuilder(this.inner.getScheme()).append("://").append(this.inner.getServerName());
            if (!(port == 80 && "http".equals(scheme) || port == 443 && "https".equals(scheme))) {
                sb.append(':').append(port);
            }
            this.authorityPath = sb.toString();
        }
        return this.authorityPath;
    }

    public BeanSession getBeanSession() {
        return this.beanSession;
    }

    public Charset getCharset() {
        if (this.charset == null) {
            int i;
            String h = this.getHeaderParam("Content-Type").orElse(null);
            if (Utils.nn(h) && (i = h.indexOf(";charset=")) > 0) {
                this.charset = Charset.forName(h.substring(i + 9).trim());
            }
            if (this.charset == null) {
                this.charset = this.opContext.getDefaultCharset();
            }
            if (this.charset == null) {
                this.charset = Charset.forName("UTF-8");
            }
        }
        return this.charset;
    }

    public Config getConfig() {
        if (this.config == null) {
            this.config = this.context.getConfig().resolving(this.getVarResolverSession());
        }
        return this.config;
    }

    public RequestContent getContent() {
        return this.content;
    }

    public RestContext getContext() {
        return this.context;
    }

    public String getContextPath() {
        String cp = this.context.getUriContext();
        return cp == null ? this.inner.getContextPath() : cp;
    }

    public <T> Optional<T> getFormParam(Class<T> type) {
        return this.getFormParams().get(type);
    }

    public RequestFormParam getFormParam(String name) {
        return this.getFormParams().get(name);
    }

    public RequestFormParams getFormParams() throws InternalServerError {
        try {
            if (this.formParams == null) {
                this.formParams = new RequestFormParams(this, true).parser(this.partParserSession);
            }
            this.formParams.addDefault(this.opContext.getDefaultRequestFormData().getAll());
            return this.formParams;
        }
        catch (Exception e) {
            throw new InternalServerError(e);
        }
    }

    public <T> Optional<T> getHeader(Class<T> type) {
        return this.headers.get(type);
    }

    public RequestHeader getHeaderParam(String name) {
        return this.headers.getLast(name);
    }

    public RequestHeaders getHeaders() {
        return this.headers;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.inner;
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.getContent().getInputStream();
    }

    public Locale getLocale() {
        Locale best = this.inner.getLocale();
        String h = this.headers.get("Accept-Language").asString().orElse(null);
        if (Utils.nn(h)) {
            StringRanges sr = StringRanges.of(h);
            float qValue = 0.0f;
            for (StringRange r : sr.toList()) {
                if (!(r.getQValue().floatValue() > qValue)) continue;
                best = RestRequest.toLocale(r.getName());
                qValue = r.getQValue().floatValue();
            }
        }
        return best;
    }

    public String getMessage(String key, Object ... args) {
        return this.getMessages().getString(key, args);
    }

    public Messages getMessages() {
        return this.context.getMessages().forLocale(this.getLocale());
    }

    public String getMethod() {
        return this.session.getMethod();
    }

    public RestOpContext getOpContext() {
        return this.opContext;
    }

    public Optional<Operation> getOperationSwagger() {
        Optional<Swagger> swagger = this.getSwagger();
        if (!swagger.isPresent()) {
            return Utils.opte();
        }
        return Utils.opt(swagger.get().getOperation(this.opContext.getPathPattern(), this.getMethod().toLowerCase()));
    }

    public HttpPartParserSession getPartParserSession() {
        return this.partParserSession;
    }

    public HttpPartSerializerSession getPartSerializerSession() {
        return this.opContext.getPartSerializer().getPartSession();
    }

    public <T> Optional<T> getPathParam(Class<T> type) {
        return this.pathParams.get(type);
    }

    public RequestPathParam getPathParam(String name) {
        return this.pathParams.get(name);
    }

    public RequestPathParams getPathParams() {
        return this.pathParams;
    }

    public RequestPathParam getPathRemainder() {
        return this.pathParams.getRemainder();
    }

    public ProtocolVersion getProtocolVersion() {
        return this.getRequestLine().getProtocolVersion();
    }

    public <T> Optional<T> getQueryParam(Class<T> type) {
        return this.queryParams.get(type);
    }

    public RequestQueryParam getQueryParam(String name) {
        return this.queryParams.get(name);
    }

    public RequestQueryParams getQueryParams() {
        return this.queryParams;
    }

    public BufferedReader getReader() throws IOException {
        return this.getContent().getReader();
    }

    public <T> T getRequest(Class<T> c) {
        return this.getRequest(RequestBeanMeta.create(c, this.getContext().getAnnotations()));
    }

    public <T> T getRequest(RequestBeanMeta rbm) {
        try {
            Class c = rbm.getClassMeta().inner();
            BeanSession bs = this.getBeanSession();
            BeanMeta bm = bs.getBeanMeta(c);
            return (T)Proxy.newProxyInstance(c.getClassLoader(), CollectionUtils.a(c), (proxy, method, args) -> {
                RequestBeanPropertyMeta pm = rbm.getProperty(method.getName());
                if (Utils.nn(pm)) {
                    HttpPartParserSession pp = pm.getParser(this.getPartParserSession());
                    HttpPartSchema schema = pm.getSchema();
                    String name = pm.getPartName();
                    ClassMeta type = bs.getClassMeta(method.getGenericReturnType(), new Type[0]);
                    HttpPartType pt = pm.getPartType();
                    if (pt == HttpPartType.BODY) {
                        return this.getContent().setSchema(schema).as(type, new Type[0]);
                    }
                    if (pt == HttpPartType.QUERY) {
                        return this.getQueryParam(name).parser(pp).schema(schema).as(type).orElse(null);
                    }
                    if (pt == HttpPartType.FORMDATA) {
                        return this.getFormParam(name).parser(pp).schema(schema).as(type).orElse(null);
                    }
                    if (pt == HttpPartType.HEADER) {
                        return this.getHeaderParam(name).parser(pp).schema(schema).as(type).orElse(null);
                    }
                    if (pt == HttpPartType.PATH) {
                        return this.getPathParam(name).parser(pp).schema(schema).as(type).orElse(null);
                    }
                }
                return null;
            });
        }
        catch (Exception e) {
            throw ThrowableUtils.toRex(e);
        }
    }

    public RequestLine getRequestLine() {
        String x = this.inner.getProtocol();
        int i = x.indexOf(47);
        int j = x.indexOf(46, i);
        ProtocolVersion pv = new ProtocolVersion(x.substring(0, i), StringUtils.parseInt(x.substring(i + 1, j)), StringUtils.parseInt(x.substring(j + 1)));
        return new BasicRequestLine(this.inner.getMethod(), this.inner.getRequestURI(), pv);
    }

    public String getServletPath() {
        String cp = this.context.getUriContext();
        String sp = this.inner.getServletPath();
        return cp == null || !sp.startsWith(cp) ? sp : sp.substring(cp.length());
    }

    public StaticFiles getStaticFiles() {
        return this.context.getStaticFiles();
    }

    public Optional<Swagger> getSwagger() {
        return this.context.getSwagger(this.getLocale());
    }

    public Optional<TimeZone> getTimeZone() {
        String tz = this.headers.get("Time-Zone").asString().orElse(null);
        if (Utils.nn(tz)) {
            return Utils.opt(TimeZone.getTimeZone(tz));
        }
        return Utils.opte();
    }

    public URI getUri(boolean includeQuery, Map<String, Object> addQueryParams) {
        String uri = this.inner.getRequestURI();
        if (includeQuery || Utils.nn(addQueryParams)) {
            StringBuilder sb = new StringBuilder(uri);
            RequestQueryParams rq = this.queryParams.copy();
            if (Utils.nn(addQueryParams)) {
                for (Map.Entry<String, Object> e : addQueryParams.entrySet()) {
                    rq.set(e.getKey(), e.getValue());
                }
            }
            if (!rq.isEmpty()) {
                sb.append('?').append(rq.asQueryString());
            }
            uri = sb.toString();
        }
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw ThrowableUtils.toRex(e);
        }
    }

    public UriContext getUriContext() {
        if (this.uriContext == null) {
            this.uriContext = UriContext.of(this.getAuthorityPath(), this.getContextPath(), this.getServletPath(), StringUtils.urlEncodePath(this.inner.getPathInfo()));
        }
        return this.uriContext;
    }

    public UriResolver getUriResolver() {
        return UriResolver.of(this.context.getUriResolution(), this.context.getUriRelativity(), this.getUriContext());
    }

    public UriResolver getUriResolver(UriResolution resolution, UriRelativity relativity) {
        return UriResolver.of(resolution, relativity, this.getUriContext());
    }

    public VarResolverSession getVarResolverSession() {
        if (this.varSession == null) {
            this.varSession = this.context.getVarResolver().createSession(this.session.getBeanStore()).bean(RestRequest.class, this).bean(RestSession.class, this.session);
        }
        return this.varSession;
    }

    public boolean isDebug() {
        return this.getAttribute("Debug").as(Boolean.class).orElse(false);
    }

    public boolean isPlainText() {
        return "true".equals(this.queryParams.get("plainText").asString().orElse("false"));
    }

    public void setAttribute(String name, Object value) {
        this.attrs.set(name, value);
    }

    public void setCharset(Charset value) {
        this.charset = value;
    }

    public RestRequest setDebug() throws IOException {
        return this.setDebug(true);
    }

    public RestRequest setDebug(Boolean b) throws IOException {
        this.setAttribute("Debug", b);
        if (b.booleanValue()) {
            this.inner = CachingHttpServletRequest.wrap(this.inner);
        }
        return this;
    }

    public RestRequest setException(Throwable t) {
        this.setAttribute("Exception", t);
        return this;
    }

    public RestRequest setNoTrace() {
        return this.setNoTrace(true);
    }

    public RestRequest setNoTrace(Boolean b) {
        this.setAttribute("NoTrace", b);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\n").append(this.getRequestLine()).append("\n");
        sb.append("---Headers---\n");
        this.getHeaders().forEach(x -> sb.append("\t").append(x).append("\n"));
        String m = this.getMethod();
        if (m.equals("PUT") || m.equals("POST")) {
            try {
                sb.append("---Content UTF-8---\n");
                sb.append(this.content.asString()).append("\n");
                sb.append("---Content Hex---\n");
                sb.append(this.content.asSpacedHex()).append("\n");
            }
            catch (Exception e1) {
                sb.append(ThrowableUtils.lm(e1));
            }
        }
        return sb.toString();
    }

    void close() {
        if (Utils.nn(this.config)) {
            this.config.close();
        }
    }
}

