/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import java.util.Set;
import java.util.regex.Pattern;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.TopologyConfig;
import org.apache.kafka.streams.TopologyDescription;
import org.apache.kafka.streams.internals.AutoOffsetResetInternal;
import org.apache.kafka.streams.processor.StreamPartitioner;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.processor.TopicNameExtractor;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.api.WrappedProcessorSupplier;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.StoreDelegatingProcessorSupplier;
import org.apache.kafka.streams.state.StoreBuilder;

public class Topology {
    protected final InternalTopologyBuilder internalTopologyBuilder;

    public Topology() {
        this(new InternalTopologyBuilder());
    }

    public Topology(TopologyConfig topologyConfigs) {
        this(new InternalTopologyBuilder(topologyConfigs));
    }

    protected Topology(InternalTopologyBuilder internalTopologyBuilder) {
        this.internalTopologyBuilder = internalTopologyBuilder;
    }

    @Deprecated
    private static AutoOffsetResetInternal convertOldToNew(AutoOffsetReset resetPolicy) {
        if (resetPolicy == null) {
            return null;
        }
        return new AutoOffsetResetInternal(resetPolicy == AutoOffsetReset.EARLIEST ? org.apache.kafka.streams.AutoOffsetReset.earliest() : org.apache.kafka.streams.AutoOffsetReset.latest());
    }

    public synchronized Topology addSource(String name, String ... topics) {
        this.internalTopologyBuilder.addSource(null, name, null, null, null, topics);
        return this;
    }

    public synchronized Topology addSource(String name, Pattern topicPattern) {
        this.internalTopologyBuilder.addSource(null, name, null, null, null, topicPattern);
        return this;
    }

    @Deprecated
    public synchronized Topology addSource(AutoOffsetReset offsetReset, String name, String ... topics) {
        this.internalTopologyBuilder.addSource(Topology.convertOldToNew(offsetReset), name, null, null, null, topics);
        return this;
    }

    public synchronized Topology addSource(org.apache.kafka.streams.AutoOffsetReset offsetReset, String name, String ... topics) {
        this.internalTopologyBuilder.addSource(offsetReset == null ? null : new AutoOffsetResetInternal(offsetReset), name, null, null, null, topics);
        return this;
    }

    @Deprecated
    public synchronized Topology addSource(AutoOffsetReset offsetReset, String name, Pattern topicPattern) {
        this.internalTopologyBuilder.addSource(Topology.convertOldToNew(offsetReset), name, null, null, null, topicPattern);
        return this;
    }

    public synchronized Topology addSource(org.apache.kafka.streams.AutoOffsetReset offsetReset, String name, Pattern topicPattern) {
        this.internalTopologyBuilder.addSource(offsetReset == null ? null : new AutoOffsetResetInternal(offsetReset), name, null, null, null, topicPattern);
        return this;
    }

    public synchronized Topology addSource(TimestampExtractor timestampExtractor, String name, String ... topics) {
        this.internalTopologyBuilder.addSource(null, name, timestampExtractor, null, null, topics);
        return this;
    }

    public synchronized Topology addSource(TimestampExtractor timestampExtractor, String name, Pattern topicPattern) {
        this.internalTopologyBuilder.addSource(null, name, timestampExtractor, null, null, topicPattern);
        return this;
    }

    @Deprecated
    public synchronized Topology addSource(AutoOffsetReset offsetReset, TimestampExtractor timestampExtractor, String name, String ... topics) {
        this.internalTopologyBuilder.addSource(Topology.convertOldToNew(offsetReset), name, timestampExtractor, null, null, topics);
        return this;
    }

    public synchronized Topology addSource(org.apache.kafka.streams.AutoOffsetReset offsetReset, TimestampExtractor timestampExtractor, String name, String ... topics) {
        this.internalTopologyBuilder.addSource(offsetReset == null ? null : new AutoOffsetResetInternal(offsetReset), name, timestampExtractor, null, null, topics);
        return this;
    }

    @Deprecated
    public synchronized Topology addSource(AutoOffsetReset offsetReset, TimestampExtractor timestampExtractor, String name, Pattern topicPattern) {
        this.internalTopologyBuilder.addSource(Topology.convertOldToNew(offsetReset), name, timestampExtractor, null, null, topicPattern);
        return this;
    }

    public synchronized Topology addSource(org.apache.kafka.streams.AutoOffsetReset offsetReset, TimestampExtractor timestampExtractor, String name, Pattern topicPattern) {
        this.internalTopologyBuilder.addSource(offsetReset == null ? null : new AutoOffsetResetInternal(offsetReset), name, timestampExtractor, null, null, topicPattern);
        return this;
    }

    public synchronized Topology addSource(String name, Deserializer<?> keyDeserializer, Deserializer<?> valueDeserializer, String ... topics) {
        this.internalTopologyBuilder.addSource(null, name, null, keyDeserializer, valueDeserializer, topics);
        return this;
    }

    public synchronized Topology addSource(String name, Deserializer<?> keyDeserializer, Deserializer<?> valueDeserializer, Pattern topicPattern) {
        this.internalTopologyBuilder.addSource(null, name, null, keyDeserializer, valueDeserializer, topicPattern);
        return this;
    }

    @Deprecated
    public synchronized Topology addSource(AutoOffsetReset offsetReset, String name, Deserializer<?> keyDeserializer, Deserializer<?> valueDeserializer, String ... topics) {
        this.internalTopologyBuilder.addSource(Topology.convertOldToNew(offsetReset), name, null, keyDeserializer, valueDeserializer, topics);
        return this;
    }

    public synchronized Topology addSource(org.apache.kafka.streams.AutoOffsetReset offsetReset, String name, Deserializer<?> keyDeserializer, Deserializer<?> valueDeserializer, String ... topics) {
        this.internalTopologyBuilder.addSource(offsetReset == null ? null : new AutoOffsetResetInternal(offsetReset), name, null, keyDeserializer, valueDeserializer, topics);
        return this;
    }

    @Deprecated
    public synchronized Topology addSource(AutoOffsetReset offsetReset, String name, Deserializer<?> keyDeserializer, Deserializer<?> valueDeserializer, Pattern topicPattern) {
        this.internalTopologyBuilder.addSource(Topology.convertOldToNew(offsetReset), name, null, keyDeserializer, valueDeserializer, topicPattern);
        return this;
    }

    public synchronized Topology addSource(org.apache.kafka.streams.AutoOffsetReset offsetReset, String name, Deserializer<?> keyDeserializer, Deserializer<?> valueDeserializer, Pattern topicPattern) {
        this.internalTopologyBuilder.addSource(offsetReset == null ? null : new AutoOffsetResetInternal(offsetReset), name, null, keyDeserializer, valueDeserializer, topicPattern);
        return this;
    }

    @Deprecated
    public synchronized Topology addSource(AutoOffsetReset offsetReset, String name, TimestampExtractor timestampExtractor, Deserializer<?> keyDeserializer, Deserializer<?> valueDeserializer, String ... topics) {
        this.internalTopologyBuilder.addSource(Topology.convertOldToNew(offsetReset), name, timestampExtractor, keyDeserializer, valueDeserializer, topics);
        return this;
    }

    public synchronized Topology addSource(org.apache.kafka.streams.AutoOffsetReset offsetReset, String name, TimestampExtractor timestampExtractor, Deserializer<?> keyDeserializer, Deserializer<?> valueDeserializer, String ... topics) {
        this.internalTopologyBuilder.addSource(offsetReset == null ? null : new AutoOffsetResetInternal(offsetReset), name, timestampExtractor, keyDeserializer, valueDeserializer, topics);
        return this;
    }

    @Deprecated
    public synchronized Topology addSource(AutoOffsetReset offsetReset, String name, TimestampExtractor timestampExtractor, Deserializer<?> keyDeserializer, Deserializer<?> valueDeserializer, Pattern topicPattern) {
        this.internalTopologyBuilder.addSource(Topology.convertOldToNew(offsetReset), name, timestampExtractor, keyDeserializer, valueDeserializer, topicPattern);
        return this;
    }

    public synchronized Topology addSource(org.apache.kafka.streams.AutoOffsetReset offsetReset, String name, TimestampExtractor timestampExtractor, Deserializer<?> keyDeserializer, Deserializer<?> valueDeserializer, Pattern topicPattern) {
        this.internalTopologyBuilder.addSource(offsetReset == null ? null : new AutoOffsetResetInternal(offsetReset), name, timestampExtractor, keyDeserializer, valueDeserializer, topicPattern);
        return this;
    }

    public synchronized Topology addSink(String name, String topic, String ... parentNames) {
        this.internalTopologyBuilder.addSink(name, topic, null, null, null, parentNames);
        return this;
    }

    public synchronized <K, V> Topology addSink(String name, String topic, StreamPartitioner<? super K, ? super V> partitioner, String ... parentNames) {
        this.internalTopologyBuilder.addSink(name, topic, null, null, partitioner, parentNames);
        return this;
    }

    public synchronized <K, V> Topology addSink(String name, String topic, Serializer<K> keySerializer, Serializer<V> valueSerializer, String ... parentNames) {
        this.internalTopologyBuilder.addSink(name, topic, keySerializer, valueSerializer, null, parentNames);
        return this;
    }

    public synchronized <K, V> Topology addSink(String name, String topic, Serializer<K> keySerializer, Serializer<V> valueSerializer, StreamPartitioner<? super K, ? super V> partitioner, String ... parentNames) {
        this.internalTopologyBuilder.addSink(name, topic, keySerializer, valueSerializer, partitioner, parentNames);
        return this;
    }

    public synchronized <K, V> Topology addSink(String name, TopicNameExtractor<K, V> topicExtractor, String ... parentNames) {
        this.internalTopologyBuilder.addSink(name, topicExtractor, null, null, null, parentNames);
        return this;
    }

    public synchronized <K, V> Topology addSink(String name, TopicNameExtractor<K, V> topicExtractor, StreamPartitioner<? super K, ? super V> partitioner, String ... parentNames) {
        this.internalTopologyBuilder.addSink(name, topicExtractor, null, null, partitioner, parentNames);
        return this;
    }

    public synchronized <K, V> Topology addSink(String name, TopicNameExtractor<K, V> topicExtractor, Serializer<K> keySerializer, Serializer<V> valueSerializer, String ... parentNames) {
        this.internalTopologyBuilder.addSink(name, topicExtractor, keySerializer, valueSerializer, null, parentNames);
        return this;
    }

    public synchronized <K, V> Topology addSink(String name, TopicNameExtractor<K, V> topicExtractor, Serializer<K> keySerializer, Serializer<V> valueSerializer, StreamPartitioner<? super K, ? super V> partitioner, String ... parentNames) {
        this.internalTopologyBuilder.addSink(name, topicExtractor, keySerializer, valueSerializer, partitioner, parentNames);
        return this;
    }

    public synchronized <KIn, VIn, KOut, VOut> Topology addProcessor(String name, ProcessorSupplier<KIn, VIn, KOut, VOut> supplier, String ... parentNames) {
        WrappedProcessorSupplier<KIn, VIn, KOut, VOut> wrapped = this.internalTopologyBuilder.wrapProcessorSupplier(name, supplier);
        this.internalTopologyBuilder.addProcessor(name, wrapped, parentNames);
        Set<StoreBuilder<?>> stores = wrapped.stores();
        if (stores != null) {
            for (StoreBuilder<?> storeBuilder : stores) {
                this.internalTopologyBuilder.addStateStore(storeBuilder, name);
            }
        }
        return this;
    }

    public synchronized Topology addStateStore(StoreBuilder<?> storeBuilder, String ... processorNames) {
        this.internalTopologyBuilder.addStateStore(storeBuilder, processorNames);
        return this;
    }

    public synchronized <KIn, VIn> Topology addReadOnlyStateStore(StoreBuilder<?> storeBuilder, String sourceName, TimestampExtractor timestampExtractor, Deserializer<KIn> keyDeserializer, Deserializer<VIn> valueDeserializer, String topic, String processorName, ProcessorSupplier<KIn, VIn, Void, Void> stateUpdateSupplier) {
        storeBuilder.withLoggingDisabled();
        this.internalTopologyBuilder.addSource(new AutoOffsetResetInternal(org.apache.kafka.streams.AutoOffsetReset.earliest()), sourceName, timestampExtractor, keyDeserializer, valueDeserializer, topic);
        this.internalTopologyBuilder.addProcessor(processorName, stateUpdateSupplier, sourceName);
        this.internalTopologyBuilder.addStateStore(storeBuilder, processorName);
        this.internalTopologyBuilder.connectSourceStoreAndTopic(storeBuilder.name(), topic);
        return this;
    }

    public synchronized <KIn, VIn> Topology addReadOnlyStateStore(StoreBuilder<?> storeBuilder, String sourceName, Deserializer<KIn> keyDeserializer, Deserializer<VIn> valueDeserializer, String topic, String processorName, ProcessorSupplier<KIn, VIn, Void, Void> stateUpdateSupplier) {
        return this.addReadOnlyStateStore(storeBuilder, sourceName, null, keyDeserializer, valueDeserializer, topic, processorName, stateUpdateSupplier);
    }

    public synchronized <KIn, VIn> Topology addGlobalStore(StoreBuilder<?> storeBuilder, String sourceName, Deserializer<KIn> keyDeserializer, Deserializer<VIn> valueDeserializer, String topic, String processorName, ProcessorSupplier<KIn, VIn, Void, Void> stateUpdateSupplier) {
        this.internalTopologyBuilder.addGlobalStore(sourceName, null, keyDeserializer, valueDeserializer, topic, processorName, new StoreDelegatingProcessorSupplier<KIn, VIn, Void, Void>(stateUpdateSupplier, Set.of(storeBuilder)), true);
        return this;
    }

    public synchronized <KIn, VIn> Topology addGlobalStore(StoreBuilder<?> storeBuilder, String sourceName, TimestampExtractor timestampExtractor, Deserializer<KIn> keyDeserializer, Deserializer<VIn> valueDeserializer, String topic, String processorName, ProcessorSupplier<KIn, VIn, Void, Void> stateUpdateSupplier) {
        this.internalTopologyBuilder.addGlobalStore(sourceName, timestampExtractor, keyDeserializer, valueDeserializer, topic, processorName, new StoreDelegatingProcessorSupplier<KIn, VIn, Void, Void>(stateUpdateSupplier, Set.of(storeBuilder)), true);
        return this;
    }

    public synchronized Topology connectProcessorAndStateStores(String processorName, String ... stateStoreNames) {
        this.internalTopologyBuilder.connectProcessorAndStateStores(processorName, stateStoreNames);
        return this;
    }

    public synchronized TopologyDescription describe() {
        return this.internalTopologyBuilder.describe();
    }

    @Deprecated
    public static enum AutoOffsetReset {
        EARLIEST,
        LATEST;

    }
}

