/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.network.Acceptor$DelayedCloseSocket$;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor;
import kafka.network.Processor$;
import kafka.network.RequestChannel;
import kafka.network.SocketServer;
import kafka.network.SocketServer$;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.network.ConnectionThrottledException;
import org.apache.kafka.network.TooManyConnectionsException;
import org.apache.kafka.security.CredentialProvider;
import org.apache.kafka.server.ApiVersionManager;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.network.ConnectionDisconnectListener;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.PriorityQueue;
import scala.jdk.CollectionConverters$;
import scala.math.Ordered;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0005\u0011%cA\u00020`\u0003\u0003\t7\r\u0003\u0005v\u0001\t\u0015\r\u0011\"\u0001x\u0011!a\bA!A!\u0002\u0013A\b\u0002C?\u0001\u0005\u000b\u0007I\u0011\u0001@\t\u0013\u0005U\u0001A!A!\u0002\u0013y\bBCA\f\u0001\t\u0005\r\u0011\"\u0001\u0002\u001a!Q\u0011q\u0005\u0001\u0003\u0002\u0004%\t!!\u000b\t\u0015\u0005m\u0002A!A!B\u0013\tY\u0002\u0003\u0006\u0002>\u0001\u0011\t\u0011)A\u0005\u0003\u007fA!\"!\u0012\u0001\u0005\u000b\u0007I\u0011AA$\u0011)\ty\u0005\u0001B\u0001B\u0003%\u0011\u0011\n\u0005\u000b\u0003#\u0002!\u0011!Q\u0001\n\u0005M\u0003BCA/\u0001\t\u0005\t\u0015!\u0003\u0002`!Q\u0011Q\r\u0001\u0003\u0002\u0003\u0006I!a\u001a\t\u0015\u00055\u0004A!A!\u0002\u0013\ty\u0007\u0003\u0006\u0002z\u0001\u0011\t\u0011)A\u0005\u0003wB!\"a\"\u0001\u0005\u0003\u0005\u000b\u0011BAE\u0011)\ty\t\u0001B\u0001B\u0003%\u0011\u0011\u0013\u0005\u000b\u0003;\u0003!\u0011!Q\u0001\n\u0005}\u0005bBAU\u0001\u0011\u0005\u00111\u0016\u0005\n\u0003\u0013\u0004!\u0019!C\u0001\u0003\u0017D\u0001\"!9\u0001A\u0003%\u0011Q\u001a\u0005\n\u0003G\u0004!\u0019!C\u0005\u0003KD\u0001\"!<\u0001A\u0003%\u0011q\u001d\u0005\n\u0003_\u0004!\u0019!C\u0005\u0003KD\u0001\"!=\u0001A\u0003%\u0011q\u001d\u0005\n\u0003g\u0004!\u0019!C\u0005\u0003KD\u0001\"!>\u0001A\u0003%\u0011q\u001d\u0005\n\u0003o\u0004!\u0019!C\u0005\u0003sD\u0001Ba\u0003\u0001A\u0003%\u00111 \u0005\r\u0005\u001b\u0001\u0001\u0019!a\u0001\n\u0003y&q\u0002\u0005\r\u0005/\u0001\u0001\u0019!a\u0001\n\u0003y&\u0011\u0004\u0005\f\u0005;\u0001\u0001\u0019!A!B\u0013\u0011\t\u0002\u0003\u0006\u0003 \u0001\u0011\r\u0011\"\u0001`\u0005CA\u0001Ba\t\u0001A\u0003%\u0011q\b\u0005\u000b\u0005K\u0001!\u0019!C\u0001?\n\u001d\u0002\u0002\u0003B \u0001\u0001\u0006IA!\u000b\t\u0013\t\u0005\u0003A1A\u0005\n\t\r\u0003\u0002\u0003B(\u0001\u0001\u0006IA!\u0012\t\u0013\tE\u0003A1A\u0005\n\tM\u0003\u0002\u0003B6\u0001\u0001\u0006IA!\u0016\t\u0013\t5\u0004A1A\u0005\n\t=\u0004\u0002\u0003B<\u0001\u0001\u0006IA!\u001d\t\u0013\te\u0004\u00011A\u0005\n\t\u0005\u0002\"\u0003B>\u0001\u0001\u0007I\u0011\u0002B?\u0011!\u0011\t\t\u0001Q!\n\u0005}\u0002B\u0003BB\u0001\t\u0007I\u0011A0\u0003\u0006\"A1\u0011\n\u0001!\u0002\u0013\u00119\tC\u0005\u0004L\u0001\u0011\r\u0011\"\u0003\u0002L\"A1Q\n\u0001!\u0002\u0013\ti\r\u0003\u0006\u0004P\u0001\u0011\r\u0011\"\u0001`\u0007#B\u0001b!\u0019\u0001A\u0003%11\u000b\u0005\n\u0007G\u0002!\u0019!C\u0001\u0007KB\u0001b!\u001c\u0001A\u0003%1q\r\u0005\b\u0007_\u0002A\u0011AB9\r\u001d\u0011\t\n\u0001!`\u0005'C!Ba08\u0005+\u0007I\u0011\u0001Ba\u0011)\u0011Im\u000eB\tB\u0003%!1\u0019\u0005\u000b\u0005\u0017<$Q3A\u0005\u0002\t5\u0007B\u0003Bko\tE\t\u0015!\u0003\u0003P\"9\u0011\u0011V\u001c\u0005\u0002\t]\u0007b\u0002Boo\u0011\u0005#q\u001c\u0005\n\u0005K<\u0014\u0011!C\u0001\u0005OD\u0011B!<8#\u0003%\tAa<\t\u0013\r\u0015q'%A\u0005\u0002\r\u001d\u0001\"CB\u0006o\u0005\u0005I\u0011IB\u0007\u0011%\u0019)bNA\u0001\n\u0003\u0011\t\u0003C\u0005\u0004\u0018]\n\t\u0011\"\u0001\u0004\u001a!I11E\u001c\u0002\u0002\u0013\u00053Q\u0005\u0005\n\u0007_9\u0014\u0011!C\u0001\u0007cA\u0011b!\u000e8\u0003\u0003%\tea\u000e\t\u0013\rmr'!A\u0005B\ru\u0002\"CB o\u0005\u0005I\u0011IB!\u0011%\u0019\u0019eNA\u0001\n\u0003\u001a)e\u0002\u0006\u0004t\u0001\t\t\u0011#\u0001`\u0007k2!B!%\u0001\u0003\u0003E\taXB<\u0011\u001d\tIk\u0013C\u0001\u0007\u001fC\u0011ba\u0010L\u0003\u0003%)e!\u0011\t\u0013\rE5*!A\u0005\u0002\u000eM\u0005\"CBM\u0017\u0006\u0005I\u0011QBN\u0011!\u0019i\u000b\u0001C\u0001?\u000e=\u0006bBB[\u0001\u0011\u00051\u0011\u000f\u0005\b\u0007o\u0003A\u0011AB9\u0011\u001d\u0019I\f\u0001C!\u0007cBqaa/\u0001\t\u0013\u0019\t\bC\u0004\u0004>\u0002!Iaa0\t\u000f\re\u0007\u0001\"\u0003\u0004r!911\u001c\u0001\u0005\n\ru\u0007bBBv\u0001\u0011E1Q\u001e\u0005\b\u0007g\u0004A\u0011BB9\u0011\u001d\u0019)\u0010\u0001C\u0005\u0007oDq\u0001b\u0001\u0001\t\u0003\u0019\t\bC\u0004\u0005\u0006\u0001!\t\u0001b\u0002\t\u000f\u00115\u0001\u0001\"\u0001\u0005\u0010\tA\u0011iY2faR|'O\u0003\u0002aC\u00069a.\u001a;x_J\\'\"\u00012\u0002\u000b-\fgm[1\u0014\t\u0001!Gn\u001c\t\u0003K*l\u0011A\u001a\u0006\u0003O\"\fA\u0001\\1oO*\t\u0011.\u0001\u0003kCZ\f\u0017BA6g\u0005\u0019y%M[3diB\u0011Q-\\\u0005\u0003]\u001a\u0014\u0001BU;o]\u0006\u0014G.\u001a\t\u0003aNl\u0011!\u001d\u0006\u0003e\u0006\fQ!\u001e;jYNL!\u0001^9\u0003\u000f1{wmZ5oO\u0006a1o\\2lKR\u001cVM\u001d<fe\u000e\u0001Q#\u0001=\u0011\u0005eTX\"A0\n\u0005m|&\u0001D*pG.,GoU3sm\u0016\u0014\u0018!D:pG.,GoU3sm\u0016\u0014\b%\u0001\u0005f]\u0012\u0004v.\u001b8u+\u0005y\b\u0003BA\u0001\u0003#i!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\u0007G>lWn\u001c8\u000b\u0007\t\fIA\u0003\u0003\u0002\f\u00055\u0011AB1qC\u000eDWM\u0003\u0002\u0002\u0010\u0005\u0019qN]4\n\t\u0005M\u00111\u0001\u0002\t\u000b:$\u0007o\\5oi\u0006IQM\u001c3Q_&tG\u000fI\u0001\u0007G>tg-[4\u0016\u0005\u0005m\u0001\u0003BA\u000f\u0003Gi!!a\b\u000b\u0007\u0005\u0005\u0012-\u0001\u0004tKJ4XM]\u0005\u0005\u0003K\tyBA\u0006LC\u001a\\\u0017mQ8oM&<\u0017AC2p]\u001aLwm\u0018\u0013fcR!\u00111FA\u001c!\u0011\ti#a\r\u000e\u0005\u0005=\"BAA\u0019\u0003\u0015\u00198-\u00197b\u0013\u0011\t)$a\f\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003s1\u0011\u0011!a\u0001\u00037\t1\u0001\u001f\u00132\u0003\u001d\u0019wN\u001c4jO\u0002\naA\\8eK&#\u0007\u0003BA\u0017\u0003\u0003JA!a\u0011\u00020\t\u0019\u0011J\u001c;\u0002!\r|gN\\3di&|g.U;pi\u0006\u001cXCAA%!\rI\u00181J\u0005\u0004\u0003\u001bz&\u0001E\"p]:,7\r^5p]F+x\u000e^1t\u0003E\u0019wN\u001c8fGRLwN\\)v_R\f7\u000fI\u0001\u0005i&lW\r\u0005\u0003\u0002V\u0005eSBAA,\u0015\r\u0011\u00181A\u0005\u0005\u00037\n9F\u0001\u0003US6,\u0017\u0001F5t!JLg/\u001b7fO\u0016$G*[:uK:,'\u000f\u0005\u0003\u0002.\u0005\u0005\u0014\u0002BA2\u0003_\u0011qAQ8pY\u0016\fg.\u0001\bsKF,Xm\u001d;DQ\u0006tg.\u001a7\u0011\u0007e\fI'C\u0002\u0002l}\u0013aBU3rk\u0016\u001cHo\u00115b]:,G.A\u0004nKR\u0014\u0018nY:\u0011\t\u0005E\u0014QO\u0007\u0003\u0003gRA!!\u001c\u0002\u0004%!\u0011qOA:\u0005\u001diU\r\u001e:jGN\f!c\u0019:fI\u0016tG/[1m!J|g/\u001b3feB!\u0011QPAB\u001b\t\tyH\u0003\u0003\u0002\u0002\u0006\u001d\u0011\u0001C:fGV\u0014\u0018\u000e^=\n\t\u0005\u0015\u0015q\u0010\u0002\u0013\u0007J,G-\u001a8uS\u0006d\u0007K]8wS\u0012,'/\u0001\u0006m_\u001e\u001cuN\u001c;fqR\u0004B!!\u0016\u0002\f&!\u0011QRA,\u0005)aunZ\"p]R,\u0007\u0010^\u0001\u000b[\u0016lwN]=Q_>d\u0007\u0003BAJ\u00033k!!!&\u000b\t\u0005]\u00151A\u0001\u0007[\u0016lwN]=\n\t\u0005m\u0015Q\u0013\u0002\u000b\u001b\u0016lwN]=Q_>d\u0017!E1qSZ+'o]5p]6\u000bg.Y4feB!\u0011\u0011UAS\u001b\t\t\u0019K\u0003\u0003\u0002\"\u0005\u001d\u0011\u0002BAT\u0003G\u0013\u0011#\u00119j-\u0016\u00148/[8o\u001b\u0006t\u0017mZ3s\u0003\u0019a\u0014N\\5u}Qa\u0012QVAX\u0003c\u000b\u0019,!.\u00028\u0006e\u00161XA_\u0003\u007f\u000b\t-a1\u0002F\u0006\u001d\u0007CA=\u0001\u0011\u0015)8\u00031\u0001y\u0011\u0015i8\u00031\u0001\u0000\u0011\u001d\t9b\u0005a\u0001\u00037Aq!!\u0010\u0014\u0001\u0004\ty\u0004C\u0004\u0002FM\u0001\r!!\u0013\t\u000f\u0005E3\u00031\u0001\u0002T!9\u0011QL\nA\u0002\u0005}\u0003bBA3'\u0001\u0007\u0011q\r\u0005\b\u0003[\u001a\u0002\u0019AA8\u0011\u001d\tIh\u0005a\u0001\u0003wBq!a\"\u0014\u0001\u0004\tI\tC\u0004\u0002\u0010N\u0001\r!!%\t\u000f\u0005u5\u00031\u0001\u0002 \u0006I1\u000f[8vY\u0012\u0014VO\\\u000b\u0003\u0003\u001b\u0004B!a4\u0002^6\u0011\u0011\u0011\u001b\u0006\u0005\u0003'\f).\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0003/\fI.\u0001\u0006d_:\u001cWO\u001d:f]RT1!a7i\u0003\u0011)H/\u001b7\n\t\u0005}\u0017\u0011\u001b\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002\u0015MDw.\u001e7e%Vt\u0007%\u0001\btK:$')\u001e4gKJ\u001c\u0016N_3\u0016\u0005\u0005\u001d\bcA3\u0002j&\u0019\u00111\u001e4\u0003\u000f%sG/Z4fe\u0006y1/\u001a8e\u0005V4g-\u001a:TSj,\u0007%\u0001\bsK\u000e4()\u001e4gKJ\u001c\u0016N_3\u0002\u001fI,7M\u001e\"vM\u001a,'oU5{K\u0002\n\u0011\u0003\\5ti\u0016t')Y2lY><7+\u001b>f\u0003Ia\u0017n\u001d;f]\n\u000b7m\u001b7pONK'0\u001a\u0011\u0002\u00179LwnU3mK\u000e$xN]\u000b\u0003\u0003w\u0004B!!@\u0003\b5\u0011\u0011q \u0006\u0005\u0005\u0003\u0011\u0019!\u0001\u0005dQ\u0006tg.\u001a7t\u0015\r\u0011)\u0001[\u0001\u0004]&|\u0017\u0002\u0002B\u0005\u0003\u007f\u0014\u0001bU3mK\u000e$xN]\u0001\r]&|7+\u001a7fGR|'\u000fI\u0001\u000eg\u0016\u0014h/\u001a:DQ\u0006tg.\u001a7\u0016\u0005\tE\u0001\u0003BA\u007f\u0005'IAA!\u0006\u0002\u0000\n\u00192+\u001a:wKJ\u001cvnY6fi\u000eC\u0017M\u001c8fY\u0006\t2/\u001a:wKJ\u001c\u0005.\u00198oK2|F%Z9\u0015\t\u0005-\"1\u0004\u0005\n\u0003sy\u0012\u0011!a\u0001\u0005#\tab]3sm\u0016\u00148\t[1o]\u0016d\u0007%A\u0005m_\u000e\fG\u000eU8siV\u0011\u0011qH\u0001\u000bY>\u001c\u0017\r\u001c)peR\u0004\u0013A\u00039s_\u000e,7o]8sgV\u0011!\u0011\u0006\t\u0007\u0005W\u0011)D!\u000f\u000e\u0005\t5\"\u0002\u0002B\u0018\u0005c\tq!\\;uC\ndWM\u0003\u0003\u00034\u0005=\u0012AC2pY2,7\r^5p]&!!q\u0007B\u0017\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0007e\u0014Y$C\u0002\u0003>}\u0013\u0011\u0002\u0015:pG\u0016\u001c8o\u001c:\u0002\u0017A\u0014xnY3tg>\u00148\u000fI\u0001!E\u0006\u001c7n^1sI\u000e{W\u000e]1uS\nLG.\u001b;z\u001b\u0016$(/[2He>,\b/\u0006\u0002\u0003FA!!q\tB&\u001b\t\u0011IE\u0003\u0003\u0002n\u0005\r\u0016\u0002\u0002B'\u0005\u0013\u0012\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0003\u0005\u0012\u0017mY6xCJ$7i\\7qCRL'-\u001b7jiflU\r\u001e:jG\u001e\u0013x.\u001e9!\u0003u\u0011Gn\\2lK\u0012\u0004VM]2f]RlU\r^3s\u001b\u0016$(/[2OC6,WC\u0001B+!\u0011\u00119Fa\u001a\u000e\u0005\te#\u0002\u0002B.\u0005;\nAaY8sK*!\u0011Q\u000eB0\u0015\u0011\u0011\tGa\u0019\u0002\re\fW.\\3s\u0015\t\u0011)'A\u0002d_6LAA!\u001b\u0003Z\tQQ*\u001a;sS\u000et\u0015-\\3\u0002=\tdwnY6fIB+'oY3oi6+G/\u001a:NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0013a\u00052m_\u000e\\W\r\u001a)fe\u000e,g\u000e^'fi\u0016\u0014XC\u0001B9!\u0011\u00119Fa\u001d\n\t\tU$\u0011\f\u0002\u0006\u001b\u0016$XM]\u0001\u0015E2|7m[3e!\u0016\u00148-\u001a8u\u001b\u0016$XM\u001d\u0011\u0002+\r,(O]3oiB\u0013xnY3tg>\u0014\u0018J\u001c3fq\u0006I2-\u001e:sK:$\bK]8dKN\u001cxN]%oI\u0016Dx\fJ3r)\u0011\tYCa \t\u0013\u0005eB&!AA\u0002\u0005}\u0012AF2veJ,g\u000e\u001e)s_\u000e,7o]8s\u0013:$W\r\u001f\u0011\u0002!QD'o\u001c;uY\u0016$7k\\2lKR\u001cXC\u0001BD!\u0019\u0011YC!#\u0003\u000e&!!1\u0012B\u0017\u00055\u0001&/[8sSRL\u0018+^3vKB\u0019!qR\u001c\u000e\u0003\u0001\u0011!\u0003R3mCf,Gm\u00117pg\u0016\u001cvnY6fiNIqG!&\u0003\u001c\nM&\u0011\u0018\t\u0005\u0003[\u00119*\u0003\u0003\u0003\u001a\u0006=\"AB!osJ+g\r\u0005\u0004\u0003\u001e\n5&Q\u0012\b\u0005\u0005?\u0013IK\u0004\u0003\u0003\"\n\u001dVB\u0001BR\u0015\r\u0011)K^\u0001\u0007yI|w\u000e\u001e \n\u0005\u0005E\u0012\u0002\u0002BV\u0003_\tq\u0001]1dW\u0006<W-\u0003\u0003\u00030\nE&aB(sI\u0016\u0014X\r\u001a\u0006\u0005\u0005W\u000by\u0003\u0005\u0003\u0002.\tU\u0016\u0002\u0002B\\\u0003_\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0003\u001e\nm\u0016\u0002\u0002B_\u0005c\u0013AbU3sS\u0006d\u0017N_1cY\u0016\faa]8dW\u0016$XC\u0001Bb!\u0011\tiP!2\n\t\t\u001d\u0017q \u0002\u000e'>\u001c7.\u001a;DQ\u0006tg.\u001a7\u0002\u000fM|7m[3uA\u0005\tRM\u001c3UQJ|G\u000f\u001e7f)&lW-T:\u0016\u0005\t=\u0007\u0003BA\u0017\u0005#LAAa5\u00020\t!Aj\u001c8h\u0003I)g\u000e\u001a+ie>$H\u000f\\3US6,Wj\u001d\u0011\u0015\r\t5%\u0011\u001cBn\u0011\u001d\u0011y\f\u0010a\u0001\u0005\u0007DqAa3=\u0001\u0004\u0011y-A\u0004d_6\u0004\u0018M]3\u0015\t\u0005}\"\u0011\u001d\u0005\b\u0005Gl\u0004\u0019\u0001BG\u0003\u0011!\b.\u0019;\u0002\t\r|\u0007/\u001f\u000b\u0007\u0005\u001b\u0013IOa;\t\u0013\t}f\b%AA\u0002\t\r\u0007\"\u0003Bf}A\u0005\t\u0019\u0001Bh\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"A!=+\t\t\r'1_\u0016\u0003\u0005k\u0004BAa>\u0004\u00025\u0011!\u0011 \u0006\u0005\u0005w\u0014i0A\u0005v]\u000eDWmY6fI*!!q`A\u0018\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007\u0007\u0011IPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0004\n)\"!q\u001aBz\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u00111q\u0002\t\u0004K\u000eE\u0011bAB\nM\n11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0004\u001c\r\u0005\u0002\u0003BA\u0017\u0007;IAaa\b\u00020\t\u0019\u0011I\\=\t\u0013\u0005e2)!AA\u0002\u0005}\u0012a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\r\u001d\u0002CBB\u0015\u0007W\u0019Y\"\u0004\u0002\u00032%!1Q\u0006B\u0019\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005}31\u0007\u0005\n\u0003s)\u0015\u0011!a\u0001\u00077\t!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!1qBB\u001d\u0011%\tIDRA\u0001\u0002\u0004\ty$\u0001\u0005iCND7i\u001c3f)\t\ty$\u0001\u0005u_N#(/\u001b8h)\t\u0019y!\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003?\u001a9\u0005C\u0005\u0002:%\u000b\t\u00111\u0001\u0004\u001c\u0005\tB\u000f\u001b:piRdW\rZ*pG.,Go\u001d\u0011\u0002\u000fM$\u0018M\u001d;fI\u0006A1\u000f^1si\u0016$\u0007%A\u0007ti\u0006\u0014H/\u001a3GkR,(/Z\u000b\u0003\u0007'\u0002ba!\u0016\u0004X\rmSBAAk\u0013\u0011\u0019I&!6\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\rE\u0002f\u0007;J1aa\u0018g\u0005\u00111v.\u001b3\u0002\u001dM$\u0018M\u001d;fI\u001a+H/\u001e:fA\u00051A\u000f\u001b:fC\u0012,\"aa\u001a\u0011\t\u0005U3\u0011N\u0005\u0005\u0007W\n9FA\u0006LC\u001a\\\u0017\r\u00165sK\u0006$\u0017a\u0002;ie\u0016\fG\rI\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u0003W\t!\u0003R3mCf,Gm\u00117pg\u0016\u001cvnY6fiB\u0019!qR&\u0014\u000b-\u001bIh!\"\u0011\u0015\rm4\u0011\u0011Bb\u0005\u001f\u0014i)\u0004\u0002\u0004~)!1qPA\u0018\u0003\u001d\u0011XO\u001c;j[\u0016LAaa!\u0004~\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\r\u001d5QR\u0007\u0003\u0007\u0013S1aa#i\u0003\tIw.\u0003\u0003\u0003>\u000e%ECAB;\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\u0011ii!&\u0004\u0018\"9!q\u0018(A\u0002\t\r\u0007b\u0002Bf\u001d\u0002\u0007!qZ\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019ij!+\u0011\r\u000552qTBR\u0013\u0011\u0019\t+a\f\u0003\r=\u0003H/[8o!!\tic!*\u0003D\n=\u0017\u0002BBT\u0003_\u0011a\u0001V;qY\u0016\u0014\u0004\"CBV\u001f\u0006\u0005\t\u0019\u0001BG\u0003\rAH\u0005M\u0001\u0011e\u0016lwN^3Qe>\u001cWm]:peN$B!a\u000b\u00042\"911\u0017)A\u0002\u0005}\u0012a\u0003:f[>4XmQ8v]R\fQBY3hS:\u001c\u0006.\u001e;e_^t\u0017!B2m_N,\u0017a\u0001:v]\u0006A1\r\\8tK\u0006cG.\u0001\tpa\u0016t7+\u001a:wKJ\u001cvnY6fiRA!\u0011CBa\u0007'\u001c9\u000eC\u0004\u0004DV\u0003\ra!2\u0002\t!|7\u000f\u001e\t\u0005\u0007\u000f\u001cyM\u0004\u0003\u0004J\u000e-\u0007\u0003\u0002BQ\u0003_IAa!4\u00020\u00051\u0001K]3eK\u001aLAaa\u0005\u0004R*!1QZA\u0018\u0011\u001d\u0019).\u0016a\u0001\u0003\u007f\tA\u0001]8si\"9\u00111_+A\u0002\u0005}\u0012\u0001F1dG\u0016\u0004HOT3x\u0007>tg.Z2uS>t7/\u0001\u0004bG\u000e,\u0007\u000f\u001e\u000b\u0005\u0007?\u001c\t\u000f\u0005\u0004\u0002.\r}%1\u0019\u0005\b\u0007G<\u0006\u0019ABs\u0003\rYW-\u001f\t\u0005\u0003{\u001c9/\u0003\u0003\u0004j\u0006}(\u0001D*fY\u0016\u001cG/[8o\u0017\u0016L\u0018AH2p]\u001aLw-\u001e:f\u0003\u000e\u001cW\r\u001d;fIN{7m[3u\u0007\"\fgN\\3m)\u0011\tYca<\t\u000f\rE\b\f1\u0001\u0003D\u0006i1o\\2lKR\u001c\u0005.\u00198oK2\f\u0011d\u00197pg\u0016$\u0006N]8ui2,GmQ8o]\u0016\u001cG/[8og\u0006\u0019\u0012m]:jO:tUm^\"p]:,7\r^5p]RA\u0011qLB}\u0007w\u001cy\u0010C\u0004\u0004rj\u0003\rAa1\t\u000f\ru(\f1\u0001\u0003:\u0005I\u0001O]8dKN\u001cxN\u001d\u0005\b\t\u0003Q\u0006\u0019AA0\u0003!i\u0017-\u001f\"m_\u000e\\\u0017AB<bW\u0016,\b/A\u0007bI\u0012\u0004&o\\2fgN|'o\u001d\u000b\u0005\u0003W!I\u0001C\u0004\u0005\fq\u0003\r!a\u0010\u0002\u0011Q|7I]3bi\u0016\fAB\\3x!J|7-Z:t_J$\"B!\u000f\u0005\u0012\u0011UA1\u0005C\u001b\u0011\u001d!\u0019\"\u0018a\u0001\u0003\u007f\t!!\u001b3\t\u000f\u0011]Q\f1\u0001\u0005\u001a\u0005aA.[:uK:,'OT1nKB!A1\u0004C\u0010\u001b\t!iBC\u0002a\u0003\u0007IA\u0001\"\t\u0005\u001e\taA*[:uK:,'OT1nK\"9AQE/A\u0002\u0011\u001d\u0012\u0001E:fGV\u0014\u0018\u000e^=Qe>$xnY8m!\u0011!I\u0003\"\r\u000e\u0005\u0011-\"\u0002\u0002C\u0017\t_\tA!Y;uQ*!\u0011\u0011QA\u0002\u0013\u0011!\u0019\u0004b\u000b\u0003!M+7-\u001e:jif\u0004&o\u001c;pG>d\u0007b\u0002C\u001c;\u0002\u0007A\u0011H\u0001\u001eG>tg.Z2uS>tG)[:d_:tWm\u0019;MSN$XM\\3sgB11\u0011\u0006C\u001e\t\u007fIA\u0001\"\u0010\u00032\t\u00191+Z9\u0011\t\u0011\u0005CQI\u0007\u0003\t\u0007R1\u0001YAR\u0013\u0011!9\u0005b\u0011\u00039\r{gN\\3di&|g\u000eR5tG>tg.Z2u\u0019&\u001cH/\u001a8fe\u0002")
public abstract class Acceptor
implements Runnable,
Logging {
    private volatile Acceptor$DelayedCloseSocket$ DelayedCloseSocket$module;
    private final SocketServer socketServer;
    private final Endpoint endPoint;
    private KafkaConfig config;
    private final int nodeId;
    private final ConnectionQuotas connectionQuotas;
    private final Time time;
    private final boolean isPrivilegedListener;
    private final RequestChannel requestChannel;
    private final Metrics metrics;
    private final CredentialProvider credentialProvider;
    private final LogContext logContext;
    private final MemoryPool memoryPool;
    private final ApiVersionManager apiVersionManager;
    private final AtomicBoolean shouldRun;
    private final Integer sendBufferSize;
    private final Integer recvBufferSize;
    private final Integer listenBacklogSize;
    private final Selector nioSelector;
    private ServerSocketChannel serverChannel;
    private final int localPort;
    private final ArrayBuffer<Processor> processors;
    private final KafkaMetricsGroup backwardCompatibilityMetricGroup;
    private final MetricName blockedPercentMeterMetricName;
    private final Meter blockedPercentMeter;
    private int currentProcessorIndex;
    private final PriorityQueue<DelayedCloseSocket> throttledSockets;
    private final AtomicBoolean started;
    private final CompletableFuture<Void> startedFuture;
    private final KafkaThread thread;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public Acceptor$DelayedCloseSocket$ DelayedCloseSocket() {
        if (this.DelayedCloseSocket$module == null) {
            this.DelayedCloseSocket$lzycompute$1();
        }
        return this.DelayedCloseSocket$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public SocketServer socketServer() {
        return this.socketServer;
    }

    public Endpoint endPoint() {
        return this.endPoint;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    public AtomicBoolean shouldRun() {
        return this.shouldRun;
    }

    private Integer sendBufferSize() {
        return this.sendBufferSize;
    }

    private Integer recvBufferSize() {
        return this.recvBufferSize;
    }

    private Integer listenBacklogSize() {
        return this.listenBacklogSize;
    }

    private Selector nioSelector() {
        return this.nioSelector;
    }

    public ServerSocketChannel serverChannel() {
        return this.serverChannel;
    }

    public void serverChannel_$eq(ServerSocketChannel x$1) {
        this.serverChannel = x$1;
    }

    public int localPort() {
        return this.localPort;
    }

    public ArrayBuffer<Processor> processors() {
        return this.processors;
    }

    private KafkaMetricsGroup backwardCompatibilityMetricGroup() {
        return this.backwardCompatibilityMetricGroup;
    }

    private MetricName blockedPercentMeterMetricName() {
        return this.blockedPercentMeterMetricName;
    }

    private Meter blockedPercentMeter() {
        return this.blockedPercentMeter;
    }

    private int currentProcessorIndex() {
        return this.currentProcessorIndex;
    }

    private void currentProcessorIndex_$eq(int x$1) {
        this.currentProcessorIndex = x$1;
    }

    public PriorityQueue<DelayedCloseSocket> throttledSockets() {
        return this.throttledSockets;
    }

    private AtomicBoolean started() {
        return this.started;
    }

    public CompletableFuture<Void> startedFuture() {
        return this.startedFuture;
    }

    public KafkaThread thread() {
        return this.thread;
    }

    public void start() {
        synchronized (this) {
            this.liftedTree1$1();
            return;
        }
    }

    public synchronized void removeProcessors(int removeCount) {
        ArrayBuffer toRemove = (ArrayBuffer)this.processors().takeRight(removeCount);
        this.processors().remove(this.processors().size() - removeCount, removeCount);
        toRemove.foreach((Function1 & Serializable)x$9 -> {
            x$9.close();
            return BoxedUnit.UNIT;
        });
        toRemove.foreach((Function1 & Serializable)processor -> {
            this.requestChannel.removeProcessor(processor.id());
            return BoxedUnit.UNIT;
        });
    }

    public void beginShutdown() {
        if (this.shouldRun().getAndSet(false)) {
            this.wakeup();
            synchronized (this) {
                this.processors().foreach((Function1 & Serializable)x$10 -> {
                    x$10.beginShutdown();
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }
    }

    public void close() {
        this.beginShutdown();
        this.thread().join();
        if (!this.started().get()) {
            this.closeAll();
        }
        synchronized (this) {
            this.processors().foreach((Function1 & Serializable)x$11 -> {
                x$11.close();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void run() {
        this.serverChannel().register(this.nioSelector(), 16);
        try {
            while (this.shouldRun().get()) {
                try {
                    this.acceptNewConnections();
                    this.closeThrottledConnections();
                }
                catch (ControlThrowable controlThrowable) {
                    throw controlThrowable;
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Error occurred", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
            }
        }
        finally {
            this.closeAll();
        }
    }

    private void closeAll() {
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Closing server socket, selector, and any throttled sockets.");
        Utils.closeQuietly((AutoCloseable)this.serverChannel(), (String)"Acceptor serverChannel");
        Utils.closeQuietly((AutoCloseable)this.nioSelector(), (String)"Acceptor nioSelector");
        this.throttledSockets().foreach((Function1 & Serializable)throttledSocket -> {
            SocketServer$.MODULE$.closeSocket(throttledSocket.socket());
            return BoxedUnit.UNIT;
        });
        this.throttledSockets().clear();
    }

    private ServerSocketChannel openServerSocket(String host, int port, int listenBacklogSize) {
        InetSocketAddress socketAddress = Utils.isBlank((String)host) ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        ServerSocketChannel serverChannel = this.socketServer().socketFactory().openServerSocket(this.endPoint().listener(), socketAddress, listenBacklogSize, Predef$.MODULE$.Integer2int(this.recvBufferSize()));
        this.info((Function0<String>)(Function0 & Serializable)() -> "Awaiting socket connections on " + socketAddress.getHostString() + ":" + serverChannel.socket().getLocalPort() + ".");
        return serverChannel;
    }

    private void acceptNewConnections() {
        if (this.nioSelector().select(500L) > 0) {
            java.util.Iterator<SelectionKey> iter = this.nioSelector().selectedKeys().iterator();
            while (iter.hasNext() && this.shouldRun().get()) {
                try {
                    SelectionKey key = iter.next();
                    iter.remove();
                    if (key.isAcceptable()) {
                        this.accept(key).foreach((Function1 & Serializable)socketChannel -> {
                            Acceptor.$anonfun$acceptNewConnections$1(this, socketChannel);
                            return BoxedUnit.UNIT;
                        });
                        continue;
                    }
                    throw new IllegalStateException("Unrecognized key state for acceptor thread.");
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Error while accepting connection", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
            }
            return;
        }
    }

    private Option<SocketChannel> accept(SelectionKey key) {
        SocketChannel socketChannel = ((ServerSocketChannel)key.channel()).accept();
        ListenerName listenerName = ListenerName.normalised((String)this.endPoint().listener());
        try {
            this.connectionQuotas().inc(listenerName, socketChannel.socket().getInetAddress(), this.blockedPercentMeter());
            this.configureAcceptedSocketChannel(socketChannel);
            return new Some((Object)socketChannel);
        }
        catch (TooManyConnectionsException e) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Rejected connection from " + e$3.ip + ", address already has the configured maximum of " + e$3.count + " connections.");
            this.connectionQuotas().closeChannel(this, listenerName, socketChannel);
            return None$.MODULE$;
        }
        catch (ConnectionThrottledException e) {
            InetAddress ip = socketChannel.socket().getInetAddress();
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Delaying closing of connection from " + ip + " for " + e$4.throttleTimeMs + " ms");
            long endThrottleTimeMs = e.startThrottleTimeMs + e.throttleTimeMs;
            this.throttledSockets().$plus$eq((Object)new DelayedCloseSocket(this, socketChannel, endThrottleTimeMs));
            return None$.MODULE$;
        }
        catch (IOException e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Encountered an error while configuring the connection, closing it.", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            this.connectionQuotas().closeChannel(this, listenerName, socketChannel);
            return None$.MODULE$;
        }
    }

    public void configureAcceptedSocketChannel(SocketChannel socketChannel) {
        socketChannel.configureBlocking(false);
        socketChannel.socket().setTcpNoDelay(true);
        socketChannel.socket().setKeepAlive(true);
        if (!BoxesRunTime.equalsNumObject((Number)this.sendBufferSize(), (Object)BoxesRunTime.boxToInteger((int)-1))) {
            socketChannel.socket().setSendBufferSize(Predef$.MODULE$.Integer2int(this.sendBufferSize()));
            return;
        }
    }

    private void closeThrottledConnections() {
        long timeMs = this.time.milliseconds();
        while (this.throttledSockets().headOption().exists((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)Acceptor.$anonfun$closeThrottledConnections$1(timeMs, x$12)))) {
            DelayedCloseSocket closingSocket = (DelayedCloseSocket)this.throttledSockets().dequeue();
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Closing socket from ip " + closingSocket.socket().getRemoteAddress());
            SocketServer$.MODULE$.closeSocket(closingSocket.socket());
        }
    }

    private boolean assignNewConnection(SocketChannel socketChannel, Processor processor, boolean mayBlock) {
        if (processor.accept(socketChannel, mayBlock, this.blockedPercentMeter())) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Accepted connection from " + socketChannel.socket().getRemoteSocketAddress() + " on " + socketChannel.socket().getLocalSocketAddress() + " and assigned it to processor " + processor.id() + ", sendBufferSize [actual|requested]: [" + socketChannel.socket().getSendBufferSize() + "|" + this.sendBufferSize() + "] recvBufferSize [actual|requested]: [" + socketChannel.socket().getReceiveBufferSize() + "|" + this.recvBufferSize() + "]");
            return true;
        }
        return false;
    }

    public void wakeup() {
        this.nioSelector().wakeup();
    }

    public void addProcessors(int toCreate) {
        synchronized (this) {
            ListenerName listenerName = ListenerName.normalised((String)this.endPoint().listener());
            SecurityProtocol securityProtocol = this.endPoint().securityProtocol();
            ArrayBuffer listenerProcessors = new ArrayBuffer();
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), toCreate).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$13 -> {
                Processor processor = this.newProcessor(this.socketServer().nextProcessorId(), listenerName, securityProtocol, this.socketServer().connectionDisconnectListeners());
                listenerProcessors.$plus$eq((Object)processor);
                $this.requestChannel.addProcessor(processor);
                if (this.started().get()) {
                    processor.start();
                    return;
                }
            });
            ArrayBuffer cfr_ignored_0 = (ArrayBuffer)this.processors().$plus$plus$eq((IterableOnce)listenerProcessors);
            return;
        }
    }

    public Processor newProcessor(int id, ListenerName listenerName, SecurityProtocol securityProtocol, Seq<ConnectionDisconnectListener> connectionDisconnectListeners) {
        String name = "data-plane-kafka-network-thread-" + this.nodeId + "-" + this.endPoint().listener() + "-" + this.endPoint().securityProtocol() + "-" + id;
        return new Processor(id, this.time, Predef$.MODULE$.Integer2int(this.config().socketRequestMaxBytes()), this.requestChannel, this.connectionQuotas(), Predef$.MODULE$.Long2long(this.config().connectionsMaxIdleMs()), Predef$.MODULE$.Integer2int(this.config().failedAuthenticationDelayMs()), listenerName, securityProtocol, this.config(), this.metrics, this.credentialProvider, this.memoryPool, this.logContext, Processor$.MODULE$.ConnectionQueueSize(), this.isPrivilegedListener, this.apiVersionManager, name, connectionDisconnectListeners);
    }

    private final void DelayedCloseSocket$lzycompute$1() {
        synchronized (this) {
            if (this.DelayedCloseSocket$module == null) {
                this.DelayedCloseSocket$module = new Acceptor$DelayedCloseSocket$(this);
            }
            return;
        }
    }

    private final /* synthetic */ Object liftedTree1$1() {
        try {
            if (!this.shouldRun().get()) {
                throw new ClosedChannelException();
            }
            if (this.serverChannel() == null) {
                this.serverChannel_$eq(this.openServerSocket(this.endPoint().host(), this.endPoint().port(), Predef$.MODULE$.Integer2int(this.listenBacklogSize())));
                this.debug((Function0<String>)(Function0 & Serializable)() -> "Opened endpoint " + this.endPoint().host() + ":" + this.endPoint().port());
            }
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Starting processors for listener " + this.endPoint().listener());
            this.processors().foreach((Function1 & Serializable)x$8 -> {
                x$8.start();
                return BoxedUnit.UNIT;
            });
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Starting acceptor thread for listener " + this.endPoint().listener());
            this.thread().start();
            this.startedFuture().complete(null);
            this.started().set(true);
            return BoxedUnit.UNIT;
        }
        catch (ClosedChannelException e) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Refusing to start acceptor for " + this.endPoint().listener() + " since the acceptor has already been shut down.");
            return BoxesRunTime.boxToBoolean((boolean)this.startedFuture().completeExceptionally(e));
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Unable to start acceptor for " + this.endPoint().listener(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
            return BoxesRunTime.boxToBoolean((boolean)this.startedFuture().completeExceptionally(new RuntimeException("Unable to start acceptor for " + this.endPoint().listener(), t)));
        }
    }

    public static final /* synthetic */ void $anonfun$acceptNewConnections$1(Acceptor $this, SocketChannel socketChannel) {
        Processor processor;
        int n;
        synchronized ($this) {
            n = $this.processors().length();
        }
        int retriesLeft = n;
        do {
            --retriesLeft;
            synchronized ($this) {
                $this.currentProcessorIndex_$eq($this.currentProcessorIndex() % $this.processors().length());
                processor = (Processor)$this.processors().apply($this.currentProcessorIndex());
            }
            $this.currentProcessorIndex_$eq($this.currentProcessorIndex() + 1);
        } while (!$this.assignNewConnection(socketChannel, processor, retriesLeft == 0));
    }

    public static final /* synthetic */ boolean $anonfun$closeThrottledConnections$1(long timeMs$1, DelayedCloseSocket x$12) {
        return x$12.endThrottleTimeMs() < timeMs$1;
    }

    public Acceptor(SocketServer socketServer, Endpoint endPoint, KafkaConfig config, int nodeId, ConnectionQuotas connectionQuotas, Time time, boolean isPrivilegedListener, RequestChannel requestChannel, Metrics metrics, CredentialProvider credentialProvider, LogContext logContext, MemoryPool memoryPool, ApiVersionManager apiVersionManager) {
        int n;
        this.socketServer = socketServer;
        this.endPoint = endPoint;
        this.config = config;
        this.nodeId = nodeId;
        this.connectionQuotas = connectionQuotas;
        this.time = time;
        this.isPrivilegedListener = isPrivilegedListener;
        this.requestChannel = requestChannel;
        this.metrics = metrics;
        this.credentialProvider = credentialProvider;
        this.logContext = logContext;
        this.memoryPool = memoryPool;
        this.apiVersionManager = apiVersionManager;
        this.shouldRun = new AtomicBoolean(true);
        this.sendBufferSize = this.config().socketSendBufferBytes();
        this.recvBufferSize = this.config().socketReceiveBufferBytes();
        this.listenBacklogSize = this.config().socketListenBacklogSize();
        this.nioSelector = Selector.open();
        if (endPoint.port() != 0) {
            n = endPoint.port();
        } else {
            this.serverChannel_$eq(this.openServerSocket(endPoint.host(), endPoint.port(), Predef$.MODULE$.Integer2int(this.listenBacklogSize())));
            int newPort = this.serverChannel().socket().getLocalPort();
            this.info((Function0<String>)(Function0 & Serializable)() -> "Opened wildcard endpoint " + this.endPoint().host() + ":" + newPort);
            n = newPort;
        }
        this.localPort = n;
        this.processors = new ArrayBuffer();
        this.backwardCompatibilityMetricGroup = new KafkaMetricsGroup("kafka.network", "Acceptor");
        this.blockedPercentMeterMetricName = this.backwardCompatibilityMetricGroup().metricName("AcceptorBlockedPercent", CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)endPoint.listener())}))).asJava());
        this.blockedPercentMeter = this.backwardCompatibilityMetricGroup().newMeter(this.blockedPercentMeterMetricName(), "blocked time", TimeUnit.NANOSECONDS);
        this.currentProcessorIndex = 0;
        this.throttledSockets = new PriorityQueue(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        this.started = new AtomicBoolean();
        this.startedFuture = new CompletableFuture();
        String nonDaemon_name = "data-plane-kafka-socket-acceptor-" + endPoint.listener() + "-" + endPoint.securityProtocol() + "-" + endPoint.port();
        this.thread = new KafkaThread(nonDaemon_name, (Runnable)this, false);
    }

    public class DelayedCloseSocket
    implements Ordered<DelayedCloseSocket>,
    Product,
    Serializable {
        private final SocketChannel socket;
        private final long endThrottleTimeMs;
        public final /* synthetic */ Acceptor $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public boolean $less(Object that) {
            return Ordered.$less$((Ordered)this, (Object)that);
        }

        public boolean $greater(Object that) {
            return Ordered.$greater$((Ordered)this, (Object)that);
        }

        public boolean $less$eq(Object that) {
            return Ordered.$less$eq$((Ordered)this, (Object)that);
        }

        public boolean $greater$eq(Object that) {
            return Ordered.$greater$eq$((Ordered)this, (Object)that);
        }

        public int compareTo(Object that) {
            return Ordered.compareTo$((Ordered)this, (Object)that);
        }

        public SocketChannel socket() {
            return this.socket;
        }

        public long endThrottleTimeMs() {
            return this.endThrottleTimeMs;
        }

        public int compare(DelayedCloseSocket that) {
            return new RichLong(Predef$.MODULE$.longWrapper(this.endThrottleTimeMs())).compare((Object)BoxesRunTime.boxToLong((long)that.endThrottleTimeMs()));
        }

        public DelayedCloseSocket copy(SocketChannel socket, long endThrottleTimeMs) {
            return new DelayedCloseSocket(this.kafka$network$Acceptor$DelayedCloseSocket$$$outer(), socket, endThrottleTimeMs);
        }

        public SocketChannel copy$default$1() {
            return this.socket();
        }

        public long copy$default$2() {
            return this.endThrottleTimeMs();
        }

        public String productPrefix() {
            return "DelayedCloseSocket";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.socket();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.endThrottleTimeMs());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DelayedCloseSocket;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "socket";
                }
                case 1: {
                    return "endThrottleTimeMs";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)-1983368983), (int)Statics.anyHash((Object)this.socket())), (int)Statics.longHash((long)this.endThrottleTimeMs())), (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof DelayedCloseSocket && ((DelayedCloseSocket)x$1).kafka$network$Acceptor$DelayedCloseSocket$$$outer() == this.kafka$network$Acceptor$DelayedCloseSocket$$$outer())) break block3;
                    DelayedCloseSocket delayedCloseSocket = (DelayedCloseSocket)x$1;
                    if (this.endThrottleTimeMs() != delayedCloseSocket.endThrottleTimeMs()) break block3;
                    SocketChannel socketChannel = this.socket();
                    SocketChannel socketChannel2 = delayedCloseSocket.socket();
                    if ((socketChannel != null ? !socketChannel.equals(socketChannel2) : socketChannel2 != null) || !delayedCloseSocket.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ Acceptor kafka$network$Acceptor$DelayedCloseSocket$$$outer() {
            return this.$outer;
        }

        public DelayedCloseSocket(Acceptor $outer, SocketChannel socket, long endThrottleTimeMs) {
            this.socket = socket;
            this.endThrottleTimeMs = endThrottleTimeMs;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Ordered.$init$((Ordered)this);
            Product.$init$((Product)this);
        }
    }
}

