/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics;

import java.util.Objects;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.utils.Time;

public final class KafkaMetric
implements Metric {
    private final MetricName metricName;
    private final Object lock;
    private final Time time;
    private final MetricValueProvider<?> metricValueProvider;
    private volatile MetricConfig config;

    public KafkaMetric(Object lock, MetricName metricName, MetricValueProvider<?> valueProvider, MetricConfig config, Time time) {
        this.metricName = metricName;
        this.lock = lock;
        this.metricValueProvider = Objects.requireNonNull(valueProvider, "valueProvider must not be null");
        this.config = config;
        this.time = time;
    }

    public MetricConfig config() {
        return this.config;
    }

    @Override
    public MetricName metricName() {
        return this.metricName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object metricValue() {
        long now = this.time.milliseconds();
        Object object = this.lock;
        synchronized (object) {
            return this.metricValueProvider.value(this.config, now);
        }
    }

    public boolean isMeasurable() {
        return this.metricValueProvider instanceof Measurable;
    }

    public Measurable measurable() {
        if (this.isMeasurable()) {
            return (Measurable)this.metricValueProvider;
        }
        throw new IllegalStateException("Not a measurable: " + String.valueOf(this.metricValueProvider.getClass()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    double measurableValue(long timeMs) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isMeasurable()) {
                return ((Measurable)this.metricValueProvider).measure(this.config, timeMs);
            }
            return 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void config(MetricConfig config) {
        Object object = this.lock;
        synchronized (object) {
            this.config = config;
        }
    }
}

