/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.common.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.common.runtime.CoordinatorMetadataDelta;
import org.apache.kafka.coordinator.common.runtime.CoordinatorMetadataImage;
import org.apache.kafka.coordinator.common.runtime.KRaftCoordinatorMetadataDelta;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.PartitionRegistration;

public class KRaftCoordinatorMetadataImage
implements CoordinatorMetadataImage {
    private final MetadataImage metadataImage;

    public KRaftCoordinatorMetadataImage(MetadataImage metadataImage) {
        this.metadataImage = metadataImage;
    }

    @Override
    public Set<Uuid> topicIds() {
        return Collections.unmodifiableSet(this.metadataImage.topics().topicsById().keySet());
    }

    @Override
    public Set<String> topicNames() {
        return Collections.unmodifiableSet(this.metadataImage.topics().topicsByName().keySet());
    }

    @Override
    public Optional<CoordinatorMetadataImage.TopicMetadata> topicMetadata(Uuid topicId) {
        TopicImage topicImage = this.metadataImage.topics().getTopic(topicId);
        if (topicImage == null) {
            return Optional.empty();
        }
        ClusterImage clusterImage = this.metadataImage.cluster();
        if (clusterImage == null) {
            return Optional.empty();
        }
        return Optional.of(new KraftTopicMetadata(topicImage, clusterImage));
    }

    @Override
    public Optional<CoordinatorMetadataImage.TopicMetadata> topicMetadata(String topicName) {
        TopicImage topicImage = this.metadataImage.topics().getTopic(topicName);
        if (topicImage == null) {
            return Optional.empty();
        }
        ClusterImage clusterImage = this.metadataImage.cluster();
        if (clusterImage == null) {
            return Optional.empty();
        }
        return Optional.of(new KraftTopicMetadata(topicImage, clusterImage));
    }

    @Override
    public CoordinatorMetadataDelta emptyDelta() {
        return new KRaftCoordinatorMetadataDelta(new MetadataDelta(this.metadataImage));
    }

    @Override
    public long version() {
        return this.metadataImage.offset();
    }

    @Override
    public boolean isEmpty() {
        return this.metadataImage.isEmpty();
    }

    public String toString() {
        return this.metadataImage.toString();
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        KRaftCoordinatorMetadataImage other = (KRaftCoordinatorMetadataImage)o;
        return this.metadataImage.equals((Object)other.metadataImage);
    }

    public int hashCode() {
        return this.metadataImage.hashCode();
    }

    public static class KraftTopicMetadata
    implements CoordinatorMetadataImage.TopicMetadata {
        private final TopicImage topicImage;
        private final ClusterImage clusterImage;

        public KraftTopicMetadata(TopicImage topicImage, ClusterImage clusterImage) {
            this.topicImage = topicImage;
            this.clusterImage = clusterImage;
        }

        @Override
        public String name() {
            return this.topicImage.name();
        }

        @Override
        public Uuid id() {
            return this.topicImage.id();
        }

        @Override
        public int partitionCount() {
            return this.topicImage.partitions().size();
        }

        @Override
        public List<String> partitionRacks(int partition) {
            ArrayList<String> racks = new ArrayList<String>();
            PartitionRegistration partitionRegistration = (PartitionRegistration)this.topicImage.partitions().get(partition);
            if (partitionRegistration != null) {
                for (int replicaId : partitionRegistration.replicas) {
                    BrokerRegistration broker = this.clusterImage.broker(replicaId);
                    if (broker == null) continue;
                    broker.rack().ifPresent(racks::add);
                }
                return racks;
            }
            return List.of();
        }
    }
}

