/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import com.dynatrace.hash4j.hashing.HashStream64;
import com.dynatrace.hash4j.hashing.Hashing;
import com.google.re2j.Pattern;
import com.google.re2j.PatternSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidRegularExpression;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerProtocolAssignment;
import org.apache.kafka.common.message.ConsumerProtocolSubscription;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.coordinator.common.runtime.CoordinatorMetadataImage;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupCurrentMemberAssignmentValue;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public class Utils {
    static final byte TOPIC_HASH_MAGIC_BYTE = 0;

    private Utils() {
    }

    public static OptionalInt ofSentinel(int value) {
        return value != -1 ? OptionalInt.of(value) : OptionalInt.empty();
    }

    public static OptionalLong ofSentinel(long value) {
        return value != -1L ? OptionalLong.of(value) : OptionalLong.empty();
    }

    public static String assignmentToString(Map<Uuid, Set<Integer>> assignment) {
        StringBuilder builder = new StringBuilder("[");
        Iterator<Map.Entry<Uuid, Set<Integer>>> topicsIterator = assignment.entrySet().iterator();
        while (topicsIterator.hasNext()) {
            Map.Entry<Uuid, Set<Integer>> entry = topicsIterator.next();
            Iterator<Integer> partitionsIterator = entry.getValue().iterator();
            while (partitionsIterator.hasNext()) {
                builder.append(entry.getKey());
                builder.append("-");
                builder.append(partitionsIterator.next());
                if (!partitionsIterator.hasNext() && !topicsIterator.hasNext()) continue;
                builder.append(", ");
            }
        }
        builder.append("]");
        return builder.toString();
    }

    public static Integer decValue(String key, Integer value) {
        if (value == null) {
            return null;
        }
        return value == 1 ? null : Integer.valueOf(value - 1);
    }

    public static Integer incValue(String key, Integer value) {
        return value == null ? 1 : value + 1;
    }

    public static Long decValue(Object key, Long value) {
        if (value == null) {
            return null;
        }
        return value == 1L ? null : Long.valueOf(value - 1L);
    }

    public static Long incValue(Object key, Long value) {
        return value == null ? 1L : value + 1L;
    }

    public static Optional<String> toOptional(String str) {
        return str == null || str.isEmpty() ? Optional.empty() : Optional.of(str);
    }

    public static ConsumerProtocolAssignment toConsumerProtocolAssignment(Map<Uuid, Set<Integer>> assignment, CoordinatorMetadataImage image) {
        ConsumerProtocolAssignment.TopicPartitionCollection collection = new ConsumerProtocolAssignment.TopicPartitionCollection();
        assignment.forEach((topicId, partitions) -> image.topicMetadata(topicId).ifPresent(topicMetadata -> collection.add((ImplicitLinkedHashCollection.Element)new ConsumerProtocolAssignment.TopicPartition().setTopic(topicMetadata.name()).setPartitions(new ArrayList(partitions)))));
        return new ConsumerProtocolAssignment().setAssignedPartitions(collection);
    }

    public static Map<Uuid, Set<Integer>> toTopicPartitionMap(ConsumerProtocolAssignment consumerProtocolAssignment, CoordinatorMetadataImage metadataImage) {
        HashMap<Uuid, Set<Integer>> topicPartitionMap = new HashMap<Uuid, Set<Integer>>();
        consumerProtocolAssignment.assignedPartitions().forEach(topicPartition -> metadataImage.topicMetadata(topicPartition.topic()).ifPresent(topicMetadata -> topicPartitionMap.put(topicMetadata.id(), new HashSet(topicPartition.partitions()))));
        return topicPartitionMap;
    }

    public static List<ConsumerGroupHeartbeatRequestData.TopicPartitions> toTopicPartitions(ConsumerProtocolSubscription.TopicPartitionCollection topicPartitionCollection, CoordinatorMetadataImage metadataImage) {
        ArrayList<ConsumerGroupHeartbeatRequestData.TopicPartitions> res = new ArrayList<ConsumerGroupHeartbeatRequestData.TopicPartitions>();
        for (ConsumerProtocolSubscription.TopicPartition tp : topicPartitionCollection) {
            metadataImage.topicMetadata(tp.topic()).ifPresent(topicMetadata -> res.add(new ConsumerGroupHeartbeatRequestData.TopicPartitions().setTopicId(topicMetadata.id()).setPartitions(tp.partitions())));
        }
        return res;
    }

    public static Map<Uuid, Set<Integer>> assignmentFromTopicPartitions(List<ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions> topicPartitionsList) {
        return topicPartitionsList.stream().collect(Collectors.toMap(ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions::topicId, topicPartitions -> Collections.unmodifiableSet(new HashSet<Integer>(topicPartitions.partitions()))));
    }

    public static Map<Uuid, Set<Integer>> assignmentFromShareGroupTopicPartitions(List<ShareGroupCurrentMemberAssignmentValue.TopicPartitions> topicPartitionsList) {
        return topicPartitionsList.stream().collect(Collectors.toMap(ShareGroupCurrentMemberAssignmentValue.TopicPartitions::topicId, topicPartitions -> Collections.unmodifiableSet(new HashSet<Integer>(topicPartitions.partitions()))));
    }

    public static ApiMessage messageOrNull(ApiMessageAndVersion apiMessageAndVersion) {
        if (apiMessageAndVersion == null) {
            return null;
        }
        return apiMessageAndVersion.message();
    }

    static void throwIfEmptyString(String value, String error) throws InvalidRequestException {
        if (value != null && value.trim().isEmpty()) {
            throw new InvalidRequestException(error);
        }
    }

    static void throwIfNotEmptyCollection(Collection<?> value, String error) throws InvalidRequestException {
        if (value == null || !value.isEmpty()) {
            throw new InvalidRequestException(error);
        }
    }

    static void throwIfNotNullOrEmpty(Collection<?> value, String error) throws InvalidRequestException {
        if (value != null && !value.isEmpty()) {
            throw new InvalidRequestException(error);
        }
    }

    static void throwIfNotNull(Object value, String error) throws InvalidRequestException {
        if (value != null) {
            throw new InvalidRequestException(error);
        }
    }

    static void throwIfNull(Object value, String error) throws InvalidRequestException {
        if (value == null) {
            throw new InvalidRequestException(error);
        }
    }

    static void throwIfRegularExpressionIsInvalid(String regex) throws InvalidRegularExpression {
        try {
            Pattern.compile((String)regex);
        }
        catch (PatternSyntaxException ex) {
            throw new InvalidRegularExpression(String.format("SubscribedTopicRegex `%s` is not a valid regular expression: %s.", regex, ex.getDescription()));
        }
    }

    public static long computeGroupHash(Map<String, Long> topicHashes) {
        if (topicHashes.isEmpty()) {
            return 0L;
        }
        ArrayList<Map.Entry<String, Long>> sortedEntries = new ArrayList<Map.Entry<String, Long>>(topicHashes.entrySet());
        sortedEntries.sort(Map.Entry.comparingByKey());
        HashStream64 hasher = Hashing.xxh3_64().hashStream();
        for (Map.Entry entry : sortedEntries) {
            hasher.putLong(((Long)entry.getValue()).longValue());
        }
        return hasher.getAsLong();
    }

    public static long computeTopicHash(String topicName, CoordinatorMetadataImage metadataImage) {
        Optional topicImage = metadataImage.topicMetadata(topicName);
        if (topicImage.isEmpty()) {
            return 0L;
        }
        CoordinatorMetadataImage.TopicMetadata topicMetadata = (CoordinatorMetadataImage.TopicMetadata)topicImage.get();
        HashStream64 hasher = Hashing.xxh3_64().hashStream();
        hasher = hasher.putByte((byte)0).putLong(topicMetadata.id().getMostSignificantBits()).putLong(topicMetadata.id().getLeastSignificantBits()).putString(topicMetadata.name()).putInt(topicMetadata.partitionCount());
        for (int i = 0; i < topicMetadata.partitionCount(); ++i) {
            hasher = hasher.putInt(i);
            List partitionRacks = topicMetadata.partitionRacks(i);
            Collections.sort(partitionRacks);
            for (String rack : partitionRacks) {
                hasher = hasher.putInt(rack.length()).putString(rack);
            }
        }
        return hasher.getAsLong();
    }
}

