/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.linkis.cli.application.CtxBuilder;
import org.apache.linkis.cli.application.entity.command.CmdTemplate;
import org.apache.linkis.cli.application.entity.context.CliCtx;
import org.apache.linkis.cli.application.entity.job.Job;
import org.apache.linkis.cli.application.entity.job.JobResult;
import org.apache.linkis.cli.application.exception.CommandException;
import org.apache.linkis.cli.application.interactor.command.CmdTemplateFactory;
import org.apache.linkis.cli.application.interactor.command.template.UniversalCmdTemplate;
import org.apache.linkis.cli.application.interactor.job.help.HelpJob;
import org.apache.linkis.cli.application.interactor.job.interactive.InteractiveJob;
import org.apache.linkis.cli.application.interactor.job.jobcmd.JobCmdJob;
import org.apache.linkis.cli.application.interactor.job.once.LinkisOnceJob;
import org.apache.linkis.cli.application.interactor.job.version.VersionJob;
import org.apache.linkis.cli.application.operator.OperManager;
import org.apache.linkis.cli.application.operator.once.OnceOperBuilder;
import org.apache.linkis.cli.application.operator.ujes.LinkisOperBuilder;
import org.apache.linkis.cli.application.present.HelpPresenter;
import org.apache.linkis.cli.application.present.model.HelpInfoModel;
import org.apache.linkis.cli.application.utils.LoggerManager;
import org.apache.linkis.cli.application.utils.SchedulerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkisClientApplication {
    private static Logger logger = LoggerFactory.getLogger(LinkisClientApplication.class);
    private static boolean showHelp = false;

    public static void main(String[] args) {
        JobResult result;
        CmdTemplateFactory.register(new UniversalCmdTemplate());
        CliCtx ctx = null;
        try {
            ctx = CtxBuilder.buildCtx(args);
        }
        catch (CommandException e) {
            CmdTemplate template = CmdTemplateFactory.getTemplateOri(e.getCmdType());
            if (template != null) {
                HelpInfoModel model = new HelpInfoModel();
                model.buildModel(template);
                new HelpPresenter().present(model);
            }
            LoggerManager.getInformationLogger().error("Failed to build CliCtx", (Throwable)e);
            System.exit(-1);
        }
        OperManager.register("linkis.oper", new LinkisOperBuilder());
        OperManager.register("linkis.once", new OnceOperBuilder());
        Job job = LinkisClientApplication.isVersionCmd(ctx) != false ? new VersionJob() : (LinkisClientApplication.isHelp(ctx) != false ? new HelpJob() : (LinkisClientApplication.isJobCmd(ctx) != false ? new JobCmdJob() : (LinkisClientApplication.isOnceCmd(ctx) != false ? new LinkisOnceJob() : new InteractiveJob())));
        job.build(ctx);
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                if (job != null) {
                    job.onDestroy();
                }
            }));
            result = job.run();
        }
        catch (Exception e) {
            logger.error("Failed to execute job", (Throwable)e);
            result = new JobResult(){

                @Override
                public Boolean isSuccess() {
                    return false;
                }

                @Override
                public String getMessage() {
                    return "Failed to execute job" + ExceptionUtils.getStackTrace((Throwable)e);
                }

                @Override
                public Map<String, String> getExtraMessage() {
                    return new HashMap<String, String>();
                }
            };
        }
        LinkisClientApplication.printIndicator(result);
        SchedulerManager.shutDown();
        if (result.isSuccess().booleanValue()) {
            System.exit(0);
        } else {
            System.exit(-1);
        }
    }

    private static void printIndicator(JobResult jobResult) {
        if (jobResult.isSuccess().booleanValue()) {
            LoggerManager.getPlaintTextLogger().info("############Execute Success!!!########");
        } else {
            LoggerManager.getPlaintTextLogger().info(jobResult.getMessage());
            StringBuilder b = new StringBuilder();
            for (Map.Entry<String, String> e : jobResult.getExtraMessage().entrySet()) {
                b.append(e.getKey()).append(":").append(e.getValue()).append(System.lineSeparator());
            }
            LoggerManager.getPlaintTextLogger().info(b.toString());
            LoggerManager.getPlaintTextLogger().info("############Execute Error!!!########");
        }
    }

    private static Boolean isHelp(CliCtx ctx) {
        if (ctx.getVarAccess().hasVar("wds.linkis.client.common.help")) {
            return true;
        }
        return false;
    }

    private static Boolean isVersionCmd(CliCtx ctx) {
        if (ctx.getVarAccess().hasVar("cli.version")) {
            return true;
        }
        return false;
    }

    private static Boolean isJobCmd(CliCtx ctx) {
        if (ctx.getVarAccess().hasVar("wds.linkis.client.common.kill") || ctx.getVarAccess().hasVar("wds.linkis.client.common.status") || ctx.getVarAccess().hasVar("wds.linkis.client.common.desc") || ctx.getVarAccess().hasVar("wds.linkis.client.common.log") || ctx.getVarAccess().hasVar("wds.linkis.client.common.result") || ctx.getVarAccess().hasVar("wds.linkis.client.common.list")) {
            return true;
        }
        return false;
    }

    private static Boolean isOnceCmd(CliCtx ctx) {
        String mode = ctx.getVarAccess().getVarOrDefault(String.class, "wds.linkis.client.common.mode", "ujes");
        return StringUtils.equalsIgnoreCase((CharSequence)mode, (CharSequence)"once");
    }
}

