/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SerdeType;

abstract class SerdeAndColsBuilder<T> {
    private static final String SERDE_LIB = "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe";
    private List<FieldSchema> cols;
    private String serdeName;
    private String serdeLib = "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe";
    private String serdeDescription;
    private String serdeSerializerClass;
    private String serdeDeserializerClass;
    private Map<String, String> serdeParams = new HashMap<String, String>();
    private SerdeType serdeType;
    protected T child;

    protected SerdeAndColsBuilder() {
    }

    protected void setChild(T child) {
        this.child = child;
    }

    protected SerDeInfo buildSerde() {
        SerDeInfo serDeInfo = new SerDeInfo(this.serdeName, this.serdeLib, this.serdeParams);
        if (this.serdeDescription != null) {
            serDeInfo.setDescription(this.serdeDescription);
        }
        if (this.serdeSerializerClass != null) {
            serDeInfo.setSerializerClass(this.serdeSerializerClass);
        }
        if (this.serdeDeserializerClass != null) {
            serDeInfo.setDeserializerClass(this.serdeDeserializerClass);
        }
        if (this.serdeType != null) {
            serDeInfo.setSerdeType(this.serdeType);
        }
        return serDeInfo;
    }

    protected List<FieldSchema> getCols() throws MetaException {
        if (this.cols == null) {
            throw new MetaException("You must provide the columns");
        }
        return this.cols;
    }

    public T setCols(List<FieldSchema> cols) {
        this.cols = cols;
        return this.child;
    }

    public T addCol(String name, String type, String comment) {
        if (this.cols == null) {
            this.cols = new ArrayList<FieldSchema>();
        }
        this.cols.add(new FieldSchema(name, type, comment));
        return this.child;
    }

    public T addCol(String name, String type) {
        return this.addCol(name, type, "");
    }

    public T setSerdeName(String serdeName) {
        this.serdeName = serdeName;
        return this.child;
    }

    public T setSerdeLib(String serdeLib) {
        this.serdeLib = serdeLib;
        return this.child;
    }

    public T setSerdeDescription(String serdeDescription) {
        this.serdeDescription = serdeDescription;
        return this.child;
    }

    public T setSerdeSerializerClass(String serdeSerializerClass) {
        this.serdeSerializerClass = serdeSerializerClass;
        return this.child;
    }

    public T setSerdeDeserializerClass(String serdeDeserializerClass) {
        this.serdeDeserializerClass = serdeDeserializerClass;
        return this.child;
    }

    public T setSerdeParams(Map<String, String> serdeParams) {
        this.serdeParams = serdeParams;
        return this.child;
    }

    public T addSerdeParam(String key, String value) {
        if (this.serdeParams == null) {
            this.serdeParams = new HashMap<String, String>();
        }
        this.serdeParams.put(key, value);
        return this.child;
    }

    public T setSerdeType(SerdeType serdeType) {
        this.serdeType = serdeType;
        return this.child;
    }
}

