/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import java.io.Serializable;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalPlanResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;

public class SamplingOptimizer
implements PhysicalPlanResolver {
    @Override
    public PhysicalContext resolve(PhysicalContext pctx) throws SemanticException {
        for (Task<? extends Serializable> task : pctx.getRootTasks()) {
            ReduceSinkOperator child;
            TableScanOperator tsop;
            Table tbl;
            Operator<? extends OperatorDesc> operator;
            if (!(task instanceof MapRedTask) || !((MapredWork)((MapRedTask)task).getWork()).isFinalMapRed()) continue;
            MapredWork mrWork = (MapredWork)((MapRedTask)task).getWork();
            MapWork mapWork = mrWork.getMapWork();
            ReduceWork reduceWork = mrWork.getReduceWork();
            if (reduceWork == null || reduceWork.getNumReduceTasks() != 1 || mapWork.getAliasToWork().size() != 1 || mapWork.getSamplingType() > 0 || reduceWork.getReducer() == null || OperatorUtils.findSingleOperator(reduceWork.getReducer(), GroupByOperator.class) != null || !((operator = mapWork.getAliasToWork().values().iterator().next()) instanceof TableScanOperator) || (tbl = ((TableScanDesc)(tsop = (TableScanOperator)operator).getConf()).getTableMetadata()) == null || AcidUtils.isInsertOnlyTable(tbl.getParameters()) || (child = OperatorUtils.findSingleOperator(operator, ReduceSinkOperator.class)) == null || ((ReduceSinkDesc)child.getConf()).getNumReducers() != 1 || !((ReduceSinkDesc)child.getConf()).getPartitionCols().isEmpty()) continue;
            ((ReduceSinkDesc)child.getConf()).setNumReducers(-1);
            reduceWork.setNumReduceTasks(-1);
            mapWork.setSamplingType(2);
        }
        return pctx;
    }
}

