/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.instance.label.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.linkis.instance.label.conf.InsLabelConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@ConditionalOnClass(value={Caffeine.class})
@EnableCaching
@Configuration
public class InsLabelCacheConfiguration
extends CachingConfigurerSupport {
    private static final Logger LOG = LoggerFactory.getLogger(InsLabelCacheConfiguration.class);

    @Bean
    @Primary
    public CacheManager cacheManager() {
        CaffeineCacheManager cacheManager = new CaffeineCacheManager();
        cacheManager.setCaffeine(Caffeine.newBuilder().expireAfterWrite((long)((Integer)InsLabelConf.CACHE_EXPIRE_TIME.getValue()).intValue(), TimeUnit.SECONDS).maximumSize((long)((Integer)InsLabelConf.CACHE_MAX_SIZE.getValue()).intValue()));
        cacheManager.setCacheNames(Arrays.asList(((String)InsLabelConf.CACHE_NAMES.getValue()).split(",")));
        return cacheManager;
    }

    @Bean
    @Primary
    public KeyGenerator keyGenerator() {
        return new KeyGenerator(){
            static final String SPLIT_SYMBOL = ":";
            final Logger LOG = LoggerFactory.getLogger(KeyGenerator.class);

            public Object generate(Object target, Method method, Object ... params) {
                StringBuilder keyBuilder = new StringBuilder().append(target.getClass().getSimpleName()).append(SPLIT_SYMBOL).append(method.getName());
                if (params.length > 0) {
                    keyBuilder.append(SPLIT_SYMBOL);
                    for (int i = 0; i < params.length; ++i) {
                        keyBuilder.append(params[i]);
                        if (i >= params.length - 1) continue;
                        keyBuilder.append(SPLIT_SYMBOL);
                    }
                }
                this.LOG.trace("Generate key: [" + keyBuilder.toString() + "]");
                return keyBuilder.toString();
            }
        };
    }
}

