/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.config;

import com.netflix.discovery.AbstractDiscoveryClientOptionalArgs;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.configuration.SSLContextFactory;
import org.springframework.cloud.configuration.TlsProperties;
import org.springframework.cloud.netflix.eureka.MutableDiscoveryClientOptionalArgs;
import org.springframework.cloud.netflix.eureka.RestTemplateTimeoutProperties;
import org.springframework.cloud.netflix.eureka.http.DefaultEurekaClientHttpRequestFactorySupplier;
import org.springframework.cloud.netflix.eureka.http.EurekaClientHttpRequestFactorySupplier;
import org.springframework.cloud.netflix.eureka.http.RestTemplateDiscoveryClientOptionalArgs;
import org.springframework.cloud.netflix.eureka.http.WebClientDiscoveryClientOptionalArgs;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={RestTemplateTimeoutProperties.class})
public class DiscoveryClientOptionalArgsConfiguration {
    protected static final Log logger = LogFactory.getLog(DiscoveryClientOptionalArgsConfiguration.class);

    @Bean
    @ConfigurationProperties(value="eureka.client.tls")
    public TlsProperties tlsProperties() {
        return new TlsProperties();
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.web.client.RestTemplate"})
    @ConditionalOnMissingClass(value={"com.sun.jersey.api.client.filter.ClientFilter"})
    @ConditionalOnMissingBean(value={AbstractDiscoveryClientOptionalArgs.class}, search=SearchStrategy.CURRENT)
    @ConditionalOnProperty(prefix="eureka.client", name={"webclient.enabled"}, matchIfMissing=true, havingValue="false")
    public RestTemplateDiscoveryClientOptionalArgs restTemplateDiscoveryClientOptionalArgs(TlsProperties tlsProperties, EurekaClientHttpRequestFactorySupplier eurekaClientHttpRequestFactorySupplier) throws GeneralSecurityException, IOException {
        logger.info((Object)"Eureka HTTP Client uses RestTemplate.");
        RestTemplateDiscoveryClientOptionalArgs result = new RestTemplateDiscoveryClientOptionalArgs(eurekaClientHttpRequestFactorySupplier);
        DiscoveryClientOptionalArgsConfiguration.setupTLS(result, tlsProperties);
        return result;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"org.springframework.web.client.RestTemplate"})
    EurekaClientHttpRequestFactorySupplier defaultEurekaClientHttpRequestFactorySupplier(RestTemplateTimeoutProperties restTemplateTimeoutProperties) {
        return new DefaultEurekaClientHttpRequestFactorySupplier(restTemplateTimeoutProperties);
    }

    @Bean
    @ConditionalOnClass(name={"com.sun.jersey.api.client.filter.ClientFilter"})
    @ConditionalOnMissingBean(value={AbstractDiscoveryClientOptionalArgs.class}, search=SearchStrategy.CURRENT)
    public MutableDiscoveryClientOptionalArgs discoveryClientOptionalArgs(TlsProperties tlsProperties) throws GeneralSecurityException, IOException {
        logger.info((Object)"Eureka HTTP Client uses Jersey");
        MutableDiscoveryClientOptionalArgs result = new MutableDiscoveryClientOptionalArgs();
        DiscoveryClientOptionalArgsConfiguration.setupTLS(result, tlsProperties);
        return result;
    }

    private static void setupTLS(AbstractDiscoveryClientOptionalArgs<?> args, TlsProperties properties) throws GeneralSecurityException, IOException {
        if (properties.isEnabled()) {
            SSLContextFactory factory = new SSLContextFactory(properties);
            args.setSSLContext(factory.createSSLContext());
        }
    }

    @Configuration
    @ConditionalOnMissingClass(value={"com.sun.jersey.api.client.filter.ClientFilter", "org.springframework.web.reactive.function.client.WebClient"})
    @ConditionalOnProperty(prefix="eureka.client", name={"webclient.enabled"}, havingValue="true")
    protected static class WebClientNotFoundConfiguration {
        public WebClientNotFoundConfiguration() {
            throw new IllegalStateException("eureka.client.webclient.enabled is true, but WebClient is not on the classpath. Please add spring-boot-starter-webflux as a dependency.");
        }
    }

    @ConditionalOnMissingClass(value={"com.sun.jersey.api.client.filter.ClientFilter"})
    @ConditionalOnClass(name={"org.springframework.web.reactive.function.client.WebClient"})
    @ConditionalOnProperty(prefix="eureka.client", name={"webclient.enabled"}, havingValue="true")
    protected static class WebClientConfiguration {
        @Autowired
        private TlsProperties tlsProperties;

        protected WebClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={AbstractDiscoveryClientOptionalArgs.class, RestTemplateDiscoveryClientOptionalArgs.class}, search=SearchStrategy.CURRENT)
        public WebClientDiscoveryClientOptionalArgs webClientDiscoveryClientOptionalArgs(ObjectProvider<WebClient.Builder> builder) throws GeneralSecurityException, IOException {
            logger.info((Object)"Eureka HTTP Client uses WebClient.");
            WebClientDiscoveryClientOptionalArgs result = new WebClientDiscoveryClientOptionalArgs(() -> builder.getIfAvailable());
            DiscoveryClientOptionalArgsConfiguration.setupTLS(result, this.tlsProperties);
            return result;
        }
    }
}

