/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.monitor.scheduled;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.governance.common.conf.GovernanceCommonConf;
import org.apache.linkis.monitor.config.MonitorConfig;
import org.apache.linkis.monitor.constants.Constants;
import org.apache.linkis.monitor.entity.IndexEntity;
import org.apache.linkis.monitor.until.HttpsUntils;
import org.apache.linkis.monitor.utils.alert.AlertDesc;
import org.apache.linkis.monitor.utils.alert.ims.MonitorAlertUtils;
import org.apache.linkis.monitor.utils.alert.ims.PooledImsAlertUtils;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.server.BDPJettyServerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.PropertySource;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@PropertySource(value={"classpath:linkis-et-monitor.properties"}, encoding="UTF-8")
public class EntranceTaskMonitor {
    private static final Logger logger = LoggerFactory.getLogger(EntranceTaskMonitor.class);
    private static final String ENTRANCE_RUNNING_TASK = "entrance_running_task";
    private static final String ENTRANCE_QUEUED_TASK = "entrance_queued_task";
    private static final String ENTRANCE_TOTAL_TASK = "entrance_total_task";

    @Scheduled(cron="${linkis.monitor.entrance.task.cron}")
    public void entranceTask() throws IOException {
        List userlist = new ArrayList();
        String value = (String)MonitorConfig.ENTRANCE_TASK_USERLIST.getValue();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            userlist = (List)BDPJettyServerHelper.gson().fromJson(value, ArrayList.class);
        }
        userlist.forEach(entranceEntity -> {
            Map<String, AlertDesc> ecmResourceAlerts;
            Map data = new HashMap();
            try {
                data = MapUtils.getMap(HttpsUntils.getEntranceTask(null, (String)entranceEntity.get((Object)"username"), null), (Object)"data");
                logger.info("TaskMonitor userlist response  {}:", data);
            }
            catch (IOException e) {
                logger.warn("failed to get EntranceTask data");
            }
            int runningNumber = null != entranceEntity.get((Object)"runningtasks") ? Integer.parseInt((String)entranceEntity.get((Object)"runningtasks")) : 0;
            int queuedNumber = null != entranceEntity.get((Object)"queuedtasks") ? Integer.parseInt((String)entranceEntity.get((Object)"queuedtasks")) : 0;
            BigDecimal runningtotal = new BigDecimal((Integer)data.get("runningNumber"));
            BigDecimal queuedtotal = new BigDecimal((Integer)data.get("queuedNumber"));
            BigDecimal total = runningtotal.add(queuedtotal);
            HashMap<String, String> parms = new HashMap<String, String>();
            parms.put("$username", (String)entranceEntity.get((Object)"username"));
            parms.put("$alteruser", (String)entranceEntity.get((Object)"alteruser"));
            parms.put("$url", (String)Configuration.GATEWAY_URL().getValue());
            if (runningtotal.intValue() > runningNumber) {
                parms.put("$runningtask", String.valueOf(runningNumber));
                ecmResourceAlerts = MonitorAlertUtils.getAlerts(Constants.ALERT_RESOURCE_MONITOR(), parms);
                PooledImsAlertUtils.addAlert(ecmResourceAlerts.get("12005"));
            }
            if (queuedtotal.intValue() > queuedNumber) {
                parms.put("$queuedtask", String.valueOf(queuedNumber));
                ecmResourceAlerts = MonitorAlertUtils.getAlerts(Constants.ALERT_RESOURCE_MONITOR(), parms);
                PooledImsAlertUtils.addAlert(ecmResourceAlerts.get("12006"));
            }
            int usertotalTask = (Integer)MonitorConfig.ENTRANCE_TASK_USERTOTAL.getValue();
            if (total.intValue() > usertotalTask) {
                parms.put("$tasktotal", String.valueOf(usertotalTask));
                Map<String, AlertDesc> ecmResourceAlerts2 = MonitorAlertUtils.getAlerts(Constants.ALERT_RESOURCE_MONITOR(), parms);
                PooledImsAlertUtils.addAlert(ecmResourceAlerts2.get("12007"));
            }
        });
        Map likisData = null;
        try {
            likisData = MapUtils.getMap(HttpsUntils.getEntranceTask(null, "hadoop", null), (Object)"data");
            logger.info("TaskMonitor hadoop response  {}:", (Object)likisData);
        }
        catch (IOException e) {
            logger.warn("failed to get EntranceTask data");
        }
        BigDecimal runningNumber = new BigDecimal((Integer)likisData.get("runningNumber"));
        BigDecimal queuedNumber = new BigDecimal((Integer)likisData.get("queuedNumber"));
        BigDecimal total = runningNumber.add(queuedNumber);
        HashMap<String, String> parms = new HashMap<String, String>();
        parms.put("$url", (String)Configuration.GATEWAY_URL().getValue());
        int linkisTotalMajor = (Integer)MonitorConfig.ENTRANCE_TASK_TOTAL_MAJOR.getValue();
        int linkisTotalMinor = (Integer)MonitorConfig.ENTRANCE_TASK_TOTAL_MINOR.getValue();
        if (total.intValue() >= linkisTotalMajor) {
            parms.put("$taskmajor", String.valueOf(linkisTotalMajor));
            logger.info("TaskMonitor parms {}:", parms);
            Map<String, AlertDesc> ecmResourceAlerts = MonitorAlertUtils.getAlerts(Constants.ALERT_RESOURCE_MONITOR(), parms);
            PooledImsAlertUtils.addAlert(ecmResourceAlerts.get("12009"));
        } else if (total.intValue() >= linkisTotalMinor) {
            parms.put("$taskminor", String.valueOf(linkisTotalMinor));
            logger.info("TaskMonitor parms {}:", parms);
            Map<String, AlertDesc> ecmResourceAlerts = MonitorAlertUtils.getAlerts(Constants.ALERT_RESOURCE_MONITOR(), parms);
            PooledImsAlertUtils.addAlert(ecmResourceAlerts.get("12008"));
        }
        EntranceTaskMonitor.resourceSendToIms();
    }

    public static void resourceSendToIms() {
        ServiceInstance[] entranceServiceInstances = Sender.getInstances((String)((String)GovernanceCommonConf.ENTRANCE_SERVICE_NAME().getValue()));
        if (null != entranceServiceInstances) {
            for (ServiceInstance instance : entranceServiceInstances) {
                String entranceService = instance.getInstance();
                try {
                    Map entranceData = MapUtils.getMap(HttpsUntils.getEntranceTask(null, "hadoop", entranceService), (Object)"data");
                    int runningTaskNumber = 0;
                    int queuedTaskNumber = 0;
                    int totalTaskNumber = 0;
                    if (entranceData.containsKey("runningNumber")) {
                        runningTaskNumber = (Integer)entranceData.get("runningNumber");
                    }
                    if (entranceData.containsKey("queuedNumber")) {
                        queuedTaskNumber = (Integer)entranceData.get("queuedNumber");
                    }
                    totalTaskNumber = runningTaskNumber + queuedTaskNumber;
                    logger.info("ResourceMonitor send index ");
                    ArrayList<IndexEntity> list = new ArrayList<IndexEntity>();
                    list.add(new IndexEntity(entranceService, "entrance", ENTRANCE_RUNNING_TASK, HttpsUntils.localHost, String.valueOf(runningTaskNumber)));
                    list.add(new IndexEntity(entranceService, "entrance", ENTRANCE_QUEUED_TASK, HttpsUntils.localHost, String.valueOf(queuedTaskNumber)));
                    list.add(new IndexEntity(entranceService, "entrance", ENTRANCE_TOTAL_TASK, HttpsUntils.localHost, String.valueOf(totalTaskNumber)));
                    HttpsUntils.sendIndex(list);
                }
                catch (IOException e) {
                    logger.warn("failed to send EcmResource index :" + e);
                }
            }
        }
    }
}

