/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.service.Server;
import springfox.documentation.service.ServerVariable;
import springfox.documentation.service.VendorExtension;

public class ServerBuilder {
    private String name;
    private String url;
    private String description;
    private final List<ServerVariable> variables = new ArrayList<ServerVariable>();
    private final List<VendorExtension> extensions = new ArrayList<VendorExtension>();

    public ServerBuilder name(String name) {
        this.name = name;
        return this;
    }

    public ServerBuilder url(String url) {
        this.url = url;
        return this;
    }

    public ServerBuilder description(String description) {
        this.description = description;
        return this;
    }

    public ServerBuilder variables(Collection<ServerVariable> variables) {
        this.variables.addAll(BuilderDefaults.nullToEmptyList(variables));
        return this;
    }

    public ServerBuilder extensions(Collection<VendorExtension> extensions) {
        this.extensions.addAll(BuilderDefaults.nullToEmptyList(extensions));
        return this;
    }

    public Server build() {
        return new Server(this.name, this.url, this.description, this.variables, this.extensions);
    }
}

