/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Locale;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.FilteredDocIdSetIterator;
import org.apache.lucene.util.LiveDocs;
import org.apache.lucene.util.SparseFixedBitSet;

public final class SparseLiveDocs
implements LiveDocs {
    private final SparseFixedBitSet deletedDocs;
    private final int maxDoc;
    private final int deletedCount;

    public static Builder builder(SparseFixedBitSet deletedDocs, int maxDoc) {
        return new Builder(deletedDocs, maxDoc);
    }

    private SparseLiveDocs(SparseFixedBitSet deletedDocs, int maxDoc, int deletedCount) {
        assert (deletedDocs.length >= maxDoc);
        this.maxDoc = maxDoc;
        this.deletedDocs = deletedDocs;
        this.deletedCount = deletedCount;
    }

    @Override
    public boolean get(int index) {
        return !this.deletedDocs.get(index);
    }

    @Override
    public int length() {
        return this.maxDoc;
    }

    @Override
    public DocIdSetIterator liveDocsIterator() {
        return new FilteredDocIdSetIterator(this.maxDoc, this.maxDoc - this.deletedCount, doc -> !this.deletedDocs.get(doc));
    }

    @Override
    public DocIdSetIterator deletedDocsIterator() {
        return new BitSetIterator(this.deletedDocs, this.deletedCount);
    }

    @Override
    public int deletedCount() {
        return this.deletedCount;
    }

    public long ramBytesUsed() {
        return this.deletedDocs.ramBytesUsed();
    }

    public String toString() {
        return "SparseLiveDocs(maxDoc=" + this.maxDoc + ", deleted=" + this.deletedCount() + ", deletionRate=" + String.format(Locale.ROOT, "%.2f%%", 100.0 * (double)this.deletedCount() / (double)this.maxDoc) + ")";
    }

    public static final class Builder {
        private final SparseFixedBitSet deletedDocs;
        private final int maxDoc;
        private Integer deletedCount;

        private Builder(SparseFixedBitSet deletedDocs, int maxDoc) {
            this.deletedDocs = deletedDocs;
            this.maxDoc = maxDoc;
        }

        public Builder withDeletedCount(int deletedCount) {
            this.deletedCount = deletedCount;
            return this;
        }

        public SparseLiveDocs build() {
            int count;
            int n = count = this.deletedCount != null ? this.deletedCount.intValue() : this.deletedDocs.cardinality();
            if (count < 0 || count > this.maxDoc) {
                throw new IllegalArgumentException("deletedCount=" + count + " is outside valid range [0, " + this.maxDoc + "]");
            }
            assert (count == this.deletedDocs.cardinality()) : "deletedCount=" + count + " does not match deletedDocs.cardinality()=" + this.deletedDocs.cardinality();
            return new SparseLiveDocs(this.deletedDocs, this.maxDoc, count);
        }
    }
}

