/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.codecs.asserting;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.codecs.KnnFieldVectorsWriter;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.hnsw.HnswGraphProvider;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.search.AcceptDocs;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.tests.search.AssertingAcceptDocs;
import org.apache.lucene.tests.util.TestUtil;
import org.apache.lucene.util.hnsw.HnswGraph;

public class AssertingKnnVectorsFormat
extends KnnVectorsFormat {
    private final KnnVectorsFormat delegate = TestUtil.getDefaultKnnVectorsFormat();

    public AssertingKnnVectorsFormat() {
        super("Asserting");
    }

    public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new AssertingKnnVectorsWriter(this.delegate.fieldsWriter(state));
    }

    public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return new AssertingKnnVectorsReader(this.delegate.fieldsReader(state), state.fieldInfos);
    }

    public int getMaxDimensions(String fieldName) {
        return 1024;
    }

    static class AssertingKnnVectorsWriter
    extends KnnVectorsWriter {
        final KnnVectorsWriter delegate;

        AssertingKnnVectorsWriter(KnnVectorsWriter delegate) {
            assert (delegate != null);
            this.delegate = delegate;
        }

        public KnnFieldVectorsWriter<?> addField(FieldInfo fieldInfo) throws IOException {
            return this.delegate.addField(fieldInfo);
        }

        public void flush(int maxDoc, Sorter.DocMap sortMap) throws IOException {
            this.delegate.flush(maxDoc, sortMap);
        }

        public void mergeOneField(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
            assert (fieldInfo != null);
            assert (mergeState != null);
            this.delegate.mergeOneField(fieldInfo, mergeState);
        }

        public void finish() throws IOException {
            this.delegate.finish();
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public long ramBytesUsed() {
            return this.delegate.ramBytesUsed();
        }
    }

    public static class AssertingKnnVectorsReader
    extends KnnVectorsReader
    implements HnswGraphProvider {
        public final KnnVectorsReader delegate;
        private final FieldInfos fis;
        private final AtomicInteger mergeInstanceCount = new AtomicInteger();
        private final AtomicInteger finishMergeCount = new AtomicInteger();

        private AssertingKnnVectorsReader(KnnVectorsReader delegate, FieldInfos fis) {
            assert (delegate != null);
            this.delegate = delegate;
            this.fis = fis;
        }

        public void checkIntegrity() throws IOException {
            this.delegate.checkIntegrity();
        }

        public FloatVectorValues getFloatVectorValues(String field) throws IOException {
            FieldInfo fi = this.fis.fieldInfo(field);
            assert (fi != null && fi.getVectorDimension() > 0 && fi.getVectorEncoding() == VectorEncoding.FLOAT32);
            FloatVectorValues floatValues = this.delegate.getFloatVectorValues(field);
            assert (floatValues != null);
            assert (floatValues.iterator().docID() == -1);
            assert (floatValues.size() >= 0);
            assert (floatValues.dimension() > 0);
            return floatValues;
        }

        public ByteVectorValues getByteVectorValues(String field) throws IOException {
            FieldInfo fi = this.fis.fieldInfo(field);
            assert (fi != null && fi.getVectorDimension() > 0 && fi.getVectorEncoding() == VectorEncoding.BYTE);
            ByteVectorValues values = this.delegate.getByteVectorValues(field);
            assert (values != null);
            assert (values.iterator().docID() == -1);
            assert (values.size() >= 0);
            assert (values.dimension() > 0);
            return values;
        }

        public void search(String field, float[] target, KnnCollector knnCollector, AcceptDocs acceptDocs) throws IOException {
            FieldInfo fi = this.fis.fieldInfo(field);
            assert (fi != null && fi.getVectorDimension() > 0 && fi.getVectorEncoding() == VectorEncoding.FLOAT32);
            acceptDocs = AssertingAcceptDocs.wrap(acceptDocs);
            this.delegate.search(field, target, knnCollector, acceptDocs);
        }

        public void search(String field, byte[] target, KnnCollector knnCollector, AcceptDocs acceptDocs) throws IOException {
            FieldInfo fi = this.fis.fieldInfo(field);
            assert (fi != null && fi.getVectorDimension() > 0 && fi.getVectorEncoding() == VectorEncoding.BYTE);
            acceptDocs = AssertingAcceptDocs.wrap(acceptDocs);
            this.delegate.search(field, target, knnCollector, acceptDocs);
        }

        public KnnVectorsReader getMergeInstance() throws IOException {
            KnnVectorsReader mergeVectorsReader = this.delegate.getMergeInstance();
            assert (mergeVectorsReader != null);
            this.mergeInstanceCount.incrementAndGet();
            final AtomicInteger parentMergeFinishCount = this.finishMergeCount;
            return new AssertingKnnVectorsReader(this, mergeVectorsReader, this.fis){
                private boolean finished;

                @Override
                public void search(String field, float[] target, KnnCollector knnCollector, AcceptDocs acceptDocs) {
                    assert (false) : "This instance should only be used for merging";
                }

                @Override
                public void search(String field, byte[] target, KnnCollector knnCollector, AcceptDocs acceptDocs) {
                    assert (false) : "This instance should only be used for merging";
                }

                @Override
                public KnnVectorsReader getMergeInstance() {
                    assert (false);
                    return null;
                }

                @Override
                public void finishMerge() throws IOException {
                    assert (!this.finished) : "Merging already finished";
                    this.finished = true;
                    this.delegate.finishMerge();
                    parentMergeFinishCount.incrementAndGet();
                }

                @Override
                public void close() {
                    assert (false);
                }
            };
        }

        public void finishMerge() throws IOException {
            assert (false);
        }

        public Map<String, Long> getOffHeapByteSize(FieldInfo fieldInfo) {
            return this.delegate.getOffHeapByteSize(fieldInfo);
        }

        public void close() throws IOException {
            this.delegate.close();
            this.delegate.close();
            assert (this.finishMergeCount.get() <= 0 || this.mergeInstanceCount.get() == this.finishMergeCount.get());
        }

        public HnswGraph getGraph(String field) throws IOException {
            return ((HnswGraphProvider)this.delegate).getGraph(field);
        }
    }
}

