/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server;

import java.io.EOFException;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.HTTP2Cipher;
import org.eclipse.jetty.http2.HTTP2Stream;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.api.server.ServerSessionListener;
import org.eclipse.jetty.http2.frames.GoAwayFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.http2.server.AbstractHTTP2ServerConnectionFactory;
import org.eclipse.jetty.http2.server.internal.HTTP2ServerConnection;
import org.eclipse.jetty.http2.server.internal.HTTP2ServerSession;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.QuietException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.NegotiatingServerConnection;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP2ServerConnectionFactory
extends AbstractHTTP2ServerConnectionFactory
implements NegotiatingServerConnection.CipherDiscriminator {
    private static final Logger LOG = LoggerFactory.getLogger(HTTP2ServerConnectionFactory.class);

    public HTTP2ServerConnectionFactory() {
        this(new HttpConfiguration());
    }

    public HTTP2ServerConnectionFactory(@Name(value="config") HttpConfiguration httpConfiguration) {
        super(httpConfiguration);
        httpConfiguration.addCustomizer((HttpConfiguration.Customizer)new AltSvcCustomizer());
    }

    public HTTP2ServerConnectionFactory(@Name(value="config") HttpConfiguration httpConfiguration, String ... protocols) {
        super(httpConfiguration, protocols);
        httpConfiguration.addCustomizer((HttpConfiguration.Customizer)new AltSvcCustomizer());
    }

    @Override
    protected ServerSessionListener newSessionListener(Connector connector, EndPoint endPoint) {
        return new HTTPServerSessionListener(endPoint);
    }

    public boolean isAcceptable(String protocol, String tlsProtocol, String tlsCipher) {
        boolean acceptable;
        boolean bl = acceptable = "h2-14".equals(protocol) || !HTTP2Cipher.isBlackListProtocol((String)tlsProtocol) || !HTTP2Cipher.isBlackListCipher((String)tlsCipher);
        if (LOG.isDebugEnabled()) {
            LOG.debug("proto={} tls={} cipher={} 9.2.2-acceptable={}", new Object[]{protocol, tlsProtocol, tlsCipher, acceptable});
        }
        return acceptable;
    }

    public static class AltSvcCustomizer
    implements HttpConfiguration.Customizer {
        private Duration _maxAge;
        private boolean _persist;

        public Duration getMaxAge() {
            return this._maxAge;
        }

        public void setMaxAge(Duration maxAge) {
            this._maxAge = maxAge;
        }

        public boolean isPersist() {
            return this._persist;
        }

        public void setPersist(boolean persist) {
            this._persist = persist;
        }

        public Request customize(Request request, HttpFields.Mutable responseHeaders) {
            if (HttpVersion.HTTP_2 != request.getConnectionMetaData().getHttpVersion()) {
                return request;
            }
            Server server = request.getConnectionMetaData().getConnector().getServer();
            for (Connector connector : server.getConnectors()) {
                if (!(connector instanceof NetworkConnector)) continue;
                NetworkConnector nc = (NetworkConnector)connector;
                if (!connector.getProtocols().contains("h3")) continue;
                int port = nc.getLocalPort();
                if (port <= 0) break;
                StringBuilder altSvc = new StringBuilder();
                altSvc.append(String.format("h3=\":%d\"", port));
                if (this._maxAge != null) {
                    altSvc.append(String.format("; ma=%d", this._maxAge.toSeconds()));
                }
                if (this._persist) {
                    altSvc.append("; persist=1");
                }
                responseHeaders.add(HttpHeader.ALT_SVC, altSvc.toString());
                break;
            }
            return request;
        }
    }

    protected class HTTPServerSessionListener
    implements HTTP2ServerSession.Listener,
    Stream.Listener {
        private final EndPoint endPoint;

        public HTTPServerSessionListener(EndPoint endPoint) {
            this.endPoint = endPoint;
        }

        private HTTP2ServerConnection getConnection() {
            return (HTTP2ServerConnection)this.endPoint.getConnection();
        }

        public Map<Integer, Integer> onPreface(Session session) {
            return HTTP2ServerConnectionFactory.this.newSettings();
        }

        public Stream.Listener onNewStream(Stream stream, HeadersFrame frame) {
            this.getConnection().onNewStream((HTTP2Stream)stream, frame);
            return this;
        }

        public boolean onIdleTimeout(Session session) {
            long idleTimeout = this.getConnection().getEndPoint().getIdleTimeout();
            return this.getConnection().onSessionTimeout(new TimeoutException("Session idle timeout " + idleTimeout + " ms"));
        }

        public void onClose(Session session, GoAwayFrame frame, Callback callback) {
            Object reason = frame.tryConvertPayload();
            if (!StringUtil.isEmpty((String)reason)) {
                reason = " (" + (String)reason + ")";
            }
            EofException failure = new EofException(String.format("Close %s/%s", ErrorCode.toString((int)frame.getError(), null), reason));
            this.onFailure(session, (Throwable)failure, callback);
        }

        public void onFailure(Session session, Throwable failure, Callback callback) {
            this.getConnection().onSessionFailure(failure, callback);
        }

        @Override
        public void onStreamFailure(Stream stream, Throwable failure, Callback callback) {
            this.onFailure(stream, failure, callback);
        }

        public void onHeaders(Stream stream, HeadersFrame frame) {
            if (frame.isEndStream()) {
                this.getConnection().onTrailers(stream, frame);
            } else {
                this.close(stream, "invalid_trailers");
            }
        }

        public Stream.Listener onPush(Stream stream, PushPromiseFrame frame) {
            this.close(stream, "push_promise");
            return null;
        }

        public void onDataAvailable(Stream stream, boolean immediate) {
            this.getConnection().onDataAvailable(stream, immediate);
        }

        public void onReset(Stream stream, ResetFrame frame, Callback callback) {
            EOFException failure = new EOFException("Reset " + ErrorCode.toString((int)frame.getError(), null));
            this.onFailure(stream, (Throwable)failure, callback);
        }

        public void onFailure(Stream stream, int error, String reason, Throwable failure, Callback callback) {
            if (!(failure instanceof QuietException)) {
                failure = new EofException(failure);
            }
            this.onFailure(stream, failure, callback);
        }

        private void onFailure(Stream stream, Throwable failure, Callback callback) {
            this.getConnection().onStreamFailure(stream, failure, callback);
        }

        public void onIdleTimeout(Stream stream, TimeoutException x, Promise<Boolean> promise) {
            this.getConnection().onStreamTimeout(stream, x, promise);
        }

        private void close(Stream stream, String reason) {
            stream.getSession().close(ErrorCode.PROTOCOL_ERROR.code, reason, Callback.NOOP);
        }
    }
}

