/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.scanner;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.flywaydb.core.api.ClassProvider;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.internal.scanner.ClasspathLocationHandler;
import org.flywaydb.core.internal.scanner.ReadOnlyLocationHandler;
import org.flywaydb.core.internal.util.StringUtils;

public class Scanner<I>
implements ResourceProvider,
ClassProvider<I> {
    @Generated
    private static final Log LOG = LogFactory.getLog(Scanner.class);
    private final Collection<LoadableResource> resources = new ArrayList<LoadableResource>();
    private final Collection<Class<? extends I>> classes = new ArrayList<Class<? extends I>>();
    private final HashMap<String, LoadableResource> relativeResourceMap = new HashMap();
    private HashMap<String, LoadableResource> absoluteResourceMap;

    public Scanner(Class<? extends I> implementedInterface, Configuration configuration, Location[] locations) {
        List<ReadOnlyLocationHandler> locationHandlers = configuration.getPluginRegister().getInstancesOf(ReadOnlyLocationHandler.class);
        Arrays.stream(locations).forEach(location -> locationHandlers.stream().filter(x -> x.canHandleLocation((Location)location)).findFirst().ifPresent(readOnlyLocationHandler -> this.resources.addAll(readOnlyLocationHandler.scanForResources((Location)location, configuration))));
        for (LoadableResource resource : this.resources) {
            this.relativeResourceMap.put(resource.getRelativePath().toLowerCase(Locale.ROOT), resource);
        }
        List<ClasspathLocationHandler> classpathLocationHandlers = configuration.getPluginRegister().getInstancesOf(ClasspathLocationHandler.class);
        Arrays.stream(locations).forEach(location -> classpathLocationHandlers.stream().filter(x -> x.canHandleLocation((Location)location)).findFirst().ifPresent(classpathLocationHandler -> this.classes.addAll(classpathLocationHandler.scanForClasses(implementedInterface, (Location)location, configuration))));
    }

    @Override
    public LoadableResource getResource(String name) {
        LoadableResource loadedResource = this.relativeResourceMap.get(name.toLowerCase(Locale.ROOT));
        if (loadedResource != null) {
            return loadedResource;
        }
        if (Paths.get(name, new String[0]).isAbsolute()) {
            if (this.absoluteResourceMap == null) {
                this.absoluteResourceMap = new HashMap();
                for (LoadableResource resource : this.resources) {
                    this.absoluteResourceMap.put(resource.getAbsolutePathOnDisk().toLowerCase(Locale.ROOT), resource);
                }
            }
            loadedResource = this.absoluteResourceMap.get(name.toLowerCase(Locale.ROOT));
            return loadedResource;
        }
        return null;
    }

    @Override
    public Collection<LoadableResource> getResources(String prefix, String ... suffixes) {
        ArrayList<LoadableResource> result = new ArrayList<LoadableResource>();
        for (LoadableResource resource : this.resources) {
            String fileName = resource.getFilename();
            if (StringUtils.startsAndEndsWith(fileName, prefix, suffixes)) {
                result.add(resource);
                continue;
            }
            LOG.debug("Filtering out resource: " + resource.getAbsolutePath() + " (filename: " + fileName + ")");
        }
        return result;
    }

    @Override
    public Collection<Class<? extends I>> getClasses() {
        return Collections.unmodifiableCollection(this.classes);
    }
}

