/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.langdetect;

import java.io.Serializable;
import java.util.Objects;

public class Language
implements Serializable {
    private static final long serialVersionUID = -2692630786925291644L;
    private final String lang;
    private final double confidence;

    public Language(String lang) {
        this(lang, 0.0);
    }

    public Language(String lang, double confidence) {
        Objects.requireNonNull(lang, "lang must not be null");
        this.lang = lang;
        this.confidence = confidence;
    }

    public String getLang() {
        return this.lang;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public String toString() {
        return this.getLang() + " (" + this.confidence + ")";
    }

    public int hashCode() {
        return Objects.hash(this.getLang(), this.getConfidence());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Language) {
            Language a = (Language)obj;
            return this.getLang().equals(a.getLang());
        }
        return false;
    }
}

