/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.hdds.utils.db.CopyObject;
import org.apache.hadoop.ozone.util.WithChecksum;
import org.apache.ozone.compaction.log.SstFileInfo;
import org.rocksdb.LiveFileMetaData;
import org.yaml.snakeyaml.Yaml;

public class OmSnapshotLocalData
implements WithChecksum<OmSnapshotLocalData> {
    private UUID snapshotId;
    private int version;
    private String checksum;
    private boolean isSSTFiltered;
    private long lastDefragTime;
    private boolean needsDefrag;
    private UUID previousSnapshotId;
    private final LinkedHashMap<Integer, VersionMeta> versionSstFileInfos;
    public static final Charset CHARSET_ENCODING = StandardCharsets.UTF_8;
    private static final String DUMMY_CHECKSUM = new String(new byte[64], CHARSET_ENCODING);

    public OmSnapshotLocalData(UUID snapshotId, List<LiveFileMetaData> notDefraggedSSTFileList, UUID previousSnapshotId) {
        this.snapshotId = snapshotId;
        this.isSSTFiltered = false;
        this.lastDefragTime = 0L;
        this.needsDefrag = false;
        this.versionSstFileInfos = new LinkedHashMap();
        this.versionSstFileInfos.put(0, new VersionMeta(0, notDefraggedSSTFileList.stream().map(SstFileInfo::new).collect(Collectors.toList())));
        this.version = 0;
        this.previousSnapshotId = previousSnapshotId;
        this.setChecksumTo0ByteArray();
    }

    public OmSnapshotLocalData(OmSnapshotLocalData source) {
        this.isSSTFiltered = source.isSSTFiltered;
        this.lastDefragTime = source.lastDefragTime;
        this.needsDefrag = source.needsDefrag;
        this.checksum = source.checksum;
        this.version = source.version;
        this.snapshotId = source.snapshotId;
        this.previousSnapshotId = source.previousSnapshotId;
        this.versionSstFileInfos = new LinkedHashMap();
        this.setVersionSstFileInfos(source.versionSstFileInfos);
    }

    public boolean getSstFiltered() {
        return this.isSSTFiltered;
    }

    public void setSstFiltered(boolean sstFiltered) {
        this.isSSTFiltered = sstFiltered;
    }

    public long getLastDefragTime() {
        return this.lastDefragTime;
    }

    public void setLastDefragTime(Long lastDefragTime) {
        this.lastDefragTime = lastDefragTime;
    }

    public boolean getNeedsDefrag() {
        return this.needsDefrag;
    }

    public void setNeedsDefrag(boolean needsDefrag) {
        this.needsDefrag = needsDefrag;
    }

    public Map<Integer, VersionMeta> getVersionSstFileInfos() {
        return Collections.unmodifiableMap(this.versionSstFileInfos);
    }

    public void setVersionSstFileInfos(Map<Integer, VersionMeta> versionSstFileInfos) {
        this.versionSstFileInfos.clear();
        this.versionSstFileInfos.putAll(versionSstFileInfos);
    }

    public UUID getPreviousSnapshotId() {
        return this.previousSnapshotId;
    }

    public UUID getSnapshotId() {
        return this.snapshotId;
    }

    public void setPreviousSnapshotId(UUID previousSnapshotId) {
        this.previousSnapshotId = previousSnapshotId;
    }

    public void addVersionSSTFileInfos(List<SstFileInfo> sstFiles, int previousSnapshotVersion) {
        ++this.version;
        this.versionSstFileInfos.put(this.version, new VersionMeta(previousSnapshotVersion, sstFiles));
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public void setChecksumTo0ByteArray() {
        this.checksum = DUMMY_CHECKSUM;
    }

    public void computeAndSetChecksum(Yaml yaml) throws IOException {
        this.setChecksumTo0ByteArray();
        String snapshotDataYamlStr = yaml.dump((Object)this);
        this.checksum = OmSnapshotLocalData.getChecksum(snapshotDataYamlStr);
    }

    private static String getChecksum(String data) throws IOException {
        try {
            return DigestUtils.sha256Hex((byte[])data.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception ex) {
            throw new IOException("Unable to calculate checksum", ex);
        }
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public OmSnapshotLocalData copyObject() {
        return new OmSnapshotLocalData(this);
    }

    public static class VersionMeta
    implements CopyObject<VersionMeta> {
        private final int previousSnapshotVersion;
        private final List<SstFileInfo> sstFiles;

        public VersionMeta(int previousSnapshotVersion, List<SstFileInfo> sstFiles) {
            this.previousSnapshotVersion = previousSnapshotVersion;
            this.sstFiles = Collections.unmodifiableList(sstFiles);
        }

        public int getPreviousSnapshotVersion() {
            return this.previousSnapshotVersion;
        }

        public List<SstFileInfo> getSstFiles() {
            return this.sstFiles;
        }

        public VersionMeta copyObject() {
            return new VersionMeta(this.previousSnapshotVersion, this.sstFiles.stream().map(SstFileInfo::copyObject).collect(Collectors.toList()));
        }

        public int hashCode() {
            return Objects.hash(this.previousSnapshotVersion, this.sstFiles);
        }

        public final boolean equals(Object o) {
            if (!(o instanceof VersionMeta)) {
                return false;
            }
            VersionMeta that = (VersionMeta)o;
            return this.previousSnapshotVersion == that.previousSnapshotVersion && this.sstFiles.equals(that.sstFiles);
        }

        public String toString() {
            return "VersionMeta{previousSnapshotVersion=" + this.previousSnapshotVersion + ", sstFiles=" + this.sstFiles + '}';
        }
    }
}

