/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.snapshot;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OmSnapshotManager;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"deletedTable", "snapshotRenamedTable", "snapshotInfoTable"})
public class OMSnapshotCreateResponse
extends OMClientResponse {
    private SnapshotInfo snapshotInfo;

    public OMSnapshotCreateResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull SnapshotInfo snapshotInfo) {
        super(omResponse);
        this.snapshotInfo = snapshotInfo;
    }

    public OMSnapshotCreateResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        String key = this.snapshotInfo.getTableKey();
        omMetadataManager.getSnapshotInfoTable().putWithBatch(batchOperation, (Object)key, (Object)this.snapshotInfo);
        OmSnapshotManager.createOmSnapshotCheckpoint(omMetadataManager, this.snapshotInfo, batchOperation);
    }
}

