/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.service;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.hdds.utils.db.RDBStore;
import org.apache.hadoop.hdds.utils.db.RocksDatabase;
import org.apache.hadoop.hdds.utils.db.managed.ManagedCompactRangeOptions;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.util.Time;
import org.rocksdb.CompactRangeOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactDBService {
    private static final Logger LOG = LoggerFactory.getLogger(CompactDBService.class);
    private final OzoneManager om;

    public CompactDBService(OzoneManager ozoneManager) {
        this.om = ozoneManager;
    }

    public CompletableFuture<Void> compact(String columnFamily) throws IOException {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.compactAsync(columnFamily);
            }
            catch (Exception e) {
                LOG.warn("Failed to compact column family: {}", (Object)columnFamily, (Object)e);
                return null;
            }
        });
    }

    private Void compactAsync(String columnFamilyName) throws IOException {
        LOG.info("Compacting column family: {}", (Object)columnFamilyName);
        long startTime = Time.monotonicNow();
        ManagedCompactRangeOptions options = new ManagedCompactRangeOptions();
        options.setBottommostLevelCompaction(CompactRangeOptions.BottommostLevelCompaction.kForce);
        RocksDatabase.ColumnFamily columnFamily = ((RDBStore)this.om.getMetadataManager().getStore()).getDb().getColumnFamily(columnFamilyName);
        ((RDBStore)this.om.getMetadataManager().getStore()).getDb().compactRange(columnFamily, null, null, options);
        LOG.info("Compaction of column family: {} completed in {} ms", (Object)columnFamilyName, (Object)(Time.monotonicNow() - startTime));
        return null;
    }
}

